/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.*;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

import javax.swing.*;
import java.util.Vector;

/**
 *
 * @author  Martin Grebac
 */
public class SignEncryptTargetChooserPanel extends javax.swing.JPanel {
    
    private BindingMessage message;
    private WSDLModel model;
    
    private Vector<MessageListElement> signedTargetsListModel;
    private Vector<MessageListElement> encryptedTargetsListModel;

    private AddElementPanel addElementPanel;
    private AddHeaderPanel addHeaderPanel;
    private AddBodyPanel addBodyPanel;
    
    private Binding binding;
    
    boolean inSync = false;
    
    /**
     * Creates new form SignEncryptTargetChooserPanel
     */
    public SignEncryptTargetChooserPanel(BindingMessage message, Binding b) {
        super();
        this.message = message;
        this.model = b.getModel();
        this.binding = b;
        initComponents();
        initComponents2();

        sync();
    }
    
    private void initComponents2() {
        addBodyButton.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_AddBody"));
        addHeaderButton.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_AddHeader"));
        removeButton.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_Remove"));
        addPartButton.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_AddElement"));
        signedTargetsLabel.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_SignedTargetsLabel"));
        defaultSignedChBox.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_SignedTargetsDefault"));
        encryptedTargetsLabel.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_EncryptedTargetsLabel"));
        defaultEncryptedChBox.setText(NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_EncryptedTargetsDefault"));
        
        signedTargetsList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        encryptedTargetsList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        
        //TODO - should be taken care in the sync() method
        defaultEncryptedChBox.setVisible(false);
        defaultSignedChBox.setVisible(false);
    }

    public void setSignedTargetsList() {
        signedTargetsList.setListData(signedTargetsListModel);
    }
    
    public void setEncryptedTargetsList() {
        encryptedTargetsList.setListData(encryptedTargetsListModel);
    }

    public void setSignedTargetsList(Vector<MessageListElement> v) {
        this.signedTargetsListModel = v;
        setSignedTargetsList();
    }
    
    public void setEncryptedTargetsList(Vector<MessageListElement> v) {
        this.encryptedTargetsListModel = v;
        setEncryptedTargetsList();
    }
    
    private void sync() {
        inSync = true;
        
        enableDisable();
        
        inSync = false;
    }
    
    private AddBodyPanel getAddBodyPanel() {
        if (this.addBodyPanel == null) {
            addBodyPanel = new AddBodyPanel();
        }
        return addBodyPanel;
    }

    private AddHeaderPanel getAddHeaderPanel() {
        if (this.addHeaderPanel == null) {
            addHeaderPanel = new AddHeaderPanel();
        }
        return addHeaderPanel;
    }
    
    private AddElementPanel getAddElementPanel() {
        if (this.addElementPanel == null) {
            addElementPanel = new AddElementPanel();
        }
        return addElementPanel;
    }

    private void enableDisable() {
//        boolean encryptDefaults = defaultEncryptedChBox.isSelected();
//        encryptedTargetsLabel.setEnabled(!encryptDefaults);
//        encryptedTargetsList.setEnabled(!encryptDefaults);
//        jScrollPane1.setEnabled(!encryptDefaults);
//        boolean signDefaults = defaultSignedChBox.isSelected();
//        signedTargetsLabel.setEnabled(!signDefaults);
//        signedTargetsList.setEnabled(!signDefaults);
//        jScrollPane3.setEnabled(!signDefaults);
//        if (encryptDefaults && signDefaults) {
//            addHeaderButton.setEnabled(false);
//            addPartButton.setEnabled(false);
//            removeButton.setEnabled(false);
//        } else {
//            addHeaderButton.setEnabled(true);
//            addPartButton.setEnabled(true);
//            removeButton.setEnabled(true);
//        }
        
       String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) 
                                && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType)) 
                                && (!SecurityBindingTokensPanel.TRANSPORT.equals(bindingType));
       Component[] components = this.getComponents();
       for (Component c : components) {
           c.setEnabled(enable);
       }
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        addHeaderButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        addPartButton = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        encryptedTargetsList = new javax.swing.JList();
        signedTargetsLabel = new javax.swing.JLabel();
        defaultSignedChBox = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        signedTargetsList = new javax.swing.JList();
        encryptedTargetsLabel = new javax.swing.JLabel();
        defaultEncryptedChBox = new javax.swing.JCheckBox();
        addBodyButton = new javax.swing.JButton();

        addHeaderButton.setText("Add Header...");
        addHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addHeaderButtonActionPerformed(evt);
            }
        });

        removeButton.setText("Remove");
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        addPartButton.setText("Add XPath...");
        addPartButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addPartButtonActionPerformed(evt);
            }
        });

        jScrollPane3.setViewportView(encryptedTargetsList);

        signedTargetsLabel.setText("Signed targets:");

        defaultSignedChBox.setText("Default");
        defaultSignedChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        defaultSignedChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        defaultSignedChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultSignedChBoxActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(signedTargetsList);

        encryptedTargetsLabel.setText("Encrypted targets:");

        defaultEncryptedChBox.setText("Default");
        defaultEncryptedChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        defaultEncryptedChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        defaultEncryptedChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultEncryptedChBoxActionPerformed(evt);
            }
        });

        addBodyButton.setText("Add Body...");
        addBodyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addBodyButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 274, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                                .add(signedTargetsLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(defaultSignedChBox))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 275, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(addBodyButton)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(addPartButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(removeButton))
                            .add(addHeaderButton)))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(encryptedTargetsLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 131, Short.MAX_VALUE)
                        .add(defaultEncryptedChBox)
                        .add(107, 107, 107)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {jScrollPane1, jScrollPane3}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] {addBodyButton, addHeaderButton, addPartButton, removeButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(signedTargetsLabel)
                    .add(defaultSignedChBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(addBodyButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(addHeaderButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(addPartButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 130, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(31, 31, 31)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(encryptedTargetsLabel)
                    .add(defaultEncryptedChBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jScrollPane1, jScrollPane3}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents

    private void addBodyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addBodyButtonActionPerformed
        AddBodyPanel addBodyPanel = getAddBodyPanel();
        DialogDescriptor dd = new DialogDescriptor(
                addBodyPanel, 
                NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_SignEncryptChooser_AddBodyTitle"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(SignEncryptTargetChooserPanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (addBodyPanel != null) {
                MessageBody b = new MessageBody(MessageBody.BODY);
                boolean sign = addBodyPanel.getSign();
                boolean encrypt = addBodyPanel.getEncrypt();
                if (sign) {
                    if (!signedTargetsListModel.contains(b) && !(defaultSignedChBox.isSelected())) {
                        signedTargetsListModel.add(b);
                        setSignedTargetsList();
                    }
                }
                if (encrypt) {
                    if (!encryptedTargetsListModel.contains(b) && !(defaultEncryptedChBox.isSelected())) {
                        encryptedTargetsListModel.add(b);
                        setEncryptedTargetsList();
                    }
                }
            }
        }
//        setter.setDirty();
    }//GEN-LAST:event_addBodyButtonActionPerformed

    private void defaultSignedChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultSignedChBoxActionPerformed
        enableDisable();
    }//GEN-LAST:event_defaultSignedChBoxActionPerformed

    private void defaultEncryptedChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultEncryptedChBoxActionPerformed
        enableDisable();
    }//GEN-LAST:event_defaultEncryptedChBoxActionPerformed

    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        Object[] values = signedTargetsList.getSelectedValues();
        if (values != null) {
            for (int i=0; i<values.length; i++) {
                signedTargetsListModel.remove(values[i]);
            }
            setSignedTargetsList();
        }

        values = encryptedTargetsList.getSelectedValues();
        if (values != null) {
            for (int i=0; i<values.length; i++) {
                encryptedTargetsListModel.remove(values[i]);
            }
            setEncryptedTargetsList();
        }
//        setter.setDirty();
    }//GEN-LAST:event_removeButtonActionPerformed
    
    private void addPartButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addPartButtonActionPerformed
        AddElementPanel addElementPanel = getAddElementPanel();
        DialogDescriptor dd = new DialogDescriptor(
                addElementPanel, 
                NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_SignEncryptChooser_AddElementTitle"),  //NOI18N
                true,
                DialogDescriptor.OK_CANCEL_OPTION,
                DialogDescriptor.CANCEL_OPTION,
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(SignEncryptTargetChooserPanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (addElementPanel != null) {
                String element = addElementPanel.getElement();
                element = element.trim();
                if (element.length() == 0) {
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                            NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "ERR_AddElementError"),    //NOI18N
                            NotifyDescriptor.ERROR_MESSAGE
                            ));
                    return;
                }
                MessageElement e = new MessageElement(element);
                boolean sign = addElementPanel.getSign();
                boolean encrypt = addElementPanel.getEncrypt();
                if (sign) {
                    if (!signedTargetsListModel.contains(e) && !(defaultSignedChBox.isSelected())) {
                        signedTargetsListModel.add(e);
                        setSignedTargetsList();
                    }
                }
                if (encrypt) {
                    if (!encryptedTargetsListModel.contains(e) && !(defaultEncryptedChBox.isSelected())) {
                        encryptedTargetsListModel.add(e);
                        setEncryptedTargetsList();
                    }
                }
            }
        }
//        setter.setDirty();
    }//GEN-LAST:event_addPartButtonActionPerformed

    private void addHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addHeaderButtonActionPerformed
        AddHeaderPanel addHeaderPanel = getAddHeaderPanel();
        DialogDescriptor dd = new DialogDescriptor(
                addHeaderPanel, 
                NbBundle.getMessage(SignEncryptTargetChooserPanel.class, "LBL_SignEncryptChooser_AddHeaderTitle"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(SignEncryptTargetChooserPanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (addHeaderPanel != null) {
                boolean sign = addHeaderPanel.getSign();
                boolean encrypt = addHeaderPanel.getEncrypt();
                boolean allHeaders = addHeaderPanel.isAllHeaders();
                if (allHeaders) {
                    if (sign) {
                        for (String s : MessageHeader.ALL_HEADERS) {
                            MessageHeader h = new MessageHeader(s);
                            if (!signedTargetsListModel.contains(h) && !(defaultSignedChBox.isSelected())) {
                                signedTargetsListModel.add(h);
                                setSignedTargetsList();
                            }
                        }
                    }
                    if (encrypt) {
                        for (String s : MessageHeader.ALL_HEADERS) {
                            MessageHeader h = new MessageHeader(s);
                            if (!encryptedTargetsListModel.contains(h) && !(defaultEncryptedChBox.isSelected())) {
                                encryptedTargetsListModel.add(h);
                                setEncryptedTargetsList();
                            }
                        }
                    }
                } else {
                    String header = addHeaderPanel.getHeader();
                    MessageHeader h = new MessageHeader(header);
                    if (sign) {
                        if (!signedTargetsListModel.contains(h) && !(defaultSignedChBox.isSelected())) {
                            signedTargetsListModel.add(h);
                            setSignedTargetsList();
                        }
                    }
                    if (encrypt) {
                        if (!encryptedTargetsListModel.contains(h) && !(defaultEncryptedChBox.isSelected())) {
                            encryptedTargetsListModel.add(h);
                            setEncryptedTargetsList();
                        }
                    }
                }
            }
        }
//        setter.setDirty();        
    }//GEN-LAST:event_addHeaderButtonActionPerformed
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addBodyButton;
    private javax.swing.JButton addHeaderButton;
    private javax.swing.JButton addPartButton;
    private javax.swing.JCheckBox defaultEncryptedChBox;
    private javax.swing.JCheckBox defaultSignedChBox;
    private javax.swing.JLabel encryptedTargetsLabel;
    private javax.swing.JList encryptedTargetsList;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JButton removeButton;
    private javax.swing.JLabel signedTargetsLabel;
    private javax.swing.JList signedTargetsList;
    // End of variables declaration//GEN-END:variables
    
}
