/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.*;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.*;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

import javax.swing.*;
import java.util.Collection;
import java.util.Vector;

/**
 *
 * @author Martin Grebac
 */
public class SignEncryptPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    private Vector msgOperListModel;

    private boolean inSync = false;
    
    public SignEncryptPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        configureButton.setText(NbBundle.getMessage(SignEncryptPanel.class, "LBL_SignEncrypt_ConfigureButton")); //NOI18N
        configureButton.setToolTipText(NbBundle.getMessage(SignEncryptPanel.class, "LBL_SignEncrypt_ConfigureButton_Tooltip")); //NOI18N

        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                if (!inSync) sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                if (!inSync) sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                if (!inSync) sync();
            }
        });
        
        msgOperList.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        msgOperList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        configureButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        sync();
    }

    private void renewOperListModel() {
        msgOperListModel = new Vector();
    }
    
    private Vector getMsgOperListModel() {
        if (msgOperListModel == null) {
            renewOperListModel();
        }
        return msgOperListModel;
    }
    
    private void sync() {
        inSync = true;
        Collection<BindingOperation> operations = binding.getBindingOperations();
                
        //is it a service node?
        org.netbeans.modules.websvc.api.jaxws.project.config.Service service = 
                (org.netbeans.modules.websvc.api.jaxws.project.config.Service)node.getLookup().lookup(org.netbeans.modules.websvc.api.jaxws.project.config.Service.class);
        if (service != null) {
            String wsdlUrl = service.getWsdlUrl();
            if (wsdlUrl == null) { // WS from Java
                JavaClass jc = (JavaClass)node.getLookup().lookup(JavaClass.class);
                if (jc != null) {
                    operations = refreshOperations(binding, jc);
                }
            }
        }

        renewOperListModel();
        
        for (BindingOperation o : operations) {
            BindingInput input = o.getBindingInput();
            if (input != null) {
                getMsgOperListModel().add(new InputMessage(input, o));
            }
            BindingOutput output = o.getBindingOutput();
            if (output != null) {
                getMsgOperListModel().add(new OutputMessage(output, o));
            }
            Collection<BindingFault> faults = o.getBindingFaults();
            for (BindingFault f : faults) {
                if (f != null) {
                    getMsgOperListModel().add(new FaultMessage(f, o));
                }
            }
        }
        
        msgOperList.setListData(getMsgOperListModel());
        
        enableDisable();

        inSync = false;
    }

    private Collection<BindingOperation> refreshOperations(Binding binding, JavaClass jc) {
        
        Collection<BindingOperation> operations = binding.getBindingOperations();

        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        
        WSDLComponentFactory wcf = model.getFactory();
        Definitions d = (Definitions) binding.getParent();
                
        QName portTypeQName = binding.getType().getQName();
        PortType portType = null;
        
        Collection<PortType> portTypes = d.getPortTypes();
        Iterator<PortType> i = portTypes.iterator();
        while (i.hasNext()) {
            PortType pt = i.next();
            if (pt != null) {
                if (portTypeQName.getLocalPart().equals(pt.getName())) {
                    portType = pt;
                    break;
                }
            }
        }
        // create operations and add them to the binding element
        List<String> bindingOperationNames = JavaWsdlMapper.getOperationNames(jc);
        for (String name : bindingOperationNames) {
            if (!isOperationInList(name, operations)) {
                org.netbeans.modules.xml.wsdl.model.BindingOperation bindingOperation = wcf.createBindingOperation();
                bindingOperation.setName(name);
                binding.addBindingOperation(bindingOperation);

                // add input/output messages
                int operationDirection = JavaWsdlMapper.getParamDirections(jc, name);
                
                if (operationDirection == JavaWsdlMapper.OUTPUTINPUT) {
                    org.netbeans.modules.xml.wsdl.model.Message inputMsg = wcf.createMessage();
                    inputMsg.setName(name);
                    d.addMessage(inputMsg);

                    org.netbeans.modules.xml.wsdl.model.Message outMsg = wcf.createMessage();
                    outMsg.setName(name + "Response");                  //NOI18N
                    d.addMessage(outMsg);

                    org.netbeans.modules.xml.wsdl.model.RequestResponseOperation oper = wcf.createRequestResponseOperation();
                    oper.setName(name);
                    portType.addOperation(oper);

                    org.netbeans.modules.xml.wsdl.model.Input input = wcf.createInput();
                    oper.setInput(input);
                    input.setMessage(input.createReferenceTo(inputMsg, org.netbeans.modules.xml.wsdl.model.Message.class));

                    org.netbeans.modules.xml.wsdl.model.Output out = wcf.createOutput();
                    oper.setOutput(out);
                    out.setMessage(out.createReferenceTo(outMsg, org.netbeans.modules.xml.wsdl.model.Message.class));

                } else if (operationDirection == JavaWsdlMapper.OUTPUT) {

                    org.netbeans.modules.xml.wsdl.model.Message outMsg = wcf.createMessage();
                    outMsg.setName(name + "Response");                  //NOI18N
                    d.addMessage(outMsg);

                    org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation oper = wcf.createSolicitResponseOperation();
                    oper.setName(name);
                    portType.addOperation(oper);

                    org.netbeans.modules.xml.wsdl.model.Output out = wcf.createOutput();
                    oper.setOutput(out);
                    out.setMessage(out.createReferenceTo(outMsg, org.netbeans.modules.xml.wsdl.model.Message.class));

                } else if (operationDirection == JavaWsdlMapper.INPUT) {
                    org.netbeans.modules.xml.wsdl.model.Message inputMsg = wcf.createMessage();
                    inputMsg.setName(name);
                    d.addMessage(inputMsg);

                    org.netbeans.modules.xml.wsdl.model.OneWayOperation oper = wcf.createOneWayOperation();
                    oper.setName(name);
                    portType.addOperation(oper);

                    org.netbeans.modules.xml.wsdl.model.Input input = wcf.createInput();
                    oper.setInput(input);
                    input.setMessage(input.createReferenceTo(inputMsg, org.netbeans.modules.xml.wsdl.model.Message.class));
                }                
                
                if ((operationDirection == JavaWsdlMapper.OUTPUT) || (operationDirection == JavaWsdlMapper.OUTPUTINPUT)) {
                    org.netbeans.modules.xml.wsdl.model.BindingOutput bindingOutput = wcf.createBindingOutput();
                    bindingOperation.setBindingOutput(bindingOutput);
                }
                if ((operationDirection == JavaWsdlMapper.INPUT) || (operationDirection == JavaWsdlMapper.OUTPUTINPUT)) {
                    org.netbeans.modules.xml.wsdl.model.BindingInput bindingInput = wcf.createBindingInput();
                    bindingOperation.setBindingInput(bindingInput);
                }
                //add faults
                List<String> operationFaults = JavaWsdlMapper.getOperationFaults(jc, name);
                for (String fault : operationFaults) {
                    org.netbeans.modules.xml.wsdl.model.BindingFault bindingFault = wcf.createBindingFault();
                    bindingOperation.addBindingFault(bindingFault);
                }
            } else {

            }
        }
        
            if (!isTransaction) {
                model.endTransaction();
            }
        
        return binding.getBindingOperations();
    }
    
    private boolean isOperationInList(String operName, Collection<BindingOperation> operations) {
        Iterator<BindingOperation> i = operations.iterator();
        while (i.hasNext()) {
            BindingOperation bo = i.next();
            if ((bo != null) && (operName.equals(bo.getName()))) {
                return true;
            }
        }
        return false;
    }
    
   private void enableDisable() {
       String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) 
                                && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType)) 
                                && (!SecurityBindingTokensPanel.TRANSPORT.equals(bindingType))
                                && (!getMsgOperListModel().isEmpty());
       Component[] components = this.getComponents();
       for (Component c : components) {
           c.setEnabled(enable);
       }
       components = jScrollPane1.getComponents();
       for (Component c : components) {
           c.setEnabled(enable);
       }
   }
   
    private void saveEncTargets(WSDLComponent c, Vector<MessageListElement> targets) {
        SecurityPolicyModelHelper.setEncryptedTargets(binding, c, model, targets);
    }
    
    private void saveSignedTargets(WSDLComponent c, Vector<MessageListElement> targets) {
        SecurityPolicyModelHelper.setSignedTargets(binding, c, model, targets);
    }

    public void setValue(javax.swing.JComponent source, Object value) { }

    public void documentChanged(javax.swing.text.JTextComponent comp, String value) { }

    public void rollbackValue(javax.swing.text.JTextComponent source) { }
    
    protected void endUIChange() { }

    public void linkButtonPressed(Object ddBean, String ddProperty) { }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        configureButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        msgOperList = new javax.swing.JList();

        configureButton.setText("Select Targets...");
        configureButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                configureButtonActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(msgOperList);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jScrollPane1))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(205, 205, 205)
                        .add(configureButton)))
                .addContainerGap(343, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 8, Short.MAX_VALUE)
                .add(configureButton)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void configureButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_configureButtonActionPerformed
        BindingMessage bm = (BindingMessage)msgOperList.getSelectedValue();
        SignEncryptTargetChooserPanel configSec = new SignEncryptTargetChooserPanel(bm, binding);

        Vector<MessageListElement> signedTargets = SecurityPolicyModelHelper.getSignedTargets(bm, model);
        configSec.setSignedTargetsList(signedTargets);

        Vector<MessageListElement> encryptedTargets = SecurityPolicyModelHelper.getEncryptedTargets(bm, model);
        configSec.setEncryptedTargetsList(encryptedTargets);

        DialogDescriptor dd = new DialogDescriptor(
                configSec, 
                NbBundle.getMessage(SignEncryptPanel.class, "LBL_SignEncrypt_MsgSecurity_Title"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(SignEncryptPanel.class),
                null);

        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (configSec != null) {
                saveEncTargets(bm.getComponent(), encryptedTargets);
                saveSignedTargets(bm.getComponent(), signedTargets);
            }
        }
    }//GEN-LAST:event_configureButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton configureButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList msgOperList;
    // End of variables declaration//GEN-END:variables
    
}
