/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.*;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ui.*;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

import java.util.Collection;

/**
 * @author Martin Grebac
 */
public class SecurityServiceView extends SectionView {

    static final String SUPPORTING_TOKENS_ID = "supportingtokens";    //NOI18N
    static final String SECURITYBINDING_TOKENS_NODE_ID = "securitybindingtokensservice"; //NOI18N
    static final String SECURITYBINDING_OTHER_NODE_ID = "securitybindingotherservice"; //
    static final String SIGN_ENCRYPT_NODE_ID = "signencryptservice";        //NOI18N
    static final String KEYSTORE_NODE_ID = "keystore";        //NOI18N
    static final String STSCONFIG_NODE_ID = "stsconfig";        //NOI18N
    static final String ADVANCEDCONFIG_NODE_ID = "advancedconfig";        //NOI18N
    static final String WSS_NODE_ID = "wssservice";                         //NOI18N
    static final String TRUST_NODE_ID = "trust";                            //NOI18N

    private SectionNode rootNode = null;
    
    private static final int REFRESH_DELAY = 40;
    
    public static final String ICON_BASE_DD_VALID =
            "org/netbeans/modules/websvc/wsdl/multiview/resources/DDValidIcon"; // NOI18N
        
    private WSDLModel model = null;
    private Service service = null;
    
    SecurityServiceView(InnerPanelFactory factory, WSDLModel model, Service s) {
    
        super(factory);
        this.model = model;
        this.service = s;
        
        //create root node
        Children rootChildren = new Children.Array();
        Node root = new AbstractNode(rootChildren);

        //add binding section
        Collection<Binding> bindings = model.getDefinitions().getBindings();
        Node[] bindingNodes = new Node[bindings.size()];

//        //add service section
//        Collection<Service> services = model.getDefinitions().getServices();
//        Node[] serviceNodes = new Node[services.size()];
//        int si = 0;
//
//        for (Service service : services) {
//            // main node container for a specific service
//            Children serviceChildren = new Children.Array();
//            Node serviceNodeContainer = new ServiceContainerServiceNode(serviceChildren);
//            SectionContainer serviceCont = new SectionContainer(this, 
//                    serviceNodeContainer, service.getName() + " Service");      //NOI18N
//
//            Node keystoreNode = new KeystoreServiceNode(this, service);
//            Node stsNode = new STSServiceNode(this, service);
//            Node advancedConfigNode = new AdvancedConfigurationServiceNode(this, service);
//            
//            Node[] nodes = new Node[] { 
//                keystoreNode,
//                stsNode,
//                advancedConfigNode
//            };
//            
//            serviceChildren.add(nodes);
//
//            SectionPanel keystorePanel = new SectionPanel(this, keystoreNode, 
//                    KEYSTORE_NODE_ID + service.getName());
//            SectionPanel stsPanel = new SectionPanel(this, stsNode, 
//                    STSCONFIG_NODE_ID + service.getName());
//            SectionPanel advancedConfigPanel = new SectionPanel(this, advancedConfigNode, 
//                    ADVANCEDCONFIG_NODE_ID + service.getName());
//            
//            serviceCont.addSection(keystorePanel);
//            serviceCont.addSection(stsPanel);
//            serviceCont.addSection(advancedConfigPanel);
//
//            addSection(serviceCont, false);
//        
//            serviceNodes[si++] = serviceNodeContainer;
//        }
//
//        rootChildren.add(serviceNodes);
       
        int i = 0;
        boolean first = true;
        for (Binding binding : bindings) {
            // main node container for a specific binding
            Children bindingChildren = new Children.Array();
            Node bindingNodeContainer = new BindingContainerServiceNode(bindingChildren);
            SectionContainer bindingCont = new SectionContainer(this, 
                    bindingNodeContainer, 
                    NbBundle.getMessage(SecurityServiceView.class, "LBL_Binding", binding.getName()));

            // main node container for a security binding
            Children securityBindingChildren = new Children.Array();
            Node securityBindingNodeContainer = new SecurityContainerNode(securityBindingChildren);
            SectionContainer securityBindingCont = new SectionContainer(this, 
                    securityBindingNodeContainer, 
                    NbBundle.getMessage(SecurityServiceView.class, "LBL_Section_SecurityBinding"));

            Node keystoreNode = new KeystoreServiceNode(this, binding);
            Node stsNode = new STSServiceNode(this, binding);
            Node advancedConfigNode = new AdvancedConfigurationServiceNode(this, binding);

            Node secBindingOtherNode = new SecurityBindingOtherNode(this, binding);
            Node secBindingTokensNode = new SecurityBindingTokensNode(this, binding);
            SectionPanel securityBindingSessionPanel = new SectionPanel(this, secBindingTokensNode, 
                    SECURITYBINDING_TOKENS_NODE_ID + binding.getName());
            securityBindingCont.addSection(securityBindingSessionPanel, false);

            SectionPanel securityBindingOtherPanel = new SectionPanel(this, secBindingOtherNode, 
                    SECURITYBINDING_OTHER_NODE_ID + binding.getName());
            securityBindingCont.addSection(securityBindingOtherPanel, false);
            
            securityBindingChildren.add(new Node[] { secBindingTokensNode, secBindingOtherNode } );
            //end 
            
            Node supportingTokensNode = new SupportingTokensNode(this, binding);

            Node signEncryptNode = new SignEncryptNode(this, binding);
            Node wssNode = new WssNode(this, binding);
            Node trustNode = new TrustNode(this, binding);
            Node[] nodes = new Node[] { keystoreNode,
                                        stsNode,                                         
                                        securityBindingNodeContainer, 
                                        securityBindingNodeContainer, 
                                        supportingTokensNode,
                                        signEncryptNode, 
                                        wssNode, 
                                        trustNode, 
                                        stsNode,                                         
                                        advancedConfigNode, 
                                        };
            bindingChildren.add(nodes);
            
            SectionPanel keystorePanel = new SectionPanel(this, keystoreNode, 
                    KEYSTORE_NODE_ID + binding.getName());
            SectionPanel stsPanel = new SectionPanel(this, stsNode, 
                    STSCONFIG_NODE_ID + binding.getName());
            SectionPanel advancedConfigPanel = new SectionPanel(this, advancedConfigNode, 
                    ADVANCEDCONFIG_NODE_ID + binding.getName());

            SectionPanel supportingTokensPanel = new SectionPanel(this, supportingTokensNode, 
                    SUPPORTING_TOKENS_ID + binding.getName());
            SectionPanel signEncryptPanel = new SectionPanel(this, signEncryptNode, 
                    SIGN_ENCRYPT_NODE_ID + binding.getName());
            SectionPanel wssPanel = new SectionPanel(this, wssNode, 
                    WSS_NODE_ID + binding.getName());
            SectionPanel trustPanel = new SectionPanel(this, trustNode, 
                    TRUST_NODE_ID + binding.getName());
            
            bindingCont.addSection(keystorePanel, false);
            bindingCont.addSection(securityBindingCont, false);
            bindingCont.addSection(supportingTokensPanel, false);
            bindingCont.addSection(signEncryptPanel, false);
            bindingCont.addSection(wssPanel, false);
            bindingCont.addSection(trustPanel, false);
            bindingCont.addSection(stsPanel, false);
            bindingCont.addSection(advancedConfigPanel, false);
            
            addSection(bindingCont, false);
    
            bindingNodes[i++] = bindingNodeContainer;                    
        }
        
        rootChildren.add(bindingNodes);
        setRoot(root);
        
    }
    
    private final RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable() {
        public void run() {
            getRootNode().refreshSubtree();
        }
    });

    public void refreshView() {
        rootNode.refreshSubtree();
    }
    
    public void scheduleRefreshView() {
        refreshTask.schedule(REFRESH_DELAY);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        rootNode.dataModelPropertyChange(source, propertyName, oldValue, newValue);
    }
    
    public SectionNode getRootNode() {
        return rootNode;
    }    
    
}
