/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens.SupportingTokensPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;

/**
 *
 * @author Martin Grebac
 */
public class SecurityServicePanelFactory implements org.netbeans.modules.xml.multiview.ui.InnerPanelFactory {
    
    private ToolBarDesignEditor editor;
    private WSDLModel model;
    private Node node;
    
    /**
     * Creates a new instance of SecurityServicePanelFactory
     */
    SecurityServicePanelFactory(ToolBarDesignEditor editor, WSDLModel model, Node node) {
        this.editor=editor;
        this.model = model;
        this.node = node;        
    }
    
    public SectionInnerPanel createInnerPanel(Object key) {
        if (key instanceof String) {
            String id = (String)key;

            if (id.startsWith(SecurityServiceView.SECURITYBINDING_TOKENS_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.SECURITYBINDING_TOKENS_NODE_ID.length()));
                return new SecurityBindingTokensPanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.SECURITYBINDING_OTHER_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.SECURITYBINDING_OTHER_NODE_ID.length()));
                return new SecurityBindingOtherPanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.SIGN_ENCRYPT_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.SIGN_ENCRYPT_NODE_ID.length()));
                return new SignEncryptPanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.SUPPORTING_TOKENS_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.SUPPORTING_TOKENS_ID.length()));
                return new SupportingTokensPanel((SectionView) editor.getContentView(), b);
            }

            if (id.startsWith(SecurityServiceView.KEYSTORE_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.KEYSTORE_NODE_ID.length()));
                return new KeystorePanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.STSCONFIG_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.STSCONFIG_NODE_ID.length()));
                return new STSConfigServicePanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.ADVANCEDCONFIG_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.ADVANCEDCONFIG_NODE_ID.length()));
                return new AdvancedConfigPanelService((SectionView) editor.getContentView(), node, b);
            }
            
            if (id.startsWith(SecurityServiceView.WSS_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.WSS_NODE_ID.length()));
                return new WssPanel((SectionView) editor.getContentView(), model, node, b);
            }
            if (id.startsWith(SecurityServiceView.TRUST_NODE_ID)) {
                Binding b = Utilities.getBinding(model, id.substring(SecurityServiceView.TRUST_NODE_ID.length()));
                return new TrustSettingsPanel((SectionView) editor.getContentView(), model, node, b);
            }
        }
        return null;
    }
}
