/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.awt.Font;
import java.net.HttpURLConnection;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens.TokensSymmetricPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class SecurityBindingTokensPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    private SectionView view;
    
    public static final String NOSECURITY = NbBundle.getMessage(SecurityBindingTokensPanel.class, "COMBO_NoSecurity");  //NOI18N
    public static final String SYMMETRIC = NbBundle.getMessage(SecurityBindingTokensPanel.class, "COMBO_Symmetric");  //NOI18N
    public static final String ASYMMETRIC = NbBundle.getMessage(SecurityBindingTokensPanel.class, "COMBO_Asymmetric");    //NOI18N
    public static final String TRANSPORT = NbBundle.getMessage(SecurityBindingTokensPanel.class, "COMBO_Transport");  //NOI18N

    private TokensSymmetricPanel symmetricSettingsPanel;
    private TokensSymmetricPanel asymmetricSettingsPanel;
    private HttpsPanel transportSettingsPanel;
    private JPanel nosecurityPanel;
    
    boolean inSync = false;

    public SecurityBindingTokensPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        this.view = view;
        
        initComponents();

        securityBindingTypeLabel.setText(
                NbBundle.getMessage(SecurityBindingTokensPanel.class, "LBL_Section_SecurityBinding_securityBindingType")); //NOI18N

        Font f = securityBindingTypeLabel.getFont().deriveFont(Font.BOLD);
        securityBindingTypeLabel.setFont(f);

        securityBindingSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        securityBindingTypeCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        inSync = true;
        securityBindingTypeCombo.addItem(NOSECURITY);
        securityBindingTypeCombo.addItem(TRANSPORT);
        securityBindingTypeCombo.addItem(SYMMETRIC);
        securityBindingTypeCombo.addItem(ASYMMETRIC);
        inSync = false;
        
        addModifier(securityBindingTypeCombo);
        
        sync();
    }

    private TokensSymmetricPanel getSymmetricSettingsPanel(WSDLComponent secBindingType) {
        if (this.symmetricSettingsPanel == null) {
            WSDLComponent wc = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);
            symmetricSettingsPanel =  new TokensSymmetricPanel(binding, model, true, wc);
            symmetricSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        symmetricSettingsPanel.setSecBinding(secBindingType);
        return symmetricSettingsPanel;
    }

    private TokensSymmetricPanel getAsymmetricSettingsPanel(WSDLComponent secBindingType) {
        if (this.asymmetricSettingsPanel == null) {
            WSDLComponent wc = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);
            asymmetricSettingsPanel =  new TokensSymmetricPanel(binding, model, false, wc);
            asymmetricSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        asymmetricSettingsPanel.setSecBinding(secBindingType);
        return asymmetricSettingsPanel;
    }

    private HttpsPanel getTransportSettingsPanel(WSDLComponent secBindingType) {
        if (this.transportSettingsPanel == null) {
            WSDLComponent wc = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);
            transportSettingsPanel =  new HttpsPanel(binding, model, wc);
            transportSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        transportSettingsPanel.setSecBinding(secBindingType);
        return transportSettingsPanel;
    }

    private JPanel getNoSecurityPanel() {
        if (this.nosecurityPanel == null) {
            nosecurityPanel =  new JPanel();
            nosecurityPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return nosecurityPanel;
    }
    
    private void setSecurityBinding(String bindingType, WSDLComponent secBindingType) {
        
        this.securityBindingTypeCombo.setSelectedItem(bindingType);
        this.remove(securityBindingSettingsPanel);
        
        if (TRANSPORT.equals(bindingType)) {
            securityBindingSettingsPanel = getTransportSettingsPanel(secBindingType);
            return;
        }
        if (SYMMETRIC.equals(bindingType)) {
            securityBindingSettingsPanel = getSymmetricSettingsPanel(secBindingType);
            return;
        }
        if (ASYMMETRIC.equals(bindingType)) {
            securityBindingSettingsPanel = getAsymmetricSettingsPanel(secBindingType);
            return;
        }
        if (NOSECURITY.equals(bindingType)) {
            securityBindingSettingsPanel = getNoSecurityPanel();
            return;
        }
    }
    
    private void sync() {
        inSync = true;

        WSDLComponent secBindingType = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);
        setSecurityBinding(SecurityPolicyModelHelper.getSecurityBindingType(binding, model), secBindingType);
        refreshPanels();
        
        inSync = false;
    }
        
    public void setValue(javax.swing.JComponent source, Object value) {
        if (source.equals(securityBindingTypeCombo) && (!inSync)) {
            if (((String)securityBindingTypeCombo.getSelectedItem()).equals(SYMMETRIC)) {
                WSDLComponent secBindingType = SecurityPolicyModelHelper.setSecurityBindingType(binding, model, SYMMETRIC);    // set in the model
                setSecurityBinding(SYMMETRIC, secBindingType);  // set UI 
//                changeAddress(false);
                refreshPanels();
                return;
            }   
            if (((String)securityBindingTypeCombo.getSelectedItem()).equals(ASYMMETRIC)) {
                WSDLComponent secBindingType = SecurityPolicyModelHelper.setSecurityBindingType(binding, model, ASYMMETRIC);    // set in the model
                setSecurityBinding(ASYMMETRIC, secBindingType);  // set UI 
//                changeAddress(false);
                refreshPanels();
                return;
            }
            if (((String)securityBindingTypeCombo.getSelectedItem()).equals(TRANSPORT)) {
                WSDLComponent secBindingType = SecurityPolicyModelHelper.setSecurityBindingType(binding, model, TRANSPORT);    // set in the model
                setSecurityBinding(TRANSPORT, secBindingType);  // set UI 
//                changeAddress(true);
                refreshPanels();
                return;
            }
            if (((String)securityBindingTypeCombo.getSelectedItem()).equals(NOSECURITY)) {
                WSDLComponent secBindingType = SecurityPolicyModelHelper.setSecurityBindingType(binding, model, NOSECURITY);    // set in the model
                setSecurityBinding(NOSECURITY, null);  // set UI 
//                changeAddress(false);
                refreshPanels();
                return;
            }
        }
    }

//    private void changeAddress(boolean toTransportSecurity) {
//        Port p = Utilities.getPortForBinding(binding);
//        String address = Utilities.getWsdlAddress(p);
//        
//        String from, to;
//        if (toTransportSecurity) {
//            from = Utilities.HTTP;
//            to = Utilities.HTTPS;
//        } else {
//            from = Utilities.HTTPS;
//            to = Utilities.HTTP;
//        }
//        if ((address!= null) && (address.startsWith(from))) {      //NOI18N
//            String newAddress = org.openide.util.Utilities.replaceString(address, from, to);
//            Utilities.setWsdlAddress(p, newAddress);
//        }
//    }
    
    private void refreshPanels() {
        updateLayout();
        revalidate();
        repaint();
    }
    private void updateLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, securityBindingSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(securityBindingTypeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(securityBindingTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(securityBindingTypeLabel)
                    .add(securityBindingTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(securityBindingSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        securityBindingSettingsPanel = new javax.swing.JPanel();
        securityBindingTypeCombo = new javax.swing.JComboBox();
        securityBindingTypeLabel = new javax.swing.JLabel();

        org.jdesktop.layout.GroupLayout securityBindingSettingsPanelLayout = new org.jdesktop.layout.GroupLayout(securityBindingSettingsPanel);
        securityBindingSettingsPanel.setLayout(securityBindingSettingsPanelLayout);
        securityBindingSettingsPanelLayout.setHorizontalGroup(
            securityBindingSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 326, Short.MAX_VALUE)
        );
        securityBindingSettingsPanelLayout.setVerticalGroup(
            securityBindingSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 100, Short.MAX_VALUE)
        );

        securityBindingTypeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                securityBindingTypeComboActionPerformed(evt);
            }
        });

        securityBindingTypeLabel.setText("txt");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, securityBindingSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(securityBindingTypeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(securityBindingTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(securityBindingTypeLabel)
                    .add(securityBindingTypeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(securityBindingSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void securityBindingTypeComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_securityBindingTypeComboActionPerformed
        setValue(securityBindingTypeCombo, null);
    }//GEN-LAST:event_securityBindingTypeComboActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel securityBindingSettingsPanel;
    private javax.swing.JComboBox securityBindingTypeCombo;
    private javax.swing.JLabel securityBindingTypeLabel;
    // End of variables declaration//GEN-END:variables
    
}
