/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

import java.awt.*;

/**
 *
 * @author  Martin Grebac
 */
public class SecurityBindingOtherPanel  extends SectionInnerPanel {
    
    private WSDLModel model;
    private Node node;
    private Binding binding;

    private boolean inSync = false;
    
    public static final String STRICT       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Strict");         //NOI18N
    public static final String LAX          = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Lax");            //NOI18N
    public static final String LAXTSFIRST   = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_LaxTsFirst");     //NOI18N
    public static final String LAXTSLAST    = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_LaxTsLast");      //NOI18N
    
    public static final String BASIC256       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic256");     //NOI18N
    public static final String BASIC192       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic192");     //NOI18N
    public static final String BASIC128       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic128");     //NOI18N
    public static final String TRIPLEDES      = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_TripleDes");    //NOI18N
    public static final String BASIC256RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic256Rsa15");    //NOI18N
    public static final String BASIC192RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic192Rsa15");    //NOI18N
    public static final String BASIC128RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic128Rsa15");    //NOI18N
    public static final String TRIPLEDESRSA15      = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_TripleDesRsa15");   //NOI18N
    public static final String BASIC256SHA256       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic256Sha256");   //NOI18N
    public static final String BASIC192SHA256       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic192Sha256");   //NOI18N
    public static final String BASIC128SHA256       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic128Sha256");   //NOI18N
    public static final String TRIPLEDESSHA256      = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_TripleDesSha256");  //NOI18N
    public static final String BASIC256SHA256RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic256Sha256Rsa15");  //NOI18N
    public static final String BASIC192SHA256RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic192Sha256Rsa15");  //NOI18N
    public static final String BASIC128SHA256RSA15       = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_Basic128Sha256Rsa15");  //NOI18N
    public static final String TRIPLEDESSHA256RSA15      = NbBundle.getMessage(SecurityBindingOtherPanel.class, "COMBO_TripleDesSha256Rsa15"); //NOI18N
            
    /**
     * Creates new form SecurityBindingOtherPanel
     */
    public SecurityBindingOtherPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                sync();
            }
        });
        
        algoSuiteLabel.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_AlgorithmSuiteLabel"));    //NOI18N
        msgLayoutLabel.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_SecurityBindingsSettingsSymmetric_Layout"));   //NOI18N
        signEntireHeadersBodyChBox.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_SecurityBindingsSettingsSymmetric_SignEntireHeadersBody"));    //NOI18N
        includeTimestampChBox.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_SecurityBindingsSettingsSymmetric_IncludeTimestamp"));  //NOI18N
        encryptBeforeSigning.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_SecurityBindingsSettingsSymmetric_EncryptBeforeSigning"));   //NOI18N
        encryptSignature.setText(NbBundle.getMessage(SecurityBindingOtherPanel.class, "LBL_SecurityBindingsSettingsSymmetric_EncryptSignature"));   //NOI18N
        
        msgLayoutCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        msgLayoutLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        algoSuiteCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        algoSuiteLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptBeforeSigning.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptSignature.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        includeTimestampChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        signEntireHeadersBodyChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        inSync = true;
        msgLayoutCombo.addItem(STRICT);
        msgLayoutCombo.addItem(LAX);
        msgLayoutCombo.addItem(LAXTSFIRST);
        msgLayoutCombo.addItem(LAXTSLAST);
        
        algoSuiteCombo.addItem(BASIC256);
        algoSuiteCombo.addItem(BASIC192);
        algoSuiteCombo.addItem(BASIC128);
        algoSuiteCombo.addItem(TRIPLEDES);
        algoSuiteCombo.addItem(BASIC256RSA15);
        algoSuiteCombo.addItem(BASIC192RSA15);
        algoSuiteCombo.addItem(BASIC128RSA15);
        algoSuiteCombo.addItem(TRIPLEDESRSA15);
//        algoSuiteCombo.addItem(BASIC256SHA256);
//        algoSuiteCombo.addItem(BASIC192SHA256);
//        algoSuiteCombo.addItem(BASIC128SHA256);
//        algoSuiteCombo.addItem(TRIPLEDESSHA256);
//        algoSuiteCombo.addItem(BASIC256SHA256RSA15);
//        algoSuiteCombo.addItem(BASIC192SHA256RSA15);
//        algoSuiteCombo.addItem(BASIC128SHA256RSA15);
//        algoSuiteCombo.addItem(TRIPLEDESSHA256RSA15);
        inSync = false;
        
        addModifier(msgLayoutCombo);
        addModifier(algoSuiteCombo);        
        addModifier(encryptBeforeSigning);
        addModifier(encryptSignature);
        addModifier(includeTimestampChBox);
        addModifier(signEntireHeadersBodyChBox);
        
        sync();
        
    }
    
    private void sync() {
        inSync = true;
        
        WSDLComponent secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);

        if (secBinding != null) {
            String algosuite = AlgoSuiteModelHelper.getAlgorithmSuite(binding, model);
            if (algosuite == null) {
                AlgoSuiteModelHelper.setAlgorithmSuite(secBinding, BASIC128);
            }

            setAlgorithmSuite(AlgoSuiteModelHelper.getAlgorithmSuite(binding, model));
            setMessageLayout(SecurityPolicyModelHelper.getMessageLayout(binding, model));
            setEncryptBeforeSigning(SecurityPolicyModelHelper.isEncryptBeforeSigning(binding, model));
            setEncryptSignature(SecurityPolicyModelHelper.isEncryptSignature(binding, model));
            setIncludeTimestamp(SecurityPolicyModelHelper.isIncludeTimestamp(binding, model));
            setSignEntireHeadersBody(SecurityPolicyModelHelper.isSignEntireHeadersAndBody(binding, model));
        }
        
        enableDisable();
        
        inSync = false;
    }

    private void setAlgorithmSuite(String item) {
        if (item == null) {
            this.algoSuiteCombo.setSelectedIndex(0);
        } else {
            algoSuiteCombo.setSelectedItem(item);
        }
    }

    private void setMessageLayout(String item) {
        if (item == null) {
            this.msgLayoutCombo.setSelectedIndex(0);
        } else {
            msgLayoutCombo.setSelectedItem(item);
        }
    }
    
    private void setEncryptBeforeSigning(Boolean enable) {
        if (enable == null) {
            this.encryptBeforeSigning.setSelected(false);
        } else {
            this.encryptBeforeSigning.setSelected(enable);
        }
    }

    private void setEncryptSignature(Boolean enable) {
        if (enable == null) {
            this.encryptSignature.setSelected(false);
        } else {
            this.encryptSignature.setSelected(enable);
        }
    }

    private void setIncludeTimestamp(Boolean enable) {
        if (enable == null) {
            this.includeTimestampChBox.setSelected(false);
        } else {
            this.includeTimestampChBox.setSelected(enable);
        }
    }

    private void setSignEntireHeadersBody(Boolean enable) {
        if (enable == null) {
            this.signEntireHeadersBodyChBox.setSelected(false);
        } else {
            this.signEntireHeadersBodyChBox.setSelected(enable);
        }
    }
    
    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) 
                                && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }

    public void setValue(javax.swing.JComponent source, Object value) {
        WSDLComponent secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(binding, model);

        if (source.equals(algoSuiteCombo) && (!inSync)) {
            AlgoSuiteModelHelper.setAlgorithmSuite(secBinding, (String)algoSuiteCombo.getSelectedItem());
            return;
        }
        
        if (source.equals(msgLayoutCombo) && (!inSync)) {
            SecurityPolicyModelHelper.setLayout(secBinding, (String)msgLayoutCombo.getSelectedItem());
            
            return;
        }

        if (source.equals(includeTimestampChBox) && (!inSync)) {
            boolean enable = includeTimestampChBox.isSelected();
            if (SecurityPolicyModelHelper.isIncludeTimestamp(binding, model) != enable) {
                SecurityPolicyModelHelper.enableIncludeTimestamp(secBinding, enable);
                
            }
            return;
        }

        if (source.equals(signEntireHeadersBodyChBox) && (!inSync)) {
            boolean enable = signEntireHeadersBodyChBox.isSelected();
            if (SecurityPolicyModelHelper.isSignEntireHeadersAndBody(binding, model) != enable) {
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(binding, model, secBinding, enable);
                
            }
            return;
        }

        if (source.equals(encryptBeforeSigning) && (!inSync)) {
            boolean enable = encryptBeforeSigning.isSelected();
            if (SecurityPolicyModelHelper.isEncryptBeforeSigning(binding, model) != enable) {
                SecurityPolicyModelHelper.enableEncryptBeforeSigning(binding, model, secBinding, enable);
                
            }
            return;
        }

        if (source.equals(encryptSignature) && (!inSync)) {
            boolean enable = encryptSignature.isSelected();
            if (SecurityPolicyModelHelper.isEncryptSignature(binding, model) != enable) {
                SecurityPolicyModelHelper.enableEncryptSignature(binding, model, secBinding, enable);
                
            }
            return;
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {}

    public void rollbackValue(javax.swing.text.JTextComponent source) { }
    
    protected void endUIChange() { }

    public void linkButtonPressed(Object ddBean, String ddProperty) { }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        algoSuiteLabel = new javax.swing.JLabel();
        algoSuiteCombo = new javax.swing.JComboBox();
        msgLayoutLabel = new javax.swing.JLabel();
        msgLayoutCombo = new javax.swing.JComboBox();
        signEntireHeadersBodyChBox = new javax.swing.JCheckBox();
        includeTimestampChBox = new javax.swing.JCheckBox();
        encryptBeforeSigning = new javax.swing.JCheckBox();
        encryptSignature = new javax.swing.JCheckBox();

        algoSuiteLabel.setText("Algorithm Suite:");

        algoSuiteCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                algoSuiteComboActionPerformed(evt);
            }
        });

        msgLayoutLabel.setText("Security Header Layout:");

        msgLayoutCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                msgLayoutComboActionPerformed(evt);
            }
        });

        signEntireHeadersBodyChBox.setText("Sign entire headers and body");
        signEntireHeadersBodyChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        signEntireHeadersBodyChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        includeTimestampChBox.setText("Include Timestamp");
        includeTimestampChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        includeTimestampChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        encryptBeforeSigning.setText("Encrypt before signing");
        encryptBeforeSigning.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptBeforeSigning.setMargin(new java.awt.Insets(0, 0, 0, 0));

        encryptSignature.setText("Encrypt signature");
        encryptSignature.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptSignature.setMargin(new java.awt.Insets(0, 0, 0, 0));
        encryptSignature.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encryptSignatureActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(signEntireHeadersBodyChBox)
                    .add(encryptBeforeSigning)
                    .add(encryptSignature)
                    .add(includeTimestampChBox)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(algoSuiteLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(algoSuiteCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(msgLayoutLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(msgLayoutCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(254, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {algoSuiteCombo, msgLayoutCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(algoSuiteLabel)
                    .add(algoSuiteCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(msgLayoutLabel)
                    .add(msgLayoutCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(signEntireHeadersBodyChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptBeforeSigning)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptSignature)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(includeTimestampChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void encryptSignatureActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encryptSignatureActionPerformed
        setValue(encryptSignature, null);
    }//GEN-LAST:event_encryptSignatureActionPerformed

    private void msgLayoutComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_msgLayoutComboActionPerformed
        setValue(msgLayoutCombo, null);
    }//GEN-LAST:event_msgLayoutComboActionPerformed

    private void algoSuiteComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_algoSuiteComboActionPerformed
        setValue(algoSuiteCombo, null);
    }//GEN-LAST:event_algoSuiteComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox algoSuiteCombo;
    private javax.swing.JLabel algoSuiteLabel;
    private javax.swing.JCheckBox encryptBeforeSigning;
    private javax.swing.JCheckBox encryptSignature;
    private javax.swing.JCheckBox includeTimestampChBox;
    private javax.swing.JComboBox msgLayoutCombo;
    private javax.swing.JLabel msgLayoutLabel;
    private javax.swing.JCheckBox signEntireHeadersBodyChBox;
    // End of variables declaration//GEN-END:variables
    
}
