/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.util.Set;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

/**
 *
 * @author Martin Grebac
 */
public class STSConfigServicePanel extends SectionInnerPanel {
    
    private ServiceProvidersTablePanel panel;

    private WSDLModel model;
    private Node node;
    private Binding binding;
    private SectionView view;

    private static final String DEFAULT_LIFETIME = "300000";                     //NOI18N
    private static final String DEFAULT_CONTRACT_CLASS = "com.sun.xml.ws.trust.impl.IssueSamlTokenContractImpl"; //NOI18N

    private Project project;

    private boolean inSync = false;
    
    /**
     * Creates new form STSConfigServicePanel
     */
    public STSConfigServicePanel(SectionView sectionView, WSDLModel model, Node node, Binding binding) {
        super(sectionView);
        this.model = model;
        this.node = node;
        this.binding = binding;
        this.view = view;

        FileObject fo = (FileObject) node.getLookup().lookup(FileObject.class);
        if (fo != null) project = FileOwnerQuery.getOwner(fo);
        
        initComponents();
        
        contractButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        contractLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        contractTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptKeyChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptTokensChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        serviceProvidersPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        inSync = true;
        ServiceProvidersTablePanel.ServiceProvidersTableModel tablemodel = new ServiceProvidersTablePanel.ServiceProvidersTableModel();
        this.remove(serviceProvidersPanel);
        
        STSConfiguration stsConfig = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(binding);
        if (stsConfig == null) {
            stsConfig = ProprietarySecurityPolicyModelHelper.createSTSConfiguration(binding);
        }
        serviceProvidersPanel = new ServiceProvidersTablePanel(tablemodel, model, node, stsConfig);
        ((ServiceProvidersTablePanel)serviceProvidersPanel).populateModel();
        inSync = false;

        sync();
        
    }

    private void sync() {
        inSync = true;

        setEncryptKey(ProprietarySecurityPolicyModelHelper.getSTSEncryptKey(binding));
        setEncryptToken(ProprietarySecurityPolicyModelHelper.getSTSEncryptToken(binding));

        String lifeTime = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(binding);
        if (lifeTime == null) { // no setup exists yet - set the default
            setLifeTime(DEFAULT_LIFETIME);
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(binding, DEFAULT_LIFETIME);
        } else {
            setLifeTime(lifeTime);
        } 
        
        String cclass = ProprietarySecurityPolicyModelHelper.getSTSContractClass(binding);
        if (cclass == null) { // no setup exists yet - set the default
            setContractClass(DEFAULT_CONTRACT_CLASS);
            ProprietarySecurityPolicyModelHelper.setSTSContractClass(binding, DEFAULT_CONTRACT_CLASS);
        } else {
            setContractClass(cclass);
        } 
        
        refreshPanels();
        
        inSync = false;
    }
    
    private String getLifeTime() {
        return this.lifeTimeTextField.getText();
    }

    private void setLifeTime(String time) {
        this.lifeTimeTextField.setText(time);
    }
    
    private void setContractClass(String classname) {
        this.contractTextField.setText(classname);
    }

    private String getContractClass() {
        return contractTextField.getText();
    }

    private boolean getEncryptKey() {
        return encryptKeyChBox.isSelected();
    }
    
    private boolean getEncryptToken() {
        return encryptTokensChBox.isSelected();
    }

    private void setEncryptToken(Boolean encrypt) {
        if (encrypt == null) {
            this.encryptTokensChBox.setSelected(false);
        } else {
            this.encryptTokensChBox.setSelected(encrypt);
        }
    }

    private void setEncryptKey(Boolean encrypt) {
        if (encrypt == null) {
            this.encryptKeyChBox.setSelected(false);
        } else {
            this.encryptKeyChBox.setSelected(encrypt);
        }
    }
    
    private void refreshPanels() {
        updateLayout();
        revalidate();
        repaint();
    }
    
    private void updateLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serviceProvidersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(contractLabel)
                            .add(lifeTimeLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(contractTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 178, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(contractButton))
                            .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 90, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, encryptKeyChBox)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, encryptTokensChBox))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lifeTimeLabel)
                    .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(contractLabel)
                    .add(contractButton)
                    .add(contractTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptKeyChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptTokensChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(serviceProvidersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }
    
    public JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    public void linkButtonPressed(Object ddBean, String ddProperty) { }
    
    public void setValue(JComponent source, Object value) {
    
        if (!inSync) {
            if (source.equals(contractTextField)) {
                String cname = getContractClass();
                if ((cname == null) || (cname.length() == 0)) {
                    ProprietarySecurityPolicyModelHelper.setSTSContractClass(binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setSTSContractClass(binding, cname);
                }
                return;
            }

            String lifeTime = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(binding);
            if (lifeTime == null) { // no setup exists yet - set the default
                setLifeTime(DEFAULT_LIFETIME);
                ProprietarySecurityPolicyModelHelper.setSTSLifeTime(binding, DEFAULT_LIFETIME);
            } else {
                setLifeTime(lifeTime);
            } 

            if (source.equals(encryptKeyChBox)) {
                boolean enable = encryptKeyChBox.isSelected();
                ProprietarySecurityPolicyModelHelper.setSTSEncryptKey(binding, enable);
                return;
            }

            if (source.equals(encryptTokensChBox)) {
                boolean enable = encryptTokensChBox.isSelected();
                ProprietarySecurityPolicyModelHelper.setSTSEncryptToken(binding, enable);
                return;
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        serviceProvidersPanel = new javax.swing.JPanel();
        lifeTimeLabel = new javax.swing.JLabel();
        lifeTimeTextField = new javax.swing.JTextField();
        contractLabel = new javax.swing.JLabel();
        contractTextField = new javax.swing.JTextField();
        contractButton = new javax.swing.JButton();
        encryptKeyChBox = new javax.swing.JCheckBox();
        encryptTokensChBox = new javax.swing.JCheckBox();

        org.jdesktop.layout.GroupLayout serviceProvidersPanelLayout = new org.jdesktop.layout.GroupLayout(serviceProvidersPanel);
        serviceProvidersPanel.setLayout(serviceProvidersPanelLayout);
        serviceProvidersPanelLayout.setHorizontalGroup(
            serviceProvidersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 422, Short.MAX_VALUE)
        );
        serviceProvidersPanelLayout.setVerticalGroup(
            serviceProvidersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 189, Short.MAX_VALUE)
        );

        lifeTimeLabel.setText("Life Time of Issued Tokens (ms):");

        lifeTimeTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        contractLabel.setText("Contract implementation class:");

        contractButton.setText("Browse...");
        contractButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                contractButtonActionPerformed(evt);
            }
        });

        encryptKeyChBox.setText("Encrypt Issued Keys");
        encryptKeyChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptKeyChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        encryptKeyChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encryptKeyChBoxActionPerformed(evt);
            }
        });

        encryptTokensChBox.setText("Encrypt Issued Tokens");
        encryptTokensChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptTokensChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        encryptTokensChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encryptTokensChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serviceProvidersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(contractLabel)
                            .add(lifeTimeLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(contractTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 178, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(contractButton))
                            .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 90, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, encryptKeyChBox)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, encryptTokensChBox))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lifeTimeLabel)
                    .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(contractLabel)
                    .add(contractButton)
                    .add(contractTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptKeyChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptTokensChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(serviceProvidersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void encryptTokensChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encryptTokensChBoxActionPerformed
        setValue(encryptTokensChBox, null);
    }//GEN-LAST:event_encryptTokensChBoxActionPerformed

    private void encryptKeyChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encryptKeyChBoxActionPerformed
        setValue(encryptKeyChBox, null);
    }//GEN-LAST:event_encryptKeyChBoxActionPerformed

    private void contractButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_contractButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "com.sun.xml.ws.trust.WSTrustContract"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setContractClass(selectedClass);
                    ProprietarySecurityPolicyModelHelper.setSTSContractClass(binding, selectedClass);
                    break;
                }
            }
        }
    }//GEN-LAST:event_contractButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton contractButton;
    private javax.swing.JLabel contractLabel;
    private javax.swing.JTextField contractTextField;
    private javax.swing.JCheckBox encryptKeyChBox;
    private javax.swing.JCheckBox encryptTokensChBox;
    private javax.swing.JLabel lifeTimeLabel;
    private javax.swing.JTextField lifeTimeTextField;
    private javax.swing.JPanel serviceProvidersPanel;
    // End of variables declaration//GEN-END:variables
    
}
