/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.proprietary.KeyStore;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.proprietary.Validator;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.io.File;
import java.util.Set;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;

/**
 *
 * @author Martin Grebac
 */
public class KeystorePanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;

    private boolean inSync = false;
    
    private String keyStorePassword = null;
    private String trustStorePassword = null;
    
    private Project project;
    
    public KeystorePanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        
        FileObject fo = (FileObject) node.getLookup().lookup(FileObject.class);
        if (fo != null) project = FileOwnerQuery.getOwner(fo);
                
        initComponents();

        certAliasButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certAliasTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystoreLocationButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystoreLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        stsAliasTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        stsAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        stsAliasButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        peerAliasTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        peerAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        peerAliasButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        usernameValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        usernameValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        usernameValidatorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timestampValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timestampValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timestampValidatorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certificateValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certificateValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certificateValidatorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlValidatorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststoreLocationButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststoreLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        validatorsLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyStoreLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        trustStoreLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        certAliasButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_SelectButton"));
        stsAliasButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_SelectButton"));
        peerAliasButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_SelectButton"));
        
        validatorsLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_ValidatorsLabel"));
        keyStoreLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeystoreConfigLabel"));
        trustStoreLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TruststoreConfigLabel"));

        certAliasLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeyAliasLabel"));
        stsAliasLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_STSAliasLabel"));
        peerAliasLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_PeerAliasLabel"));
        keystoreLocationLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeyStoreLocationLabel"));
        truststoreLocationLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TrustStoreLocationLabel"));
        usernameValidatorLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_UsernameLabel"));
        samlValidatorLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_SamlLabel"));
        certificateValidatorLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_CertificateLabel"));
        timestampValidatorLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TimestampLabel"));

        keystoreLocationButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        truststoreLocationButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        usernameValidatorButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        samlValidatorButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        timestampValidatorButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        certificateValidatorButton.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_BrowseButton"));
        
        addModifier(keystoreLocationTextField);
        addModifier(truststoreLocationTextField);
        addModifier(certAliasTextField);
        addModifier(stsAliasTextField);
        addModifier(peerAliasTextField);
        addModifier(usernameValidatorTextField);
        addModifier(certificateValidatorTextField);
        addModifier(timestampValidatorTextField);
        addModifier(samlValidatorTextField);

        sync();
    }

    private String getKeystoreAlias() {
        return this.certAliasTextField.getText();
    }

    private void setKeystoreAlias(String alias) {
        this.certAliasTextField.setText(alias);
    }
    
    private String getSTSAlias() {
        return this.stsAliasTextField.getText();
    }

    private void setSTSAlias(String alias) {
        this.stsAliasTextField.setText(alias);
    }
    
    private String getPeerAlias() {
        return this.peerAliasTextField.getText();
    }

    private void setPeerAlias(String alias) {
        this.peerAliasTextField.setText(alias);
    }

    private String getValidator(String type) {
        if (Validator.USERNAME_VALIDATOR.equals(type)) return usernameValidatorTextField.getText();
        if (Validator.TIMESTAMP_VALIDATOR.equals(type)) return timestampValidatorTextField.getText();
        if (Validator.CERTIFICATE_VALIDATOR.equals(type)) return certificateValidatorTextField.getText();
        if (Validator.SAML_VALIDATOR.equals(type)) return samlValidatorTextField.getText();
        return null;
    }

    private void setValidator(String type, String validator) {
        if (Validator.USERNAME_VALIDATOR.equals(type)) this.usernameValidatorTextField.setText(validator);
        if (Validator.TIMESTAMP_VALIDATOR.equals(type)) this.timestampValidatorTextField.setText(validator);
        if (Validator.CERTIFICATE_VALIDATOR.equals(type)) this.certificateValidatorTextField.setText(validator);
        if (Validator.SAML_VALIDATOR.equals(type)) this.samlValidatorTextField.setText(validator);
    }
    
    private String getKeyStorePassword() {
        return keyStorePassword;
    }

    private void setKeyStorePassword(String password) {
        keyStorePassword = password;
    }

    private String getTrustStorePassword() {
        return trustStorePassword;
    }

    private void setTrustStorePassword(String password) {
        trustStorePassword = password;
    }
    
    private void setKeystorePath(String path) {
        this.keystoreLocationTextField.setText(path);
    }
    
    private String getKeystorePath() {
        String path = this.keystoreLocationTextField.getText();
        if ("".equals(path) || (path == null)) {    //NOI18N
            return null;
        }
        return path;
    }

    private void setTruststorePath(String path) {
        this.truststoreLocationTextField.setText(path);
    }

    private String getTruststorePath() {
        String path = this.truststoreLocationTextField.getText();
        if ("".equals(path) || (path == null)) {    //NOI18N
            return null;
        }
        return path;
    }
    
    public void sync() {
        inSync = true;
                
        J2eePlatform p = null;        
        JavaClass jc = (JavaClass)node.getLookup().lookup(JavaClass.class);
        JAXWSSupport ws = null;
        FileObject fo = null;
        if (jc != null) {
            fo = JavaModel.getFileObject(jc.getResource());
            if (fo != null) {
                ws = JAXWSSupport.getJAXWSSupport(fo);
            }
        }
        if ((ws != null) && (fo != null)) {
            Project project = FileOwnerQuery.getOwner(fo);
            if (project != null) {
                J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                String instance = mp.getServerInstanceID();
                p = Deployment.getDefault().getJ2eePlatform(instance);
            }
        }

        String tool = J2eePlatform.TOOL_KEYSTORE;
        String keyStoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(binding, false);
        if (keyStoreLocation == null) { // no setup exists yet - set the defaults from server
            if (p != null) {
                if (p.isToolSupported(tool)) {
                    File[] loc = p.getToolClasspathEntries(tool);
                    if ((loc != null) && (loc.length > 0)) {
                        File f = loc[0];
                        setKeystorePath(f.getPath());
                        ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, f.getPath(), false, false);
                        ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, false, false);
                    }
                }
            }
        } else {
            setKeystorePath(keyStoreLocation);
        } 

        tool = J2eePlatform.TOOL_TRUSTSTORE;
        String trustStoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(binding, true);
        if (trustStoreLocation == null) { // no setup exists yet - set the defaults from server
            if (p != null) {
                if (p.isToolSupported(tool)) {
                    File[] loc = p.getToolClasspathEntries(tool);
                    if ((loc != null) && (loc.length > 0)) {
                        File f = loc[0];
                        setTruststorePath(f.getPath());
                        ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, f.getPath(), true, false);
                        ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, true, false);
                    }
                }
            }
        } else {
            setTruststorePath(trustStoreLocation);
        } 

        String keyStoreAlias = ProprietarySecurityPolicyModelHelper.getKeyStoreAlias(binding);
        if (keyStoreAlias != null) { // no setup exists yet - set the default
            setKeystoreAlias(keyStoreAlias);
        }
        String stsAlias = ProprietarySecurityPolicyModelHelper.getTrustSTSAlias(binding);
        if (stsAlias != null) {
            setSTSAlias(stsAlias);
        }
        String peerAlias = ProprietarySecurityPolicyModelHelper.getTrustPeerAlias(binding);
        if (peerAlias != null) {
            setPeerAlias(peerAlias);
        }

        String usernameValidator = ProprietarySecurityPolicyModelHelper.getValidator(binding, Validator.USERNAME_VALIDATOR);
        if (usernameValidator != null) {
            setValidator(Validator.USERNAME_VALIDATOR, usernameValidator);
        }
        String timestampValidator = ProprietarySecurityPolicyModelHelper.getValidator(binding, Validator.TIMESTAMP_VALIDATOR);
        if (timestampValidator != null) {
            setValidator(Validator.TIMESTAMP_VALIDATOR, timestampValidator);
        }
        String certificateValidator = ProprietarySecurityPolicyModelHelper.getValidator(binding, Validator.CERTIFICATE_VALIDATOR);
        if (certificateValidator != null) {
            setValidator(Validator.CERTIFICATE_VALIDATOR, certificateValidator);
        }
        String samlValidator = ProprietarySecurityPolicyModelHelper.getValidator(binding, Validator.SAML_VALIDATOR);
        if (samlValidator != null) {
            setValidator(Validator.SAML_VALIDATOR, samlValidator);
        }
        inSync = false;
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        if (source.equals(keystoreLocationTextField)) {
            String loc = getKeystorePath();
            if ((loc != null) && (loc.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, null, false, false);
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, null, false, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, loc, false, false);
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, false, false);
            }
            return;
        }

        if (source.equals(truststoreLocationTextField)) {
            String loc = getTruststorePath();
            if ((loc != null) && (loc.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, null, true, false);
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, null, false, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, loc, true, false);
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, true, false);
            }
            return;
        }

        if (source.equals(certAliasTextField)) {
            String alias = getKeystoreAlias();
            if ((alias != null) && (alias.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(binding, alias, false);
            }
            return;
        }

        if (source.equals(stsAliasTextField)) {
            String alias = getSTSAlias();
            if ((alias != null) && (alias.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setTrustSTSAlias(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setTrustSTSAlias(binding, alias, false);
            }
            return;
        }

        if (source.equals(peerAliasTextField)) {
            String alias = getPeerAlias();
            if ((alias != null) && (alias.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(binding, alias, false);
            }
            return;
        }

        if (source.equals(usernameValidatorTextField)) {
            String validator = getValidator(Validator.USERNAME_VALIDATOR);
            if ((validator != null) && (validator.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.USERNAME_VALIDATOR, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.USERNAME_VALIDATOR, validator, false);
            }
            return;
        }

        if (source.equals(timestampValidatorTextField)) {
            String validator = getValidator(Validator.TIMESTAMP_VALIDATOR);
            if ((validator != null) && (validator.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.TIMESTAMP_VALIDATOR, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.TIMESTAMP_VALIDATOR, validator, false);
            }
            return;
        }

        if (source.equals(certificateValidatorTextField)) {
            String validator = getValidator(Validator.CERTIFICATE_VALIDATOR);
            if ((validator != null) && (validator.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.CERTIFICATE_VALIDATOR, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.CERTIFICATE_VALIDATOR,validator, false);
            }
            return;
        }

        if (source.equals(samlValidatorTextField)) {
            String validator = getValidator(Validator.SAML_VALIDATOR);
            if ((validator != null) && (validator.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.SAML_VALIDATOR, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.SAML_VALIDATOR, validator, false);
            }
            return;
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    private class KeystoreFileFilter extends FileFilter {
        private static final String JKS_EXT = ".jks";      //NOI18N
        public boolean accept(File f) {
            if ((f != null) && f.exists() && (f.getName() != null) && ((f.getName().contains(JKS_EXT)) || (f.isDirectory()))) {
                return true;
            }
            return false;
        }
        public String getDescription() {
            return NbBundle.getMessage(WSITEditor.class, "JKS_FILE");  //NOI18N
        }
    }

    private class JavaFileFilter extends FileFilter {
        private static final String JAVA_EXT = ".java";      //NOI18N
        public boolean accept(File f) {
            if ((f != null) && f.exists() && (f.getName() != null) && ((f.getName().contains(JAVA_EXT)) || (f.isDirectory()))) {
                return true;
            }
            return false;
        }
        public String getDescription() {
            return NbBundle.getMessage(WSITEditor.class, "JAVA_FILE");  //NOI18N
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        keystoreLocationLabel = new javax.swing.JLabel();
        truststoreLocationLabel = new javax.swing.JLabel();
        peerAliasLabel = new javax.swing.JLabel();
        certAliasLabel = new javax.swing.JLabel();
        keystoreLocationTextField = new javax.swing.JTextField();
        keystoreLocationButton = new javax.swing.JButton();
        truststoreLocationTextField = new javax.swing.JTextField();
        truststoreLocationButton = new javax.swing.JButton();
        peerAliasTextField = new javax.swing.JTextField();
        peerAliasButton = new javax.swing.JButton();
        certAliasTextField = new javax.swing.JTextField();
        stsAliasLabel = new javax.swing.JLabel();
        stsAliasTextField = new javax.swing.JTextField();
        jToggleButton1 = new javax.swing.JToggleButton();
        certAliasButton = new javax.swing.JButton();
        stsAliasButton = new javax.swing.JButton();
        keyStoreLabel = new javax.swing.JLabel();
        trustStoreLabel = new javax.swing.JLabel();
        validatorsLabel = new javax.swing.JLabel();
        usernameValidatorLabel = new javax.swing.JLabel();
        timestampValidatorLabel = new javax.swing.JLabel();
        certificateValidatorLabel = new javax.swing.JLabel();
        samlValidatorLabel = new javax.swing.JLabel();
        usernameValidatorTextField = new javax.swing.JTextField();
        timestampValidatorTextField = new javax.swing.JTextField();
        certificateValidatorTextField = new javax.swing.JTextField();
        samlValidatorTextField = new javax.swing.JTextField();
        usernameValidatorButton = new javax.swing.JButton();
        timestampValidatorButton = new javax.swing.JButton();
        certificateValidatorButton = new javax.swing.JButton();
        samlValidatorButton = new javax.swing.JButton();

        keystoreLocationLabel.setText("Location:");

        truststoreLocationLabel.setText("Location:");

        peerAliasLabel.setText("Peer Alias:");

        certAliasLabel.setText("Alias:");

        keystoreLocationButton.setText("Browse...");
        keystoreLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keystoreLocationButtonActionPerformed(evt);
            }
        });

        truststoreLocationButton.setText("Browse...");
        truststoreLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                truststoreLocationButtonActionPerformed(evt);
            }
        });

        peerAliasButton.setText("Select...");
        peerAliasButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                peerAliasButtonActionPerformed(evt);
            }
        });

        stsAliasLabel.setText("STS Alias:");

        jToggleButton1.setText("jToggleButton1");

        certAliasButton.setText("Select...");
        certAliasButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                certAliasButtonActionPerformed(evt);
            }
        });

        stsAliasButton.setText("Select...");
        stsAliasButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stsAliasButtonActionPerformed(evt);
            }
        });

        keyStoreLabel.setText("Keystore configuration:");

        trustStoreLabel.setText("Truststore configuration:");

        validatorsLabel.setText("Validators:");

        usernameValidatorLabel.setText("Username Validator:");

        timestampValidatorLabel.setText("TimestampValidator:");

        certificateValidatorLabel.setText("Certificate Validator:");

        samlValidatorLabel.setText("SAML Assertion Validator:");

        usernameValidatorButton.setText("Browse...");
        usernameValidatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usernameValidatorButtonActionPerformed(evt);
            }
        });

        timestampValidatorButton.setText("Browse...");
        timestampValidatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timestampValidatorButtonActionPerformed(evt);
            }
        });

        certificateValidatorButton.setText("Browse...");
        certificateValidatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                certificateValidatorButtonActionPerformed(evt);
            }
        });

        samlValidatorButton.setText("Browse...");
        samlValidatorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samlValidatorButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(keyStoreLabel)
                    .add(trustStoreLabel)
                    .add(truststoreLocationLabel)
                    .add(peerAliasLabel)
                    .add(stsAliasLabel)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(keystoreLocationLabel)
                            .add(certAliasLabel))
                        .add(25, 25, 25)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(layout.createSequentialGroup()
                                .add(keystoreLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 322, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(6, 6, 6)
                                .add(keystoreLocationButton))
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, certAliasTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 322, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(truststoreLocationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 323, Short.MAX_VALUE)
                                    .add(peerAliasTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 323, Short.MAX_VALUE)
                                    .add(stsAliasTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 323, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(timestampValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(certificateValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(usernameValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 266, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(certificateValidatorButton)
                                    .add(timestampValidatorButton)
                                    .add(usernameValidatorButton)
                                    .add(stsAliasButton)
                                    .add(peerAliasButton)
                                    .add(layout.createSequentialGroup()
                                        .add(certAliasButton)
                                        .add(49, 49, 49)
                                        .add(jToggleButton1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 0, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                    .add(truststoreLocationButton)))))
                    .add(validatorsLabel)
                    .add(timestampValidatorLabel)
                    .add(certificateValidatorLabel)
                    .add(layout.createSequentialGroup()
                        .add(samlValidatorLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(samlValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(samlValidatorButton))
                    .add(usernameValidatorLabel)))
        );

        layout.linkSize(new java.awt.Component[] {peerAliasTextField, stsAliasTextField, truststoreLocationTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] {certificateValidatorTextField, samlValidatorTextField, timestampValidatorTextField, usernameValidatorTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] {certAliasButton, keystoreLocationButton, peerAliasButton, stsAliasButton, truststoreLocationButton, usernameValidatorButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] {certAliasTextField, keystoreLocationTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(keyStoreLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(keystoreLocationLabel)
                            .add(keystoreLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(keystoreLocationButton))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(certAliasLabel)
                            .add(certAliasTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(certAliasButton)))
                    .add(layout.createSequentialGroup()
                        .add(58, 58, 58)
                        .add(jToggleButton1)))
                .add(18, 18, 18)
                .add(trustStoreLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(truststoreLocationButton)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(truststoreLocationLabel)
                        .add(truststoreLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(peerAliasLabel)
                    .add(peerAliasTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(peerAliasButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(stsAliasLabel)
                    .add(stsAliasTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(stsAliasButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 34, Short.MAX_VALUE)
                .add(validatorsLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(usernameValidatorLabel)
                    .add(usernameValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(usernameValidatorButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timestampValidatorLabel)
                    .add(timestampValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timestampValidatorButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(certificateValidatorLabel)
                    .add(certificateValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(certificateValidatorButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(samlValidatorLabel)
                    .add(samlValidatorTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(samlValidatorButton))
                .add(34, 34, 34))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void samlValidatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samlValidatorButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "com.sun.xml.wss.impl.callback.SAMLAssertionValidator"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setValidator(Validator.SAML_VALIDATOR, selectedClass);
                    ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.SAML_VALIDATOR, selectedClass, false);
                    break;
                }
            }
        }
    }//GEN-LAST:event_samlValidatorButtonActionPerformed

    private void certificateValidatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_certificateValidatorButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "com.sun.xml.wss.impl.callback.CertificateValidationCallback.CertificateValidator"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setValidator(Validator.CERTIFICATE_VALIDATOR, selectedClass);
                    ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.CERTIFICATE_VALIDATOR, selectedClass, false);
                    break;
                }
            }
        }
    }//GEN-LAST:event_certificateValidatorButtonActionPerformed

    private void timestampValidatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timestampValidatorButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "com.sun.xml.wss.impl.callback.TimestampValidationCallback.TimestampValidator"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setValidator(Validator.TIMESTAMP_VALIDATOR, selectedClass);
                    ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.TIMESTAMP_VALIDATOR, selectedClass, false);             
                    break;
                }
            }
        }
    }//GEN-LAST:event_timestampValidatorButtonActionPerformed

    private void usernameValidatorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usernameValidatorButtonActionPerformed
        if (project != null) {
            ClassDialog classDialog = new ClassDialog(project, "com.sun.xml.wss.impl.callback.PasswordValidationCallback.PasswordValidator"); //NOI18N
            classDialog.show();
            if (classDialog.okButtonPressed()) {
                Set<String> selectedClasses = classDialog.getSelectedClasses();
                for (String selectedClass : selectedClasses) {
                    setValidator(Validator.USERNAME_VALIDATOR, selectedClass);
                    ProprietarySecurityPolicyModelHelper.setValidator(binding, Validator.USERNAME_VALIDATOR, selectedClass, false);   
                    break;
                }
            }
        }
    }//GEN-LAST:event_usernameValidatorButtonActionPerformed

    private void stsAliasButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stsAliasButtonActionPerformed
        String path = getTruststorePath();
        if ((path == null) || ("".equals(path.trim()))) {       //NOI18N
            return;
        }
        KeyAliasSelectorPanel selectKey = new KeyAliasSelectorPanel(path, getSTSAlias());
        DialogDescriptor dd = new DialogDescriptor(
                selectKey, 
                NbBundle.getMessage(KeystorePanel.class, "LBL_SelectKeyAlias_Title"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(KeystorePanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (selectKey != null) {
                String alias = selectKey.getAlias();
                setSTSAlias(alias);
                String password = selectKey.getStringPassword();
                setTrustStorePassword(password);
                ProprietarySecurityPolicyModelHelper.setTrustSTSAlias(binding, alias, false);
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, password, true, false);
            }
        }
    }//GEN-LAST:event_stsAliasButtonActionPerformed

    private void certAliasButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_certAliasButtonActionPerformed
        String path = getKeystorePath();
        if ((path == null) || ("".equals(path.trim()))) {       //NOI18N
            return;
        }
        KeyAliasSelectorPanel selectKey = new KeyAliasSelectorPanel(path, getKeystoreAlias());
        DialogDescriptor dd = new DialogDescriptor(
                selectKey, 
                NbBundle.getMessage(KeystorePanel.class, "LBL_SelectKeyAlias_Title"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(KeystorePanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (selectKey != null) {
                String alias = selectKey.getAlias();
                setKeystoreAlias(alias);
                String password = selectKey.getStringPassword();
                setKeyStorePassword(password);
                ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(binding, alias, false);
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, password, false, false);
            }
        }
    }//GEN-LAST:event_certAliasButtonActionPerformed

    private void peerAliasButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_peerAliasButtonActionPerformed
        String path = getTruststorePath();
        if ((path == null) || ("".equals(path.trim()))) {       //NOI18N
            return;
        }
        KeyAliasSelectorPanel selectKey = new KeyAliasSelectorPanel(path, getPeerAlias());
        DialogDescriptor dd = new DialogDescriptor(
                selectKey, 
                NbBundle.getMessage(KeystorePanel.class, "LBL_SelectKeyAlias_Title"),  //NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.CANCEL_OPTION, 
                DialogDescriptor.DEFAULT_ALIGN,
                new HelpCtx(KeystorePanel.class),
                null);
        if (DialogDisplayer.getDefault().notify(dd).equals(DialogDescriptor.OK_OPTION)) {
            if (selectKey != null) {
                String alias = selectKey.getAlias();
                setPeerAlias(alias);
                String password = selectKey.getStringPassword();
                setTrustStorePassword(password);
                ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(binding, alias, false);
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, password, true, false);
            }
        }
    }//GEN-LAST:event_peerAliasButtonActionPerformed
    
    private void truststoreLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_truststoreLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, "LBL_TruststoreBrowse_Title"));
        chooser.setFileSelectionMode (JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new KeystoreFileFilter());
        File f = new File(truststoreLocationTextField.getText());
        File dir = null;
        if ((f != null) && (f.exists())) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this)== JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            if (file != null) {
                setTruststorePath(file.getPath());
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, file.getPath(), true, false);
            }
        }
    }//GEN-LAST:event_truststoreLocationButtonActionPerformed

    private void keystoreLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keystoreLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, "LBL_KeystoreBrowse_Title"));
        chooser.setFileSelectionMode (JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new KeystoreFileFilter());
        File f = new File(truststoreLocationTextField.getText());
        File dir = null;
        if ((f != null) && (f.exists())) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this)== JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            if (file != null) {
                setKeystorePath(file.getPath());
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, file.getPath(), false, false);
            }
        }
    }//GEN-LAST:event_keystoreLocationButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton certAliasButton;
    private javax.swing.JLabel certAliasLabel;
    private javax.swing.JTextField certAliasTextField;
    private javax.swing.JButton certificateValidatorButton;
    private javax.swing.JLabel certificateValidatorLabel;
    private javax.swing.JTextField certificateValidatorTextField;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JLabel keyStoreLabel;
    private javax.swing.JButton keystoreLocationButton;
    private javax.swing.JLabel keystoreLocationLabel;
    private javax.swing.JTextField keystoreLocationTextField;
    private javax.swing.JButton peerAliasButton;
    private javax.swing.JLabel peerAliasLabel;
    private javax.swing.JTextField peerAliasTextField;
    private javax.swing.JButton samlValidatorButton;
    private javax.swing.JLabel samlValidatorLabel;
    private javax.swing.JTextField samlValidatorTextField;
    private javax.swing.JButton stsAliasButton;
    private javax.swing.JLabel stsAliasLabel;
    private javax.swing.JTextField stsAliasTextField;
    private javax.swing.JButton timestampValidatorButton;
    private javax.swing.JLabel timestampValidatorLabel;
    private javax.swing.JTextField timestampValidatorTextField;
    private javax.swing.JLabel trustStoreLabel;
    private javax.swing.JButton truststoreLocationButton;
    private javax.swing.JLabel truststoreLocationLabel;
    private javax.swing.JTextField truststoreLocationTextField;
    private javax.swing.JButton usernameValidatorButton;
    private javax.swing.JLabel usernameValidatorLabel;
    private javax.swing.JTextField usernameValidatorTextField;
    private javax.swing.JLabel validatorsLabel;
    // End of variables declaration//GEN-END:variables
    
}
