/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;

/**
 *
 * @author  Martin Grebac
 */
public class KeyAliasSelectorPanel extends javax.swing.JPanel {
    
    private String keystorePath;

    private Enumeration<String> aliases;
    
    private static final String KEYTYPE = "JKS";
    
    // default password for JWSDP keystores
    private static final String DEFAULT_PASSWORD_STR = "changeit"; // NOI18N

    /**
     * Creates new form KeyAliasSelectorPanel
     */
    public KeyAliasSelectorPanel(String keystorePath, String selected) {
        super();
        this.keystorePath = keystorePath;
        
        initComponents();

        keyAliasLabel.setText(NbBundle.getMessage(KeyAliasSelectorPanel.class, "LBL_KeyAlias"));    //NOI18N
        passwdLabel.setText(NbBundle.getMessage(KeyAliasSelectorPanel.class, "LBL_KeyStorePasswd"));    //NOI18N
        loadKeysButton.setText(NbBundle.getMessage(KeyAliasSelectorPanel.class, "LBL_LoadKeysButton"));    //NOI18N
        setPassword(DEFAULT_PASSWORD_STR);
        
        keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        loadKeysButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        passwdField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        passwdLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        aliases = getAliases(keystorePath);
        while (aliases.hasMoreElements()){
            String alias = aliases.nextElement();
            keyAliasCombo.addItem(alias);
        }
        keyAliasCombo.setSelectedItem(selected);
    }
    
    private char[] getPassword() {
        return this.passwdField.getPassword();
    }
    
    public String getStringPassword() {
        return String.valueOf(getPassword());
    }
    
    private void setPassword(String passwd) {
        this.passwdField.setText(passwd);
    }

    private Enumeration<String> getAliases(String keystorePath) {
        FileInputStream iStream;
        try {
            iStream = new FileInputStream(new File(keystorePath));
            KeyStore keyStore;
            keyStore = KeyStore.getInstance(KEYTYPE);
            char[] passwd = getPassword();
            keyStore.load(iStream, passwd);
            return keyStore.aliases();
        } catch (FileNotFoundException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex); 
        } catch (KeyStoreException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex); 
        } catch (NoSuchAlgorithmException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex); 
        } catch (CertificateException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex); 
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex); 
        }
        return null;
    }
    
    public String getAlias() {
        return (String)keyAliasCombo.getSelectedItem();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        keyAliasLabel = new javax.swing.JLabel();
        keyAliasCombo = new javax.swing.JComboBox();
        passwdLabel = new javax.swing.JLabel();
        loadKeysButton = new javax.swing.JButton();
        passwdField = new javax.swing.JPasswordField();

        keyAliasLabel.setText("Key alias:");

        passwdLabel.setText("KeyStore password:");

        loadKeysButton.setText("Load keys");
        loadKeysButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadKeysButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(keyAliasLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(keyAliasCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(9, 9, 9))
                    .add(layout.createSequentialGroup()
                        .add(passwdLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(passwdField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 86, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(loadKeysButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(passwdLabel)
                    .add(loadKeysButton)
                    .add(passwdField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keyAliasLabel)
                    .add(keyAliasCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void loadKeysButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadKeysButtonActionPerformed
        aliases = getAliases(keystorePath);
        keyAliasCombo.removeAllItems();
        if (aliases != null) {
            while (aliases.hasMoreElements()){
                String alias = aliases.nextElement();
                keyAliasCombo.addItem(alias);
            }
        }
    }//GEN-LAST:event_loadKeysButtonActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox keyAliasCombo;
    private javax.swing.JLabel keyAliasLabel;
    private javax.swing.JButton loadKeysButton;
    private javax.swing.JPasswordField passwdField;
    private javax.swing.JLabel passwdLabel;
    // End of variables declaration//GEN-END:variables
    
}
