/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class HttpsPanel extends javax.swing.JPanel {
    
    private WSDLComponent secBinding;
    private WSDLModel model;
    private Binding binding;
    
    private HttpsToken transportToken;

    private boolean inSync = false;
    
    /**
     * Creates new form HttpsPanel
     */
    public HttpsPanel(Binding b, WSDLModel model, WSDLComponent secBinding) {
        super();
        this.secBinding = secBinding;
        this.binding = b;
        this.model = model;
        initComponents();
  
        requireClientCertificateChBox.setText(NbBundle.getMessage(HttpsPanel.class, "LBL_RequireClientCertificate"));
        
        requireClientCertificateChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        sync();
    }
    
    private void sync() {
        inSync = true;

        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), TransportToken.class);
        transportToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(tokenKind, HttpsToken.class);
        
        setRequireClientCertificate(SecurityTokensModelHelper.isRequireClientCertificate(transportToken));
        
        inSync = false;
    }
    
    public WSDLComponent getSecBinding() {
        return secBinding;
    }

    public void setSecBinding(WSDLComponent secBinding) {
        this.secBinding = secBinding;
        sync();
    }
    
    private void setRequireClientCertificate(Boolean enable) {
        if (enable == null) {
            this.requireClientCertificateChBox.setSelected(false);
        } else {
            this.requireClientCertificateChBox.setSelected(enable);
        }
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        if (!inSync) {
            if (source.equals(requireClientCertificateChBox)) {
                SecurityTokensModelHelper.setRequireClientCertificate(transportToken, requireClientCertificateChBox.isSelected());
                return;
            }
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        requireClientCertificateChBox = new javax.swing.JCheckBox();

        requireClientCertificateChBox.setText("Require client certificate");
        requireClientCertificateChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireClientCertificateChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireClientCertificateChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireClientCertificateChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(requireClientCertificateChBox)
                .addContainerGap(189, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(requireClientCertificateChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void requireClientCertificateChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireClientCertificateChBoxActionPerformed
        setValue(requireClientCertificateChBox, null);
    }//GEN-LAST:event_requireClientCertificateChBoxActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox requireClientCertificateChBox;
    // End of variables declaration//GEN-END:variables
    
}
