/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class AdvancedConfigPanelService extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    private boolean inSync = false;

    private static final String DEFAULT_MAXNONCEAGE = "900000";                 //NOI18N
    private static final String DEFAULT_TIMESTAMP_FRESHNESS_LIMIT = "1200000";  //NOI18N
    private static final String DEFAULT_MAXCLOCKSKEW = "1200000";               //NOI18N
    private static final String DEFAULT_LIFETIME = "36000";                     //NOI18N
    
    public AdvancedConfigPanelService(SectionView view, Node node, Binding binding) {
        super(view);
        this.model = binding.getModel();
        this.node = node;
        this.binding = binding;
        
        initComponents();

        maxNonceAgeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        maxNonceAgeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        maximumSkewLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        maximumSkewTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timeFreshnessLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timeFreshnessTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
    
        maxNonceAgeLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_MaxNonceAgeLabel"));
        maximumSkewLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_MaxSkewLabel"));
        timeFreshnessLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_MaxTimeFreshness"));
        lifeTimeLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_SCTokenLifeTime"));
        
        addModifier(maxNonceAgeTextField);
        addModifier(maximumSkewTextField);
        addModifier(timeFreshnessTextField);
        addModifier(lifeTimeTextField);
        
        addValidatee(maxNonceAgeTextField);
        addValidatee(maximumSkewTextField);
        addValidatee(timeFreshnessTextField);
        addValidatee(lifeTimeTextField);

        sync();
    }

    public void sync() {
        inSync = true;

        String maxNonceAge = ProprietarySecurityPolicyModelHelper.getMaxNonceAge(binding, false);
        if (maxNonceAge == null) { // no setup exists yet - set the default
            setMaxNonceAge(DEFAULT_MAXNONCEAGE);
            ProprietarySecurityPolicyModelHelper.setMaxNonceAge(binding, DEFAULT_MAXNONCEAGE, false);
        } else {
            setMaxNonceAge(maxNonceAge);
        }
        
        String maxClockSkew = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(binding, false);
        if (maxClockSkew == null) { // no setup exists yet - set the default
            setMaxClockSkew(DEFAULT_MAXCLOCKSKEW);
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, DEFAULT_MAXCLOCKSKEW, false);
        } else {
            setMaxClockSkew(maxClockSkew);
        } 

        String timestampFreshness = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(binding, false);
        if (timestampFreshness == null) { // no setup exists yet - set the default
            setTimestampFreshness(DEFAULT_TIMESTAMP_FRESHNESS_LIMIT);
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, DEFAULT_TIMESTAMP_FRESHNESS_LIMIT, false);
        } else {
            setTimestampFreshness(timestampFreshness);
        } 

        String lifeTime = ProprietarySecurityPolicyModelHelper.getLifeTime(binding, false);
        if (lifeTime == null) { // no setup exists yet - set the default
            setLifeTime(DEFAULT_LIFETIME);
            ProprietarySecurityPolicyModelHelper.setLifeTime(binding, DEFAULT_LIFETIME, false);
        } else {
            setLifeTime(lifeTime);
        } 
        
        inSync = false;
    }

    private String getMaxNonceAge() {
        return this.maxNonceAgeTextField.getText();
    }

    private void setMaxNonceAge(String maxNonceAge) {
        this.maxNonceAgeTextField.setText(maxNonceAge);
    }

    private String getLifeTime() {
        return this.lifeTimeTextField.getText();
    }

    private void setLifeTime(String time) {
        this.lifeTimeTextField.setText(time);
    }

    private String getMaxClockSkew() {
        return this.maximumSkewTextField.getText();
    }

    private void setMaxClockSkew(String maxClockSkew) {
        this.maximumSkewTextField.setText(maxClockSkew);
    }

    private String getTimestampFreshness() {
        return this.timeFreshnessTextField.getText();
    }

    private void setTimestampFreshness(String timestampFreshness) {
        this.timeFreshnessTextField.setText(timestampFreshness);
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        if (source.equals(maxNonceAgeTextField)) {
            String maxNonceAge = getMaxNonceAge();
            if ((maxNonceAge != null) && (maxNonceAge.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setMaxNonceAge(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setMaxNonceAge(binding, maxNonceAge, false);
            }
            return;
        }

        if (source.equals(lifeTimeTextField)) {
            String lifeTime = getLifeTime();
            if ((lifeTime != null) && (lifeTime.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setLifeTime(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setLifeTime(binding, lifeTime, false);
            }
            return;
        }
        
        if (source.equals(maximumSkewTextField)) {
            String maxSkew = getMaxClockSkew();
            if ((maxSkew != null) && (maxSkew.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, maxSkew, false);
            }
            return;
        }

        if (source.equals(timeFreshnessTextField)) {
            String timestampFreshness = getTimestampFreshness();
            if ((timestampFreshness != null) && (timestampFreshness.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, null, false);
            } else {
                ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, timestampFreshness, false);
            }
            return;
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        maxNonceAgeLabel = new javax.swing.JLabel();
        timeFreshnessLabel = new javax.swing.JLabel();
        maximumSkewLabel = new javax.swing.JLabel();
        maxNonceAgeTextField = new javax.swing.JTextField();
        timeFreshnessTextField = new javax.swing.JTextField();
        maximumSkewTextField = new javax.swing.JTextField();
        lifeTimeLabel = new javax.swing.JLabel();
        lifeTimeTextField = new javax.swing.JTextField();

        maxNonceAgeLabel.setText("Maximum nonce age:");
        maxNonceAgeLabel.setToolTipText("The maximum number of seconds the nonce is cached by the server for detecting a nonce replay. ");

        timeFreshnessLabel.setText("Timestamp Freshness Limit:");
        timeFreshnessLabel.setToolTipText("The maximum number of seconds the time stamp remains valid.");

        maximumSkewLabel.setText("Maximum Clock Skew:");
        maximumSkewLabel.setToolTipText("The maximum number of seconds the sending clock can deviate from the receiving clock.");

        maxNonceAgeTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        timeFreshnessTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        maximumSkewTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        lifeTimeLabel.setText("Secure Conversation Token Life Time:");

        lifeTimeTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(timeFreshnessLabel)
                    .add(maximumSkewLabel)
                    .add(maxNonceAgeLabel)
                    .add(lifeTimeLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(maxNonceAgeTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 53, Short.MAX_VALUE)
                    .add(maximumSkewTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timeFreshnessTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 53, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {lifeTimeTextField, maxNonceAgeTextField, maximumSkewTextField, timeFreshnessTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timeFreshnessLabel)
                    .add(timeFreshnessTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(maximumSkewLabel)
                    .add(maximumSkewTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(maxNonceAgeLabel)
                    .add(maxNonceAgeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lifeTimeLabel)
                    .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lifeTimeLabel;
    private javax.swing.JTextField lifeTimeTextField;
    private javax.swing.JLabel maxNonceAgeLabel;
    private javax.swing.JTextField maxNonceAgeTextField;
    private javax.swing.JLabel maximumSkewLabel;
    private javax.swing.JTextField maximumSkewTextField;
    private javax.swing.JLabel timeFreshnessLabel;
    private javax.swing.JTextField timeFreshnessTextField;
    // End of variables declaration//GEN-END:variables
    
}
