/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.messaging;

import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMMSModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSunModelHelper;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class ReliabilityPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    private String inTimeoutBkp;
    private String maxRcvBufferBkp;
    
    private static final String DEFAULT_TIMEOUT = "600000";         //NOI18N
    private static final String DEFAULT_MAXRCVBUFFERSIZE = "32";    //NOI18N

    public ReliabilityPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();
        reliabilityChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        orderedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        flowControlChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        addImmediateModifier(reliabilityChBox);
        addImmediateModifier(orderedChBox);
        addImmediateModifier(flowControlChBox);
        addImmediateModifier(maxBufTextField);
        addImmediateModifier(inactivityTextField);

        addValidatee(maxBufTextField);
        addValidatee(inactivityTextField);
        
        sync();
    }

    private void sync() {
        boolean rmEnabled = RMModelHelper.isRMEnabled(binding, model);
        setRM(rmEnabled);
        
        String inactivityTimeout = RMModelHelper.getInactivityTimeout(binding, model);
        if (inactivityTimeout == null) { // no setup exists yet - set the default
            setInactivityTimeout(DEFAULT_TIMEOUT);
            RMModelHelper.setInactivityTimeout(binding, model, DEFAULT_TIMEOUT);
        } else {
            setInactivityTimeout(inactivityTimeout);
        } 

        String maxRcvBufferSize = RMMSModelHelper.getMaxReceiveBufferSize(binding, model);
        if (maxRcvBufferSize == null) { // no setup exists yet - set the default
            setMaxRcvBufferSize(DEFAULT_MAXRCVBUFFERSIZE);
            RMMSModelHelper.setMaxReceiveBufferSize(binding, model, DEFAULT_MAXRCVBUFFERSIZE);
        } else {
            setMaxRcvBufferSize(maxRcvBufferSize);
        } 

        setFlowControl(RMMSModelHelper.isFlowControlEnabled(binding, model));
        setOrdered(RMSunModelHelper.isOrderedEnabled(binding, model));
        enableDisable();
    }
        
    public void setValue(javax.swing.JComponent source, Object value) {
        
        if (source.equals(reliabilityChBox)) {
            if (reliabilityChBox.isSelected()) {
                if (!(RMModelHelper.isRMEnabled(binding, model))) {
                    RMModelHelper.enableRM(binding, model);
//                    setter.setDirty();
                }
            } else {
                if (RMModelHelper.isRMEnabled(binding, model)) {
                    RMModelHelper.disableRM(binding, model);
                    RMMSModelHelper.disableFlowControl(binding, model);
                    RMSunModelHelper.disableOrdered(binding, model);
                    RMModelHelper.setInactivityTimeout(binding, model, null);
                    RMMSModelHelper.setMaxReceiveBufferSize(binding, model, null);
//                    setter.setDirty();
                }
            }
            return;
        }
        
        if (source.equals(flowControlChBox)) {
            if (flowControlChBox.isSelected()) {
                if (!(RMMSModelHelper.isFlowControlEnabled(binding, model))) {
                    RMMSModelHelper.enableFlowControl(binding, model);
//                    setter.setDirty();
                }
            } else {
                if (RMMSModelHelper.isFlowControlEnabled(binding, model)) {
                    RMMSModelHelper.disableFlowControl(binding, model);
//                    setter.setDirty();
                }
            }
            return;
        }
        
        if (source.equals(orderedChBox)) {
            if (orderedChBox.isSelected()) {
                if (!(RMSunModelHelper.isOrderedEnabled(binding, model))) {
                    RMSunModelHelper.enableOrdered(binding, model);
//                    setter.setDirty();
                }
            } else {
                if (RMSunModelHelper.isOrderedEnabled(binding, model)) {
                    RMSunModelHelper.disableOrdered(binding, model);
//                    setter.setDirty();
                }
            }
            return;
        }

        if (source.equals(inactivityTextField)) {
            String timeout = getInactivityTimeout();
//            inTimeoutBkp = RMModelHelper.getInactivityTimeout(binding, model);
            if ((timeout != null) && (timeout.length() == 0)) {
                RMModelHelper.setInactivityTimeout(binding, model, null);
//                setter.setDirty();
            } else {
                RMModelHelper.setInactivityTimeout(binding, model, timeout);
//                setter.setDirty();
            }
            return;
        }

        if (source.equals(maxBufTextField)) {
            String bufSize = getMaxRcvBufferSize();
//            if (Utilities.isPositiveNumber(getMaxRcvBufferSize(), false, true)) {
//                maxRcvBufferBkp = RMMSModelHelper.getMaxReceiveBufferSize(binding, model);
//            }
            if ((bufSize != null) && (bufSize.length() == 0)) {
                RMMSModelHelper.setMaxReceiveBufferSize(binding, model, null);
//                setter.setDirty();
            } else {
                RMMSModelHelper.setMaxReceiveBufferSize(binding, model, bufSize);
//                setter.setDirty();
            }
            return;
        }
    }

    // rmassertion
    private void setRM(Boolean enable) {
        if (enable == null) {
            this.reliabilityChBox.setSelected(false);
        } else {
            this.reliabilityChBox.setSelected(enable);
        }
    }

    public Boolean getRM() {
        if (reliabilityChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    // max receive buffer size
    private String getMaxRcvBufferSize() {
        return this.maxBufTextField.getText();
    }
    
    private void setMaxRcvBufferSize(String value) {
        this.maxBufTextField.setText(value);
    }

    // inactivity timeout
    private String getInactivityTimeout() {
        return this.inactivityTextField.getText();
    }
    
    private void setInactivityTimeout(String value) {
        this.inactivityTextField.setText(value);
    }
    
    // flow control
    private void setFlowControl(Boolean enable) {
        if (enable == null) {
            this.flowControlChBox.setSelected(false);
        } else {
            this.flowControlChBox.setSelected(enable);
        }
    }

    public Boolean getFlowControl() {
        if (flowControlChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    // ordered delivery
    private void setOrdered(Boolean enable) {
        if (enable == null) {
            this.orderedChBox.setSelected(false);
        } else {
            this.orderedChBox.setSelected(enable);
        }
    }

    public Boolean getOrdered() {
        if (orderedChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
        SectionView view = getSectionView();
        if (comp == inactivityTextField) { 
            if (!Utilities.isPositiveNumber(getInactivityTimeout(), true, true)) {
                if (view != null) {
                    view.getErrorPanel().
                        setError(new Error(Error.TYPE_FATAL,
                        Error.ERROR_MESSAGE, value, comp));
                }
                return;
            } else if (Utilities.isPositiveNumber(getInactivityTimeout(), true, false)) {
                inTimeoutBkp = getInactivityTimeout();
            }
        }
        if (comp == maxBufTextField) { 
            if (!Utilities.isPositiveNumber(getMaxRcvBufferSize(), false, true)) {
                if (view != null) {
                    view.getErrorPanel().
                        setError(new Error(Error.TYPE_FATAL,
                        Error.ERROR_MESSAGE, value, comp));
                }
                return;
            } else if (Utilities.isPositiveNumber(getMaxRcvBufferSize(), false, false)) {
                maxRcvBufferBkp = getMaxRcvBufferSize();
            }
        }
        enableDisable();
        if (view != null) {
            view.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
        if (source == inactivityTextField) {
            if ((inTimeoutBkp != null) && (inTimeoutBkp.length() == 0)) {
                RMModelHelper.setInactivityTimeout(binding, model, null);
            } else {
                RMModelHelper.setInactivityTimeout(binding, model, inTimeoutBkp);
            }
            setInactivityTimeout(inTimeoutBkp);
        }
        if (source == maxBufTextField) {
            if ((maxRcvBufferBkp != null) && (maxRcvBufferBkp.length() == 0)) {
                RMMSModelHelper.setMaxReceiveBufferSize(binding, model, null);
            } else {
                RMMSModelHelper.setMaxReceiveBufferSize(binding, model, maxRcvBufferBkp);
            }
            setMaxRcvBufferSize(maxRcvBufferBkp);
        }
    }
    
    protected void endUIChange() { }

    public void linkButtonPressed(Object ddBean, String ddProperty) { }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return new JButton();
    }
    
    private void enableDisable() {
        boolean relSelected = reliabilityChBox.isSelected();
        orderedChBox.setEnabled(relSelected);
        inactivityTextField.setEnabled(relSelected);
        inactivityLabel.setEnabled(relSelected);
        flowControlChBox.setEnabled(relSelected);

        boolean flowSelected = flowControlChBox.isSelected();
        maxBufLabel.setEnabled(relSelected && flowSelected);
        maxBufTextField.setEnabled(relSelected && flowSelected);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        reliabilityChBox = new javax.swing.JCheckBox();
        orderedChBox = new javax.swing.JCheckBox();
        flowControlChBox = new javax.swing.JCheckBox();
        maxBufLabel = new javax.swing.JLabel();
        maxBufTextField = new javax.swing.JTextField();
        inactivityLabel = new javax.swing.JLabel();
        inactivityTextField = new javax.swing.JTextField();

        reliabilityChBox.setText(org.openide.util.NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_reliableChBox")); // NOI18N
        reliabilityChBox.setToolTipText(org.openide.util.NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_reliableChBox_Tooltip")); // NOI18N
        reliabilityChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        reliabilityChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        reliabilityChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reliabilityChBoxActionPerformed(evt);
            }
        });

        orderedChBox.setText(NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_ordered"));
        orderedChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        orderedChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        orderedChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                orderedChBoxActionPerformed(evt);
            }
        });

        flowControlChBox.setText(NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_flowControl"));
        flowControlChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        flowControlChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        flowControlChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                flowControlChBoxActionPerformed(evt);
            }
        });

        maxBufLabel.setText(NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_maxBuffer"));

        maxBufTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                maxBufTextFieldActionPerformed(evt);
            }
        });

        inactivityLabel.setText(NbBundle.getMessage(ReliabilityPanel.class, "LBL_Section_Reliability_inactivity"));

        inactivityTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inactivityTextFieldActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(maxBufLabel)
                    .add(inactivityLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, maxBufTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 58, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, inactivityTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 58, Short.MAX_VALUE))
                .addContainerGap(208, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(10, 10, 10)
                .add(flowControlChBox)
                .addContainerGap(253, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(10, 10, 10)
                .add(orderedChBox)
                .addContainerGap(253, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(10, 10, 10)
                .add(reliabilityChBox)
                .addContainerGap(229, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {inactivityTextField, maxBufTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(reliabilityChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(orderedChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(flowControlChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(maxBufLabel)
                    .add(maxBufTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inactivityLabel)
                    .add(inactivityTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void orderedChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_orderedChBoxActionPerformed
        enableDisable();
    }//GEN-LAST:event_orderedChBoxActionPerformed

    private void flowControlChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_flowControlChBoxActionPerformed
        enableDisable();
    }//GEN-LAST:event_flowControlChBoxActionPerformed

    private void reliabilityChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reliabilityChBoxActionPerformed
        enableDisable();
    }//GEN-LAST:event_reliabilityChBoxActionPerformed

    private void inactivityTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inactivityTextFieldActionPerformed

    }//GEN-LAST:event_inactivityTextFieldActionPerformed

    private void maxBufTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_maxBufTextFieldActionPerformed

    }//GEN-LAST:event_maxBufTextFieldActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox flowControlChBox;
    private javax.swing.JLabel inactivityLabel;
    private javax.swing.JTextField inactivityTextField;
    private javax.swing.JLabel maxBufLabel;
    private javax.swing.JTextField maxBufTextField;
    private javax.swing.JCheckBox orderedChBox;
    private javax.swing.JCheckBox reliabilityChBox;
    // End of variables declaration//GEN-END:variables
    
}
