/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.wsitconf.ui.messaging;

import org.netbeans.modules.websvc.wsitconf.ui.messaging.nodes.MTOMNode;
import org.netbeans.modules.websvc.wsitconf.ui.messaging.nodes.ReliabilityNode;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ui.*;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

import java.util.Collection;
import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.BindingContainerServiceNode;

/**
 * @author Martin Grebac
 */
public class MessagingServiceView extends SectionView {

    static final String MTOM_NODE = "mtom";                     //NOI18N
    static final String TRANSACTIONS_NODE = "transactions";     //NOI18N
    static final String RELIABILITY_NODE = "reliability";       //NOI18N
    
    private SectionNode rootNode;
    
    private static final int REFRESH_DELAY = 40;
    
    public static final String ICON_BASE_DD_VALID =
            "org/netbeans/modules/websvc/wsdl/multiview/resources/DDValidIcon"; // NOI18N
        
    private WSDLModel model;
        
    MessagingServiceView(InnerPanelFactory factory, WSDLModel model) {
    
        super(factory);
        this.model = model;
        
        //create root node
        Children rootChildren = new Children.Array();
        Node root = new AbstractNode(rootChildren);
        
        //add binding section
        Collection<Binding> bindings = model.getDefinitions().getBindings();
        Node[] bindingNodes = new Node[bindings.size()];
        int i = 0;
        boolean first = true;
        for (Binding binding : bindings) {
            // main node container for a specific binding
            Children bindingChildren = new Children.Array();
            Node bindingNodeContainer = new BindingContainerServiceNode(bindingChildren);
            SectionContainer bindingCont = new SectionContainer(this, 
                    bindingNodeContainer, binding.getName() + " Binding");      //NOI18N

            Node mtomNode = new MTOMNode(this, binding);
            Node reliabilityNode = new ReliabilityNode(this, binding);            
            Node[] nodes = new Node[] { mtomNode, /*transactionsNode, */reliabilityNode };

            bindingChildren.add(nodes);

            SectionPanel mtomPanel = new SectionPanel(this, mtomNode, 
                    MTOM_NODE + binding.getName());
            SectionPanel reliabilityPanel = new SectionPanel(this, reliabilityNode, 
                    RELIABILITY_NODE + binding.getName());

            bindingCont.addSection(mtomPanel, false);
            bindingCont.addSection(reliabilityPanel, false);

            addSection(bindingCont, false);

            bindingNodes[i++] = bindingNodeContainer;
        }
        
        rootChildren.add(bindingNodes);
        setRoot(root);
    }

    private final RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable() {
        public void run() {
            getRootNode().refreshSubtree();
        }
    });

    public void refreshView() {
        rootNode.refreshSubtree();
    }
    
    public void scheduleRefreshView() {
        refreshTask.schedule(REFRESH_DELAY);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        rootNode.dataModelPropertyChange(source, propertyName, oldValue, newValue);
    }
    
    public SectionNode getRootNode() {
        return rootNode;
    }    
    
}
