/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.messaging;

import org.netbeans.modules.websvc.core.wseditor.spi.SaveSetter;
import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;

/**
 *
 * @author Martin Grebac
 */
public class MessagingServicePanelFactory implements org.netbeans.modules.xml.multiview.ui.InnerPanelFactory {
    
    private ToolBarDesignEditor editor;
    private WSDLModel model;
    private boolean isFromJava;
    private Node node;
    
    /**
     * Creates a new instance of MessagingServicePanelFactory
     */
    MessagingServicePanelFactory(ToolBarDesignEditor editor, WSDLModel model, Node node) {
        this.editor=editor;
        this.model = model;
        this.node = node;
        this.isFromJava = false;
    }

    /**
     * Creates a new instance of MessagingServicePanelFactory
     */
    MessagingServicePanelFactory(ToolBarDesignEditor editor, Node node) {
        this.editor=editor;
        this.node = node;
        this.isFromJava = true;
    }
    
    public SectionInnerPanel createInnerPanel(Object key) {
        if (key instanceof String) {
            String id = (String)key;

            if (id.startsWith(MessagingServiceView.MTOM_NODE)) {
                Binding b = Utilities.getBinding(model, id.substring(MessagingServiceView.MTOM_NODE.length()));
                return new MTOMPanel((SectionView) editor.getContentView(), model, node, b);
            }
//            if (id.startsWith(MessagingServiceView.TRANSACTIONS_NODE)) {
//                Binding b = Utilities.getBinding(model, id.substring(MessagingServiceView.TRANSACTIONS_NODE.length()));
//                return new TransactionsPanel((SectionView) editor.getContentView(), setter, model, node, b);
//            }
            if (id.startsWith(MessagingServiceView.RELIABILITY_NODE)) {
                Binding b = Utilities.getBinding(model, id.substring(MessagingServiceView.RELIABILITY_NODE.length()));
                return new ReliabilityPanel((SectionView) editor.getContentView(), model, node, b);
            }
        }
        return null;
    }
}
