/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.messaging;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.MtomModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class MTOMPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    boolean inSync = false;
    
    public MTOMPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();
        mtomChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        addImmediateModifier(mtomChBox);

        sync();
    }

    private void sync() {
        inSync = true;
        setMtom(MtomModelHelper.isMtomEnabled(binding, model));
        inSync = false;
    }

    public void setValue(javax.swing.JComponent source, Object value) {
        if (source.equals(mtomChBox)) {
            if (mtomChBox.isSelected()) {
                if (!(MtomModelHelper.isMtomEnabled(binding, model))) {
                    MtomModelHelper.enableMtom(binding, model);
                }
            } else {
                if (MtomModelHelper.isMtomEnabled(binding, model)) {
                    MtomModelHelper.disableMtom(binding, model);
                }
            }
            return;
        }
    }
    
    // mtom
    private void setMtom(Boolean enable) {
        if (enable == null) {
            this.mtomChBox.setSelected(false);
        } else {
            this.mtomChBox.setSelected(enable);
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) { }

    public void rollbackValue(javax.swing.text.JTextComponent source) { }
    
    protected void endUIChange() { }

    public void linkButtonPressed(Object ddBean, String ddProperty) {  }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        mtomChBox = new javax.swing.JCheckBox();

        mtomChBox.setText(NbBundle.getMessage(MTOMPanel.class, "LBL_Section_MTOM_mtom"));
        mtomChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mtomChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(mtomChBox))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(mtomChBox)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox mtomChBox;
    // End of variables declaration//GEN-END:variables
    
}
