/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf;

import java.io.IOException;
import java.net.MalformedURLException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.ui.security.WSITSecurityServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.security.client.WSITSecurityClientTopComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class WSITSecurityEditor extends WSITEditor implements WSEditor {
    
    /**
     * Creates a new instance of WSITSecurityEditor
     */
    public WSITSecurityEditor() {
    }

    public String getTitle() {
        return NbBundle.getMessage(WSITMessagingEditor.class, "SECURITY_EDITOR_TITLE"); //NOI18N
    }

    public JComponent createWSEditorComponent(Node node, JaxWsModel jaxWsModel) {
        
        WSDLModel wsdlModel;
        
        //is it a client node?
        Client client = (Client)node.getLookup().lookup(Client.class);
        //is it a service node?
        Service service = (Service)node.getLookup().lookup(Service.class);
        
        Project p = null;
        if (jaxWsModel != null) {
            p = FileOwnerQuery.getOwner(jaxWsModel.getJaxWsFile());
        }
        
        boolean wsitSupported = false;
        if (client != null){ //its a client
            if (p != null) {
                JAXWSClientSupport wscs = JAXWSClientSupport.getJaxWsClientSupport(p.getProjectDirectory());
                if (wscs != null) {
                    wsitSupported = isWsitSupported(p);
                    if (wsitSupported) {
                        try {
                            wsdlModel = getModel(node, jaxWsModel);
                            return new WSITSecurityClientTopComponent(client, jaxWsModel, wsdlModel, node);
                        } catch(Exception e){
                            ErrorManager.getDefault().notify(e);
                            return null;
                        }
                    }
                }
            }
        } else {
            if (p != null) {
                JAXWSSupport wss = JAXWSSupport.getJAXWSSupport(p.getProjectDirectory());
                if (wss != null) {
                    wsitSupported = isWsitSupported(p);
                    if (wsitSupported) {
                        try {
                            wsdlModel = getModel(node, jaxWsModel);
                            return new WSITSecurityServiceTopComponent(service, jaxWsModel, wsdlModel, node);
                        } catch(Exception e){
                            ErrorManager.getDefault().notify(e);
                            return null;
                        }
                    }
                }
            }
        }
        return null;
    }

    public void save(Node node, JaxWsModel jaxWsModel) {
        try {
            WSDLModel model = getModel(node, jaxWsModel);
            FileObject wsdlFO = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
            if (wsdlFO == null) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Cannot find fileobject in lookup for: " + model.getModelSource());
            }
            DataObject wsdlDO = DataObject.find(wsdlFO);
            if ((wsdlDO != null) && (wsdlDO.isModified())) {
                SaveCookie wsdlSaveCookie = (SaveCookie)wsdlDO.getCookie(SaveCookie.class);
                if(wsdlSaveCookie != null){
                    wsdlSaveCookie.save();
                }
                wsdlDO.setModified(false);
            }
        } catch (Exception e){
            ErrorManager.getDefault().notify(e);
        }
    }

    public void cancel(Node node, JaxWsModel jaxWsModel) {
        WSDLModel model = null;
        try {
            model = getModel(node, jaxWsModel);
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        if (model != null) {
            try {
                if (undoManager != null) {
                    while (undoManager.canUndo()) {
                        undoManager.undo();
                    }            
                }
            } catch (Exception e){
                ErrorManager.getDefault().notify(e);
            }
            FileObject fo = org.netbeans.modules.xml.retriever.catalog.Utilities.getFileObject(model.getModelSource());
            DataObject dO = null;
            try {
                dO = DataObject.find(fo);
            } catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify(ex);
            }
            if (dO != null) {
                try {
                    model.sync();
                } catch (IOException ex) {
                    ErrorManager.getDefault().notify(ex);
                }
                dO.setModified(false);
            }
        }
    }

}
