/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.ui.messaging.WSITMessagingServiceTopComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class WSITMessagingEditor extends WSITEditor implements WSEditor {
    
    /**
     * Creates a new instance of CustomizationWSEditorProvider
     */
    public WSITMessagingEditor() {
    }

    public String getTitle() {
        return NbBundle.getMessage(WSITMessagingEditor.class, "MESSAGING_EDITOR_TITLE");  //NOI18N
    }

    public JComponent createWSEditorComponent(Node node, JaxWsModel jaxWsModel) {
        
        //is it a client node?
        Client client = (Client)node.getLookup().lookup(Client.class);
        //is it a service node?
        Service service = (Service)node.getLookup().lookup(Service.class);
        
        Project p = null;
        if (jaxWsModel != null) {
            p = FileOwnerQuery.getOwner(jaxWsModel.getJaxWsFile());
        }
        
        boolean wsitSupported = false;
        if (client != null){ //its a client
            return null;
        } else {
            if (p != null) {
                JAXWSSupport wss = JAXWSSupport.getJAXWSSupport(p.getProjectDirectory());
                if (wss != null) {
                    wsitSupported = isWsitSupported(p);
                }
            }
            if (wsitSupported) {
                try {
                    WSDLModel wsdlModel = getModel(node, jaxWsModel);
                    return new WSITMessagingServiceTopComponent(service, jaxWsModel, wsdlModel, node);
                } catch(Exception e){
                    ErrorManager.getDefault().notify(e);
                    return null;
                }
            } else { 
                return null;
            }
        }
    }
    
    public void save(Node node, JaxWsModel jaxWsModel) {
        // Don't save here - security panel takes care of saving
    }

    public void cancel(Node node, JaxWsModel jaxWsModel) {
        // Nothing to do        
    }

}
