/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.PolicyReference;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

import java.util.List;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;

/**
 *
 * @author Martin Grebac
 */
public class Utilities {

    public static final String HTTP = "http:"; //NOI18N
    public static final String HTTPS = "https:"; //NOI18N
    
    /* Returns name of policy attached to a wsdl component */
    public static String getPolicyUriForElement(WSDLComponent c) {
        List<PolicyReference> extPRefElems = c.getExtensibilityElements(PolicyReference.class);
        if ((extPRefElems != null) && (extPRefElems.size() > 0)) {
            PolicyReference pref = extPRefElems.get(0);
            String policyURI = pref.getPolicyURI();
            return policyURI;
        }
        return null;
    }

    /* Returns policy attached to binding */
    public static Policy getPolicyForPolicyUri(String policyURI, Definitions d) {
        String uri = policyURI;
        if ((policyURI != null) && (policyURI.startsWith("#"))) {   //NOI18N
            policyURI = policyURI.substring(1);
        }
        List<Policy> extPElems = d.getExtensibilityElements(Policy.class);
        for (Policy p : extPElems) {
            String id = p.getID();
            if (policyURI.equals(id)) {
                return p;
            }
        }
        return null;
    }

    /* Returns name of policy attached to binding a component */
    public static Policy getPolicyForElement(WSDLComponent c, WSDLModel model) {
        if (model != null) {
            String policyUri = getPolicyUriForElement(c);
            Definitions d = model.getDefinitions();
            if ((d != null) && (policyUri != null)) {
                Policy p = getPolicyForPolicyUri(policyUri, d);
                return p;
            }
        }
        return null;
    }

    public static void removePolicyForElement(WSDLComponent c) {
        WSDLModel model = c.getModel();
        if (model != null) {
            String policyUri = getPolicyUriForElement(c);
            Definitions d = model.getDefinitions();
            
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            
            if ((d != null) && (policyUri != null)) {
                Policy p = getPolicyForPolicyUri(policyUri, d);
                p.getParent().removeExtensibilityElement(p);
                
                List<PolicyReference> extPRefElems = c.getExtensibilityElements(PolicyReference.class);
                if ((extPRefElems != null) && (extPRefElems.size() > 0)) {
                    PolicyReference pref = extPRefElems.get(0);
                    pref.getParent().removeExtensibilityElement(pref);
                }
            }

                if (!isTransaction) {
                    model.endTransaction();
                }
        }
    }
    
    public static Binding getBinding(WSDLModel model, String bindingName) {
        return model.findComponentByName(bindingName, Binding.class);
    }
    
    public static Service getService(WSDLModel model, String serviceName) {
        return model.findComponentByName(serviceName, Service.class);
    }

    public static Port getPortForBinding(Binding b) {
        Definitions d = (Definitions) b.getParent();
        Collection<Service> c = d.getServices();
        Iterator<Service> is = c.iterator();
        while (is.hasNext()) {
            Service s = is.next();
            Collection<Port> cp = s.getPorts();
            Iterator<Port> ip = cp.iterator();
            while (ip.hasNext()) {
                Port p = ip.next();
                QName bindingQname = p.getBinding().getQName();
                if (b.getName().equals(bindingQname.getLocalPart())) {
                    return p;
                }
            }
        }
        return null;
    }
    
    public static String getWsdlAddress(Port p) {
        if (p != null) {
            List<SOAPAddress> addresses = p.getExtensibilityElements(SOAPAddress.class);
            if ((addresses != null) && !(addresses.isEmpty())) {
                return addresses.get(0).getLocation();
            }
        }
        return null;
    }

    public static void setWsdlAddress(Port p, String newAddress) {
        if (p != null) {
            List<SOAPAddress> addresses = p.getExtensibilityElements(SOAPAddress.class);
            if ((addresses != null) && !(addresses.isEmpty())) {
                SOAPAddress address = addresses.get(0);
                WSDLModel model = p.getModel();
                boolean isTransaction = model.isIntransaction();
                if (!isTransaction) {
                    model.startTransaction();
                }
                address.setLocation(newAddress);
                    if (!isTransaction) {
                        model.endTransaction();
                    }
            }
        }
    }
    
    /* Used to validate number inputs
     */
    public static boolean isPositiveNumber(String s, boolean zeroAllowed, boolean allowEmptyValue) {
        Integer i = null;
        if ((s == null) || ("".equals(s))) {
            return allowEmptyValue ? true : false;
        }
        try {
            i = Integer.parseInt(s);
            if (i != null) {
                if (zeroAllowed) {
                    return i.intValue() >= 0;
                } else {
                    return i.intValue() > 0;
                }
            }
        } catch (NumberFormatException nfe) {}
        return false;
    }

}
