/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.dev.wizard;


import java.awt.Component;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.openide.*;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.util.HelpCtx;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.templates.support.Templates;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JCheckBox;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import org.openide.util.NbBundle;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.Insets;
import java.io.File;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.FileObject;

import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;


/**
 *
 * @author  rico
 * Currently, this is the wizard descriptor for the panel below the
 * TargetChooser.
 */
public class WebServiceWizardDescriptor implements WizardDescriptor.FinishablePanel {
    /*
     * Wizard descriptor of the main wizard
     */
    private WizardDescriptor wizardDescriptor;
    private WebServiceWizardPanel panel;
    private WebServiceWizardHelper helper;
    private ChangeListener listener;
    private static String previousDirectory = "";

    // !PW IZ 54686 Need to dig into TargetChooserGUI panel to retrieve current
    // target name for additional validation.
    //
    // (I propose change this to not use TargetChooser UI or expand TargetChooser
    // API to allow retrieving the current target name to get rid of this hack)
    private JTextField nameField;
    private Project namespaceProject;
    private java.util.Map webServiceNamespace;
    
    private WizardDescriptor.Panel firstPanel;
    
    /** Creates a new instance of WebServiceWizardDescriptor */
    public WebServiceWizardDescriptor(WizardDescriptor wizardDescriptor, WebServiceWizardHelper helper) {
        this.wizardDescriptor = wizardDescriptor;
        this.helper = helper;

        this.nameField = null;
        this.webServiceNamespace = null;
    }
    
    public void setTargetChooserPanel(WizardDescriptor.Panel panel) {
        this.firstPanel = panel;
    }
    
    public boolean isFinishPanel(){
        return false;
    }
    
    public void addChangeListener(ChangeListener l) {
        listener = l;
    }
    
    public void removeChangeListener(ChangeListener l) {
        if(listener == l) {
            listener = null;
        }
    }
    
    public Component getComponent() {
        if(panel == null){
            panel = new WebServiceWizardPanel(helper);
        }
        return panel;
    }
    
    public HelpCtx getHelp() {
        return new HelpCtx(WebServiceWizardDescriptor.class);
    }

    private String validateWebServiceName(String name, java.util.Map namespace) {
        String message = null;

        if(name == null || name.length() == 0) {
            // !PW target chooser gui forces null message for this case before we
            // can check so this case actually doesn't do anything :(
            message = NbBundle.getMessage(WebServiceWizardDescriptor.class, "MSG_EnterWebServiceName"); // NOI18N
        } else if(namespace.containsKey(name)) {
            String messageId = (String) namespace.get(name);
            String servletName = "WSServlet_" + name; // NOI18N
            message = NbBundle.getMessage(WebServiceWizardDescriptor.class, messageId, name, servletName);
        }
        
        return message;
    }
    
    private java.util.Map getWSNameSpace(Project p) {
        long start = System.currentTimeMillis();
        java.util.Map namespace = new java.util.HashMap();
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(p.getProjectDirectory());

        // First add existing web service names.
        if(wsSupport != null) {
            org.netbeans.modules.j2ee.dd.api.webservices.DDProvider wsDDProvider =
                org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault();
            try {
                Webservices webServices = wsDDProvider.getDDRoot(wsSupport.getWebservicesDD());
                if(webServices != null) {
                    WebserviceDescription [] descriptions = webServices.getWebserviceDescription();
                    if(descriptions != null) {
                        for(int i = 0; i < descriptions.length; i++) {
                            String wsname = descriptions[i].getWebserviceDescriptionName();
                            if(wsname != null && wsname.length() > 0) {
                                namespace.put(wsname, "ERR_WebServiceExists"); // NOI18N
                            }
                        }
                    }
                }
            } catch(java.io.IOException ex) {
                // Nonexistent or invalid webservices.xml -- ignore.
            }

            // !PW FIXME if we enable this wizard for any freeform project types,
            // the code that retrieves the deployment descriptor files will need updating.
            
            // This code was supposed to use DDProvider to extract a root interface
            // introspect the type, but it turns out that one needs the correct kind
            // of DDProvider in order to read the file properly.  We should resolve
            // this in DDAPI in 5.0 by pushing DDProvider into common.
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider) p.getLookup ().lookup (J2eeModuleProvider.class);
            Object moduleType = j2eeModuleProvider.getJ2eeModule().getModuleType();
            if(J2eeModule.WAR.equals(moduleType)) {
                FileObject ddFO = org.netbeans.modules.web.api.webmodule.WebModule.getWebModule(p.getProjectDirectory()).getDeploymentDescriptor();
                if(ddFO != null) {
                    try {
                        WebApp webApp = org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(ddFO);
                        Servlet [] servlets = webApp.getServlet();
                        if(servlets != null) {
                            for(int i = 0; i < servlets.length; i++) {
                                // The servlet created by the new web service wizard has it's name prefixed with WSServlet_
                                // so we need to check against only the roots of servlet names with that prefix.
                                String servletName = servlets[i].getServletName();
                                if(servletName != null && servletName.length() > 10 && servletName.startsWith("WSServlet_")) { // NOI81N
                                    String wsRootName = servletName.substring(10);
                                    if(!namespace.containsKey(wsRootName)) {
                                        namespace.put(wsRootName, "ERR_WS_ServletExists"); // NOI18N
                                    }
                                }
                            }
                        }
                    } catch(java.io.IOException ex) {
                        // Nonexistent or invalid deployment descriptor file - ignore.
                    }
                }
            } else if(J2eeModule.EJB.equals(moduleType)) {
                org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbjarModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar(p.getProjectDirectory());
//                if(ddFO != null) {
                    try {
                        EjbJar ejbJar = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(ejbjarModule.getMetadataUnit());

                        EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
                        if(eb != null) {
                            Ejb [] ejbs = eb.getEjbs();
                            if(ejbs != null) {
                                for(int i = 0; i < ejbs.length; i++) {
                                    // Unlike servlets, the generated ejb name is 
                                    // the same as the web service name.
                                    String ejbName = ejbs[i].getEjbName();
                                    if(ejbName != null && ejbName.length() > 0 && !namespace.containsKey(ejbName)) {
                                        namespace.put(ejbName, "ERR_WS_EjbExists"); // NOI18N
                                    }
                                }
                            }
                        }
                    } catch(java.io.IOException ex) {
                        // Nonexistent or invalid deployment descriptor file - ignore.
                    }
//                }
            }
        }
        
        return namespace;
    }
    
    private static JComboBox findCombo(JComponent comp) {
        Vector allComponents = new Vector();
        Util.getAllComponents(comp.getComponents(), allComponents);
        Iterator iterator = allComponents.iterator();
        while(iterator.hasNext()) {
            Component c = (Component)iterator.next();
            if(c instanceof JComboBox) {
                JComboBox combo = (JComboBox)c;
                if (combo.getSelectedItem() instanceof SourceGroup) {
                    return combo;
                }
            }
        }
        return null;
    }
    
    public boolean isValid() {
        Project p = Templates.getProject(wizardDescriptor);
                
        // Project must currently have a target server that supports wscompile.
        if(!isWsCompileSupported(p)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", NbBundle.getMessage(WebServiceWizardDescriptor.class, "ERR_WsCompileNotSupportedByTargetServer")); // NOI18N
            return false;
        }
        
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider) p.getLookup().lookup(J2eeModuleProvider.class);
        String j2eeVersion = j2eeModuleProvider.getJ2eeModule().getModuleVersion();
        Object moduleType = j2eeModuleProvider.getJ2eeModule().getModuleType();
        if ((J2eeModule.WAR.equals(moduleType) && !WebApp.VERSION_2_4.equals(j2eeVersion)) ||
        (J2eeModule.EJB.equals(moduleType) && !EjbJar.VERSION_2_1.equals(j2eeVersion)))  {
            wizardDescriptor.putProperty("WizardPanel_errorMessage",  // NOI18N
            NbBundle.getMessage(WebServiceWizardDescriptor.class, "ERR_ProjectDoesNotSupportJ2EE14")); // NOI18N
            return false;
        }

        // this is a hack for target chooser panel
        if (firstPanel != null) {
            JComponent targetChooserGUI = (JComponent)firstPanel.getComponent();
            if (targetChooserGUI != null) {
                JComboBox rootFolderCombo = findCombo(targetChooserGUI);
                if (rootFolderCombo != null) {
                   if (rootFolderCombo.isVisible()) {
                        FileObject fo = ((SourceGroup) rootFolderCombo.getSelectedItem()).getRootFolder();
                        if (fo != null) {
                            WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(fo);
                            if (wsSupport == null) {
                                String msg = NbBundle.getMessage(WebServiceWizard.class, "ERR_NoTargetFolder"); //NOI18N
                                wizardDescriptor.putProperty("WizardPanel_errorMessage", msg); //NOI18N
                                return false;
                            }
                        }
                   } else {
                        String msg = NbBundle.getMessage(WebServiceWizard.class, "ERR_NoTargetFolder"); //NOI18N
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", msg); //NOI18N
                        return false;
                   }
                }
            }
        }
        
        if (panel != null) {
            // IZ 54686 validate the service name, if we know what field it's in.
            if(nameField != null) {
                String wsname = nameField.getText().trim();
                if(webServiceNamespace == null || namespaceProject != p) {
                    webServiceNamespace = getWSNameSpace(p);
                    namespaceProject = p;
                }
                String message = validateWebServiceName(wsname, webServiceNamespace);
                if(message != null) { // name is invalid, message is the display text
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", message); // NOI18N
                    return false; // web service name is invalid
                }
            }
            
            if(panel.getFromWSDLButton().isSelected()) {
                String wsdlFilePath = panel.getWSDLFilePath().trim();
                
                if(wsdlFilePath == null || wsdlFilePath.length() == 0) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage",  // NOI18N
                    NbBundle.getMessage(WebServiceWizardDescriptor.class, "MSG_EnterWsdlName")); // NOI18N
                    return false; // unspecified WSDL file
                }
                
                File f = new File(wsdlFilePath);
                String wsdlFileText = f.getAbsolutePath();
                f = getCanonicalFile(f);
                if(f == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage",  // NOI18N
                    NbBundle.getMessage(WebServiceWizardDescriptor.class, "ERR_WsdlInvalid")); // NOI18N
                    return false; // invalid WSDL file
                }
                
                if(!f.exists()) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage",  // NOI18N
                    NbBundle.getMessage(WebServiceWizardDescriptor.class, "ERR_WsdlDoesNotExist")); // NOI18N
                    return false; // invalid WSDL file
                }
            }
            else if(panel.getFromWSDLUrlButton().isSelected()) {
                String wsdlUrl = panel.getWSDLUrl().trim();
                if(wsdlUrl == null || wsdlUrl.length() == 0) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage",  // NOI18N
                    NbBundle.getMessage(WebServiceWizardDescriptor.class, "MSG_EnterWsdlUrl")); // NOI18N
                    return false; // unspecified WSDL file
                }
            }
        }
        
        return true;
    }
    
    private boolean isWsCompileSupported(Project p) {
        // Determine if wscompile is supported by the current target server of
        // this project.  Default to true so that the user can still continue, if on
        // their own, in case we have difficulty getting the correct answer.
        boolean result = true;

        J2eeModuleProvider provider = (J2eeModuleProvider) p.getLookup().lookup(J2eeModuleProvider.class);
        if(provider != null) {
            String serverInstanceID = provider.getServerInstanceID();
            if(serverInstanceID != null && serverInstanceID.length() > 0) {
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
                if ((j2eePlatform == null) || (!j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSCOMPILE))) {
                    result = false;
                }
            }
        }

        return result;
    }
    
    /** Retrieve the canonical version of a File instance, converting the possible
     *  IOException into a null (presumably for error presentation purposes).
     *  Copied from Utilities in core.
     *  FIX-ME: removet this when proper dependencies have been set up
     */
    public static File getCanonicalFile(File f) {
        File f1;
        try {
            f1 = f.getCanonicalFile();
        } catch (java.io.IOException e) {
            f1 = null;
        }
        return f1;
    }


    public void readSettings(Object settings) {
        if(settings instanceof WizardDescriptor) {
            panel.readSettings((WizardDescriptor) settings);
            
            Project p = Templates.getProject((WizardDescriptor) settings);
            if(p != null) {
                if(namespaceProject != p) {
                    webServiceNamespace = getWSNameSpace(p);
                    namespaceProject = p;
                }
            } else {
                webServiceNamespace = null;
                namespaceProject = null;
            }
        }
    }

    public void storeSettings(Object settings) {
        WebServiceWizardHelper helper = panel.getWizardHelper();
        
        //FIX-ME: Will this ever happen?
        if(settings instanceof WebServiceWizardHelper) {
            helper = (WebServiceWizardHelper)settings;
        }
        
        if(helper != null) {
            if(panel.isFromScratch()) {
                helper.setCreateFrom(WebServiceWizardHelper.CREATE_FROM_SCRATCH);
            }
            else if(panel.isFromExistingCode()) {
                helper.setCreateFrom(WebServiceWizardHelper.CREATE_FROM_EXISTING_CODE);
            }
            else if(panel.isFromWSDL()) {
                helper.setCreateFrom(WebServiceWizardHelper.CREATE_FROM_WSDL_FILE);
            }
            else if(panel.isFromWSDLUrl()) {
                helper.setCreateFrom(WebServiceWizardHelper.CREATE_FROM_WSDL_URL);
            }
        }
        
        if(settings instanceof WizardDescriptor) {
            panel.storeSettings((WizardDescriptor)settings);
        }
    }
    
    class WebServiceWizardPanel extends JPanel implements DocumentListener{
        WebServiceWizardHelper helper;
        private  final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
        
        public WebServiceWizardPanel(WebServiceWizardHelper helper) {
            this.helper = helper;
            initComponents();
            addListeners();
        }
        
        private void initComponents() {
            java.awt.GridBagConstraints gridBagConstraints;
            
            typeButtons = new ButtonGroup();
            
            fromScratchButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromScratch")); // NOI18N
            fromScratchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromScratch"));
            fromScratchButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromScratch_mnem").charAt(0));

            fromWSDLButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromWSDL")); // NOI18N
            fromWSDLButton.getAccessibleContext().setAccessibleDescription(fromWSDLButton.getText());
            fromWSDLButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromWSDL_mnem").charAt(0));
            
            fromWSDLUrlButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromWSDLUrl")); // NOI18N
            fromWSDLUrlButton.getAccessibleContext().setAccessibleDescription(fromWSDLUrlButton.getText());
            fromWSDLUrlButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromWSDLUrl_mnem").charAt(0));
            
            fromExistingCodeButton = new JCheckBox(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromExistingCode")); // NOI18N
            fromExistingCodeButton.getAccessibleContext().setAccessibleDescription(fromExistingCodeButton.getText());
            fromExistingCodeButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_FromExistingCode_mnem").charAt(0));
                    
            wsdlFileTextField = new JTextField();
            wsdlFileTextField.getDocument().addDocumentListener(this);
            wsdlFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, "A11Y_WSDL_TF"));
            
            browseButton = new JButton(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_Browse")); // NOI18N
            browseButton.getAccessibleContext().setAccessibleDescription(browseButton.getText());
            browseButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_Browse_mnem").charAt(0));
            
            urlLabel = new JLabel(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_UrlLabel")); // NOI18N
            urlLabel.setDisplayedMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_UrlLabel_mnem").charAt(0));
            
            urlTextField = new JTextField();
            urlLabel.setLabelFor(urlTextField);
            urlTextField.getDocument().addDocumentListener(this);
            urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, "A11Y_WSDL_URL_TF"));
            
            setLayout(new GridBagLayout());
            setBorder(new TitledBorder(NbBundle.getMessage(WebServiceWizardPanel.class, "LBL_WebService_Type"))); // NOI18N
            
            typeButtons.add(fromScratchButton);
            typeButtons.add(fromWSDLButton);
            typeButtons.add(fromWSDLUrlButton);
            fromScratchButton.setSelected(true);
            browseButton.setEnabled(false);
            urlTextField.setEnabled(false);
            wsdlFileTextField.setEnabled(false);
            
            wsdlFilePanel = new JPanel();
            wsdlFilePanel.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            wsdlFilePanel.add(wsdlFileTextField, gridBagConstraints);
            
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 24);
            wsdlFilePanel.add(browseButton, gridBagConstraints);
            
            urlPanel = new JPanel();
            urlPanel.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            urlPanel.add(urlLabel, gridBagConstraints);
            
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            urlPanel.add(urlTextField, gridBagConstraints);
            
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            add(fromScratchButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 2.0;
            add(fromExistingCodeButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            add(fromWSDLButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 24);
            add(wsdlFilePanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            add(fromWSDLUrlButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 50);
            add(urlPanel, gridBagConstraints);
            
        }

        public void addNotify() {
            super.addNotify();

            // !PW Part of namefield locator hack for IZ 54686
            nameField = null;
            java.awt.Container holderPanel = getParent();
            if(holderPanel != null) {
                java.awt.Container guiPanel = holderPanel.getParent();
                if(guiPanel != null) {
                    nameField = getFirstTextField(guiPanel);
                }
            }
            
            // if nameField is still null here, then we couldn't find the namefield
            // correctly.  Later validation attempts should do nothing in this case.
        }
        
        private JTextField getFirstTextField(java.awt.Container top) {
            // Depth first search from top for the first component that is a
            // JTextField -- this one should be the target name field.
            JTextField result = null;
            java.awt.Component[] components = top.getComponents();
            for(int i = 0; i < components.length && result == null; i++) {
                if(components[i] instanceof JTextField) {
                    result = (JTextField) components[i];
                } else if(components[i] instanceof java.awt.Container) {
                    result = getFirstTextField((java.awt.Container) components[i]);
                }
            }
            return result;
        }

        public JRadioButton getFromWSDLButton() {
            return fromWSDLButton;
        }
        
        public JRadioButton getFromWSDLUrlButton() {
            return fromWSDLUrlButton;
        }
        
        public boolean isFromScratch(){
            return fromScratchButton.isSelected() && !fromExistingCodeButton.isSelected();
        }
        
        public boolean isFromWSDL(){
            return fromWSDLButton.isSelected();
        }
        
        public boolean isFromWSDLUrl() {
            return fromWSDLUrlButton.isSelected();
        }
        
        public boolean isFromExistingCode(){
            return fromScratchButton.isSelected() && fromExistingCodeButton.isSelected();
        }
        
        
        public WebServiceWizardHelper getWizardHelper() {
            return helper;
        }
        
        private void addListeners() {
            final WebServiceWizard wiz = helper.getWizard();
            fromScratchButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    if(!fromExistingCodeButton.isEnabled()) {
                        fromExistingCodeButton.setEnabled(true);
                    }
                    if(browseButton.isEnabled()){
                        browseButton.setEnabled(false);
                    }
                    if(wsdlFileTextField.isEnabled()){
                        wsdlFileTextField.setEnabled(false);
                    }
                    if(urlTextField.isEnabled()){
                        urlTextField.setEnabled(false);
                    }
                    if(!fromExistingCodeButton.isSelected()) {
                        wiz.setPanelsAndSteps(
                        WebServiceWizard.PATH_CREATE_FROM_SCRATCH);
                    }
                    else {
                        wiz.setPanelsAndSteps(
                        WebServiceWizard.PATH_CREATE_FROM_EXISTING_CODE);
                    }
                    
                    fireStateChanged();
                }
            });
            fromExistingCodeButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    if(fromExistingCodeButton.isSelected()) {
                        wiz.setPanelsAndSteps(
                        WebServiceWizard.PATH_CREATE_FROM_EXISTING_CODE);
                    }
                    else {
                        wiz.setPanelsAndSteps(
                        WebServiceWizard.PATH_CREATE_FROM_SCRATCH);
                    }
                    fireStateChanged();
                }
            });
            fromWSDLButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    if(!wsdlFileTextField.isEnabled()){
                        wsdlFileTextField.setEnabled(true);
                    }
                    if(!browseButton.isEnabled()){
                        browseButton.setEnabled(true);
                    }
                    if(urlTextField.isEnabled()){
                        urlTextField.setEnabled(false);
                    }
                    ((WebServiceWizard)(helper.getWizard())).setPanelsAndSteps(
                    WebServiceWizard.PATH_CREATE_FROM_WSDL_FILE);
                    if(fromExistingCodeButton.isSelected()) {
                        fromExistingCodeButton.setSelected(false);
                    }
                    fromExistingCodeButton.setEnabled(false);
                    fireStateChanged();
                }
            });
            fromWSDLUrlButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    ((WebServiceWizard)(helper.getWizard())).setPanelsAndSteps(
                    WebServiceWizard.PATH_CREATE_FROM_WSDL_URL);
                    if(!urlTextField.isEnabled()){
                        urlTextField.setEnabled(true);
                    }
                    if(fromExistingCodeButton.isSelected()) {
                        fromExistingCodeButton.setSelected(false);
                    }
                    fromExistingCodeButton.setEnabled(false);
                    if(browseButton.isEnabled()){
                        browseButton.setEnabled(false);
                    }
                    if(wsdlFileTextField.isEnabled()){
                        wsdlFileTextField.setEnabled(false);
                    }
                    fireStateChanged();
                }
            });
            browseButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser chooser = new JFileChooser(previousDirectory);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.addChoosableFileFilter(WSDL_FILE_FILTER);
                    chooser.setFileFilter(WSDL_FILE_FILTER);
                    
                    if(chooser.showOpenDialog(WebServiceWizardPanel.this) == JFileChooser.APPROVE_OPTION) {
                        File wsdlFile = chooser.getSelectedFile();
                        wsdlFileTextField.setText(wsdlFile.getAbsolutePath());
                        previousDirectory = wsdlFile.getPath();
                    }
                }
            });
            
        }
        
        public void changedUpdate(DocumentEvent e) {
            fireStateChanged();
        }
        
        public void insertUpdate(DocumentEvent e) {
            fireStateChanged();
        }
        
        public void removeUpdate(DocumentEvent e) {
            fireStateChanged();
        }
        
        
        public String getWSDLFilePath() {
            return wsdlFileTextField.getText();
        }
        
        public String getWSDLUrl() {
            return urlTextField.getText();
        }


        void readSettings(WizardDescriptor wizDescriptor) {
            // IZ 54686 - need to fire a state change to force initial validation
            // of name.
            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    fireStateChanged();
                }
            });
        }
        
        void storeSettings(WizardDescriptor wizDescriptor) {
            wizDescriptor.putProperty(WebServiceWizard.WSDL_FILE_PATH, wsdlFileTextField.getText().trim());
            wizDescriptor.putProperty(WebServiceWizard.WSDL_FILE_URL, urlTextField.getText().trim());
        }
        
        
        // Invoking this method causes the wizard framework (listener) to invoke
        // the isValid() method.
        private void fireStateChanged() {
            if (listener != null) {
                ChangeEvent evt = new ChangeEvent(this);
                listener.stateChanged(evt);
            }
        }
        
        private ButtonGroup typeButtons;
        private JRadioButton fromScratchButton;
        private JRadioButton fromWSDLButton;
        private JRadioButton fromWSDLUrlButton;
        private JCheckBox fromExistingCodeButton;
        private JPanel wsdlFilePanel;
        private JTextField wsdlFileTextField;
        private JButton browseButton;
        private JPanel urlPanel;
        private JLabel urlLabel;
        private JTextField urlTextField;
    }
    private static class WsdlFileFilter extends FileFilter {
        public boolean accept(File f) {
            boolean result;
            if(f.isDirectory() || "wsdl".equalsIgnoreCase(FileUtil.getExtension(f.getName()))) { // NOI18N
                result = true;
            } else {
                result = false;
            }
            return result;
        }
        
        public String getDescription() {
            return NbBundle.getMessage(WebServiceWizardDescriptor.class, "LBL_WsdlFilterDescription"); // NOI18N
        }
    }
}
