/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.dev.wizard;

import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.nodes.Children;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;

public class CreateWebServiceFromExistingCodePanel extends JPanel
implements WizardDescriptor.FinishablePanel, ExplorerManager.Provider, WebServiceWizard.HasWizardHelper {
    private ExplorerManager manager;
    private JPanel panel;
    private Node[] selectedNodes;
    private ChangeListener listener;
    private WebServiceWizardHelper helper;
    
    public CreateWebServiceFromExistingCodePanel(WebServiceWizardHelper helper) {
        this.helper = helper;
        initComponents();
        manager = new ExplorerManager();
        manager.addPropertyChangeListener(
        new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent pce) {
                selectedNodes = manager.getSelectedNodes();
                fireStateChange();
            }
        });
    }
    
    
    private void initComponents() {
        panel = new JPanel();
        setLayout(new BorderLayout());
        setPreferredSize(new Dimension(550, 440));
        panel.setLayout(new BorderLayout());
        add(panel, BorderLayout.CENTER);
        
        BeanTreeView btv = new BeanTreeView();
        btv.getAccessibleContext().
        setAccessibleName(NbBundle.getMessage(CreateWebServiceFromExistingCodePanel.class,
        "LBL_ExistingCode_Tree"));		//NOI18N
        btv.getAccessibleContext().setAccessibleDescription
        (NbBundle.getMessage(CreateWebServiceFromExistingCodePanel.class,
        "LBL_SelectExistingCode"));		//NOI18N
        
        panel.add(btv, "Center");   //NOI18N
        panel.validate();
        validate();
    }
    
    public ExplorerManager getExplorerManager() {
        return manager;
    }
    
    public void addChangeListener(ChangeListener l) {
        listener = l;
    }
    
    private void fireStateChange() {
        if (listener != null) {
            ChangeEvent evt = new ChangeEvent(this);
            listener.stateChanged(evt);
        }
    }
    
    public Component getComponent() {
        return this;
    }
    
    public HelpCtx getHelp() {
        return null;
    }
    
    public boolean isValid() {
        for(int i = 0; i < selectedNodes.length; i++) {
            Node node = selectedNodes[i];
            if (node.getCookie(EjbReference.class) == null) {
                return false;
            }            
            /*
            DataObject d = (DataObject)node.getCookie(DataObject.class);
            if (d!= null) {
                Resource res = JavaModel.getResource(d.getPrimaryFile());
                List classes = res.getClassifiers();
                TypeClass tc = JavaModel.getDefaultExtent().getType();
                JavaClass entityBeanInterface = (JavaClass)tc.resolve("javax.ejb.EntityBean");  //NOI18N
                JavaClass msgBeanInterface = (JavaClass)tc.resolve("javax.ejb.MessageDrivenBean"); //NOI18N
                JavaClass msgListenerInterface = (JavaClass)tc.resolve("javax.jms.MessageListener"); //NOI18N
                JavaClass localHomeInterface = (JavaClass)tc.resolve("javax.ejb.EJBLocalHome"); //NOI18N
                JavaClass homeInterface = (JavaClass)tc.resolve("javax.ejb.EJBHome"); //NOI18N
                JavaClass localInterface = (JavaClass)tc.resolve("javax.ejb.EJBLocalObject"); //NOI18N
                JavaClass remoteInterface = (JavaClass)tc.resolve("javax.ejb.EJBObject"); //NOI18N
                for (int c=0; c < classes.size(); c++) {
                    JavaClass jc = (JavaClass)classes.get(c);
                    if (jc.isSubTypeOf(entityBeanInterface) || 
                        jc.isSubTypeOf(msgBeanInterface) ||
                        jc.isSubTypeOf(msgListenerInterface) ||
                        jc.isSubTypeOf(localHomeInterface) ||
                        jc.isSubTypeOf(homeInterface) ||
                        jc.isSubTypeOf(localInterface) ||
                        jc.isSubTypeOf(remoteInterface)) {
                        return false;
                    }
                }
            }*/
        }
        return true;
    }
    
    public void readSettings(Object settings) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        List projectNodes = new LinkedList();
        for(int i = 0; i < allProjects.length; i++) {
            LogicalViewProvider lvp = (LogicalViewProvider)allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            if(lvp != null) {
                projectNodes.add(lvp.createLogicalView());
            }
        }
        Children.Array children = new Children.Array();
        children.add((Node[])projectNodes.toArray(new Node[projectNodes.size()]));
        Node root = new AbstractNode(children);
        root.setDisplayName(NbBundle.getMessage(CreateWebServiceFromExistingCodePanel.class, "LBL_Available_Projects"));
        manager.setRootContext(root);
    }
    
    public void removeChangeListener(ChangeListener l) {
        if (listener == l) {
            listener = null;
        }
    }
    
    public void storeSettings(Object settings) {
        helper.setExistingCodeNodes(selectedNodes);
    }
    
    public boolean isFinishPanel() {
        return true;
    }
    
    public void setWizardHelper(WebServiceWizardHelper h) {
        helper = h;
    }
}
