/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsdl.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

import org.openide.filesystems.FileObject;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.*;
import org.openide.util.NbBundle;

import org.netbeans.spi.project.ui.templates.support.Templates;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.SourceGroup;

/** A template wizard iterator (sequence of panels).
 * Used to fill in the second and subsequent panels in the New wizard.
 * Associate this to a template inside a layer using the
 * Sequence of Panels extra property.
 * Create one or more panels from template as needed too.
 *
 * @author  Milan Kuchtiak
 */
public class WsdlIterator implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 3020391475943498962L; 
    public static final java.awt.Dimension PREF_SIZE = new java.awt.Dimension(560,350);
    
    private WizardDescriptor.Panel folderPanel;
    private transient SourceGroup[] sourceGroups;
    //private static final long serialVersionUID = -7586964579556513549L;
    
    public WsdlIterator() {
    }
    
    // You should define what panels you want to use here:
    protected WizardDescriptor.Panel[] createPanels(Project project) {
        Sources sources = (Sources) project.getLookup().lookup(org.netbeans.api.project.Sources.class);
        sourceGroups = sources.getSourceGroups(Sources.TYPE_GENERIC);
        folderPanel=new WsdlPanel(project,sourceGroups);
        // creates simple wizard panel with bottom panel
        WizardDescriptor.Panel firstPanel = Templates.createSimpleTargetChooser(project,sourceGroups,folderPanel);
        JComponent c = (JComponent)firstPanel.getComponent();
        // the bottom panel should listen to changes on file name text field
        String fileNameLabel = NbBundle.getMessage(WsdlIterator.class,"LBL_SimpleTargetChooserPanel_FileName_Label");
        ((WsdlPanel)folderPanel).setNameTF((JTextField)Utilities.findTextFieldForLabel(c,fileNameLabel));
        
        return new WizardDescriptor.Panel[] {
            firstPanel
        };
    }
    
    public Set instantiate(TemplateWizard wiz) throws IOException/*, IllegalStateException*/ {
        // Here is the default plain behavior. Simply takes the selected
        // template (you need to have included the standard second panel
        // in createPanels(), or at least set the properties targetName and
        // targetFolder correctly), instantiates it in the provided
        // position, and returns the result.
        // More advanced wizards can create multiple objects from template
        // (return them all in the result of this method), populate file
        // contents on the fly, etc.
        
        final org.openide.filesystems.FileObject dir = Templates.getTargetFolder( wiz );
        DataFolder df = DataFolder.findFolder( dir );
        FileObject template = Templates.getTemplate( wiz );
        WsdlPanel panel = (WsdlPanel)folderPanel;
        boolean importSchemas=false;
        if (panel.isImport() && panel.getSchemas().length>0) {
            importSchemas=true;
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("WSDL_import","wsdl"); //NOI18N
        }
        DataObject dTemplate = DataObject.find( template );
        DataObject dobj = dTemplate.createFromTemplate( df, Templates.getTargetName( wiz )  );
        if (dobj!=null) {
            // Do something with the result, e.g. open it:
            
            EditCookie edit = (EditCookie) dobj.getCookie(EditCookie.class);
            if (edit != null) {
                EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
                editorCookie.openDocument();
                javax.swing.text.Document doc = editorCookie.getDocument();
                Utilities.replaceInDocument(doc,"#SERVICE_NAME",panel.getWsName()); //NOI18N
                String targetNamespace = panel.getNS();
                if (targetNamespace.length()==0) targetNamespace = DEFAULT_TARGET_NAMESPACE;
                Utilities.replaceInDocument(doc,"#TARGET_NAMESPACE",targetNamespace); //NOI18N
                if (importSchemas) {
                    WsdlUIPanel.SchemaInfo[] infos = panel.getSchemas();
                    StringBuffer typeNamespaces = new StringBuffer();
                    StringBuffer imports = new StringBuffer();
                    for (int i=0;i<infos.length;i++) {
                        if (i>0) {
                            typeNamespaces.append("    ");
                            imports.append("      ");
                        }
                        
                        String ns = infos[i].getNamespace();
                        if (ns.length()==0) ns = "urn:WS/types"+String.valueOf(i+1); //NOI18N
                        
                        typeNamespaces.append("xmlns:ns"+String.valueOf(i+1)+"=\""+ns+"\"\n"); //NOI18N
                        imports.append("<xsd:import "); //NOI18N
                        imports.append("namespace=\""+ns+"\" "); //NOI18N
                        String relativePath = null;
                        try{
                            relativePath = getRelativePathOfSchema(dobj, infos[i].getSchemaName());
                        }catch(URISyntaxException e){
                            relativePath= infos[i].getSchemaName();
                        }
                        //imports.append("schemaLocation=\""+infos[i].getSchemaName()+"\"/>\n"); //NOI18N
                        imports.append("schemaLocation=\""+relativePath+"\"/>\n"); //NOI18N
                    }
                    Utilities.replaceInDocument(doc,"#TYPE_NAMESPACES",typeNamespaces.toString()); //NOI18N
                    Utilities.replaceInDocument(doc,"#SCHEMA_IMPORTS",imports.toString()); //NOI18N
                    
                    for (int i=0;i<infos.length;i++) {
                        if (i>0) typeNamespaces.append("    ");
                        typeNamespaces.append("xmlns:ns"+String.valueOf(i+1)+"=\""+infos[i].getNamespace()+"\"\n"); //NOI18N
                    }
                    Utilities.replaceInDocument(doc,"#TYPE_NAMESPACES",typeNamespaces.toString()); //NOI18N
                }
                SaveCookie save = (SaveCookie)dobj.getCookie(SaveCookie.class);
                if (save!=null) save.save();
            }
            
        }
        return Collections.singleton(dobj);
    }
    
    private String getRelativePathOfSchema(DataObject wsdlDO, String schemaURL) throws URISyntaxException{
        FileObject fo = wsdlDO.getPrimaryFile();
        File f = FileUtil.toFile(fo);
        String relativePath = org.netbeans.modules.xml.retriever.catalog.Utilities.relativize(f.toURI(),new URI(schemaURL) );
        return relativePath;
    }
    
    private static final String DEFAULT_TARGET_NAMESPACE = "urn:WS/wsdl"; //NOI18N
    
    // --- The rest probably does not need to be touched. ---
    
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    
    // You can keep a reference to the TemplateWizard which can
    // provide various kinds of useful information such as
    // the currently selected target name.
    // Also the panels will receive wiz as their "settings" object.
    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        index = 0;
        Project project = Templates.getProject( wiz );
        panels = createPanels(project);
        
        // Creating steps.
        Object prop = wiz.getProperty("WizardPanel_contentData"); // NOI18N
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, panels);
        
        for (int i = 0; i < panels.length; i++) {
            Component c = panels[i].getComponent();
            if (steps[i] == null) {
                // Default step name to component name of panel.
                // Mainly useful for getting the name of the target
                // chooser to appear in the list of steps.
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) { // assume Swing components
                JComponent jc = (JComponent) c;
                // Step #.
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i)); // NOI18N
                // Step name (actually the whole list for reference).
                jc.putClientProperty("WizardPanel_contentData", steps); // NOI18N
            }
        }
    }
    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        panels = null;
    }
    
    // --- WizardDescriptor.Iterator METHODS: ---
    // Note that this is very similar to WizardDescriptor.Iterator, but with a
    // few more options for customization. If you e.g. want to make panels appear
    // or disappear dynamically, go ahead.
    
    public String name() {
        return NbBundle.getMessage(WsdlIterator.class, "TITLE_x_of_y",
                new Integer(index + 1), new Integer(panels.length));
    }
    
    public boolean hasNext() {
        return index < panels.length - 1;
    }
    public boolean hasPrevious() {
        return index > 0;
    }
    public void nextPanel() {
        if (! hasNext()) throw new NoSuchElementException();
        index++;
    }
    public void previousPanel() {
        if (! hasPrevious()) throw new NoSuchElementException();
        index--;
    }
    public WizardDescriptor.Panel current() {
        return panels[index];
    }
    
    // If nothing unusual changes in the middle of the wizard, simply:
    public final void addChangeListener(ChangeListener l) {}
    public final void removeChangeListener(ChangeListener l) {}
    // If something changes dynamically (besides moving between panels),
    // e.g. the number of panels changes in response to user input, then
    // uncomment the following and call when needed:
    // fireChangeEvent ();
}
