/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.editor.completion;

import java.awt.Image;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.spi.editor.completion.*;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

/**
 *
 * @author  Dusan Balek, Marek Fukala
 */

public abstract class WSResultItem implements CompletionQuery.ResultItem, CompletionItem {

    protected int substituteOffset = -1;

    public abstract String getItemText();

//    protected static Color getTypeColor(Type typ) {
//        return (typ instanceof PrimitiveType) ? JEE5PaintComponent.KEYWORD_COLOR : JEE5PaintComponent.TYPE_COLOR;
//    }
    
    public void setSubstituteOffset(int substituteOffset) {
        this.substituteOffset = substituteOffset;
    }
    
    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        // [PENDING] not enough info in parameters...
        // commonText
        // substituteExp
        return false;
    }
    
    public Object getAssociatedObject() {
        return this;
    }
    
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = getItemText();

        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) // NOI18N
                text += toAdd;
            // Update the text
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) return false;
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            } catch (BadLocationException e) {
                // Can't update
                return false;
            } finally {
                doc.atomicUnlock();
            }
            return true;

        } else {
            return false;
        }
    }
    
    public Component getPaintComponent(javax.swing.JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = getPaintComponent(isSelected);
        if (ret==null) return null;
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(getItemText());
        ret.getAccessibleContext().setAccessibleDescription(getItemText());
        return ret;
    }
    
    public abstract Component getPaintComponent(boolean isSelected);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor,
    Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((WSPaintComponent)renderComponent).paintComponent(g);
    }
    
    public String toString() {
        return getItemText();
    }

    // CompletionItem implementation

    public static final String COMPLETION_SUBSTITUTE_TEXT= "completion-substitute-text"; //NOI18N

    static String toAdd;

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == KeyEvent.KEY_TYPED) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ':
                    if (evt.getModifiers() == 0) {
                        completion.hideCompletion();
                        completion.hideDocumentation();
                    }
                    break;
                case ';':
                case ',':
                case '(':
                    completion.hideCompletion();
                    completion.hideDocumentation();
                case '.':
                    if (defaultAction((JTextComponent)evt.getSource(), Character.toString(evt.getKeyChar()))) {
                        evt.consume();
                        break;
                    }
            }
        }
    }

    public CharSequence getSortText() {
        return getItemText();
    }
    
    public CharSequence getInsertPrefix() {
        return getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }
    
    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        defaultAction(component, "");
    }
    
    private boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = substituteOffset;
        if (substOffset == -1)
            substOffset = component.getCaret().getDot();
        WSResultItem.toAdd = addText;
        return substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }
   
    //TODO: cache paint components
    
    private abstract static class FileAttributeValue extends WSResultItem {
        
        private String name;
  
        public FileAttributeValue(String name) {
            this.name = name;
        }
        
        public String getItemText() {
            return name;
        }
        
        public int getSortPriority() {
            return 10;
        }
        
    }
    
    static class PackageResultItem extends FileAttributeValue {
        
        public PackageResultItem(String name) {
            super(name);
        }
        
        public int getSortPriority() {
            return 9;
        }
      
        public Component getPaintComponent(final boolean isSelected) {
            WSPaintComponent.NbStringPaintComponent pc = new WSPaintComponent.PackageItemPaintComponent();
            pc.setString(getItemText());
            return pc;
        }
    }
    
    static class FileResultItem extends FileAttributeValue {
        
        private Image icon;
        
        public FileResultItem(String name, Image icon) {
            super(name);
            this.icon = icon;
        }
        
       public Component getPaintComponent(final boolean isSelected) {
            WSPaintComponent.NbStringPaintComponent pc = new WSPaintComponent.FileItemPaintComponent(icon);
            pc.setString(getItemText());
            return pc;
        }
    }
    
    static class FileProtocolResultItem extends WSResultItem {
        
        private boolean quoted;
        
        public FileProtocolResultItem(boolean quoted) {
            this.quoted = quoted;
        }
        
        public String getDisplayname() {
            return "file://";
        }
        
        public String getItemText() {
            return (quoted ? "" : "\"") + getDisplayname() + (quoted ? "" : "\"");
        }
        
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            boolean substituted = super.substituteText(c, offset, len, shift);
            if(substituted && !quoted) {
                c.setCaretPosition(c.getCaretPosition() - 1);
            }
            return substituted;
        }
        
        public int getSortPriority() {
            return 100;
        }
        
       public Component getPaintComponent(final boolean isSelected) {
            WSPaintComponent.NbStringPaintComponent pc = new WSPaintComponent.FileProtocolItemPaintComponent();
            pc.setString(getDisplayname());
            return pc;
        }
       
    }
}
