/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * WSDataObject.java
 *
 * Created on March 1, 2006, 10:34 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.websvc.core.wseditor.support;

import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

/**
 *
 * @author Roderico Cruz
 */
public class WSDataObject extends MultiDataObject{
    private WSFilterNode wsFilterNode;
    /** Creates a new instance of WSDataObject */
    public WSDataObject(FileObject file, MultiFileLoader ldr)
       throws DataObjectExistsException{
        super(file, ldr);
    }

    public void changeNode(Node newNode){
        this.getNodeDelegate();
        wsFilterNode.switchNode(newNode);
    }
    
    protected Node createNodeDelegate() {
        wsFilterNode = new WSFilterNode(new AbstractNode(Children.LEAF));
        return wsFilterNode;
    }

    public Node.Cookie getCookie(Class type) {
        if(type.isAssignableFrom(SaveCookie.class)){
            return this.getNodeDelegate().getCookie(type);
        }
        return super.getCookie(type);
    }
    
    
     class WSFilterNode extends FilterNode{
        public WSFilterNode(Node original){
            super(original);
        }
        
        public void switchNode(Node newNode){
            this.changeOriginal(newNode, false);
            //System.out.println("after changeOriginal: " +
                    //this.getOriginal().getClass().getName());
        }
    }
   

}
