/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.webservices.ui.WSHandlerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  rico
 */
public class MessageHandlerPanel extends javax.swing.JPanel {
    
    private Project project;
    private String[] handlerClasses;
    private boolean isJaxWS;
    private DefaultListModel listModel;
    private String componentName;
    
    /** Creates new form HandlerPanel */
    public MessageHandlerPanel(Project project, String[] handlerClasses, boolean isJaxWS,
            String componentName) {
        this.project = project;
        this.handlerClasses = handlerClasses;
        this.isJaxWS = isJaxWS;
        this.componentName = componentName;
        initComponents();
        addBtn.addActionListener(new AddButtonActionListener());
        removeBtn.addActionListener(new RemoveButtonActionListener());
        listModel = new DefaultListModel();
        messageHandlerList.setModel(listModel);
        populateHandlers();
    }
    
    private void populateHandlers(){
        for(int i = 0; i < handlerClasses.length; i++){
            listModel.addElement(handlerClasses[i]);
        }
    }
    
    public DefaultListModel getListModel(){
        return listModel;
    }
    
    private int getSelectedRow() {
        ListSelectionModel lsm = (ListSelectionModel)messageHandlerList.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        } else {
            return lsm.getMinSelectionIndex();
        }
    }
    
    class RemoveButtonActionListener implements ActionListener{
        public void actionPerformed(ActionEvent e) {
            int selectedRow = getSelectedRow();
            if(selectedRow == -1) return;
            String className = (String)listModel.getElementAt(selectedRow);
            if(confirmDeletion(className)){
                listModel.removeElementAt(selectedRow);
            }
        }
        
        private boolean confirmDeletion(String className) {
            NotifyDescriptor.Confirmation notifyDesc =
                    new NotifyDescriptor.Confirmation(NbBundle.getMessage
                    (MessageHandlerPanel.class, "MSG_CONFIRM_DELETE", className, componentName),
                    NbBundle.getMessage(MessageHandlerPanel.class, "TTL_CONFIRM_DELETE"),
                    NotifyDescriptor.YES_NO_OPTION);
            DialogDisplayer.getDefault().notify(notifyDesc);
            return (notifyDesc.getValue() == NotifyDescriptor.YES_OPTION);
        }
    }
    
    class AddButtonActionListener implements ActionListener{
        DialogDescriptor dlgDesc = null;
        public void actionPerformed(ActionEvent evt){
            WSHandlerDialog wsHandlerDialog = new WSHandlerDialog(project, isJaxWS);
            wsHandlerDialog.show();
            if(wsHandlerDialog.okButtonPressed()){
                Set<String> selectedClasses = wsHandlerDialog.getSelectedClasses();
                for(String selectedClass : selectedClasses){
                    listModel.addElement(selectedClass);
                }
            }
        }
    }
    
    class HandlerListSelectionListener implements ListSelectionListener{
        public void valueChanged(ListSelectionEvent e) {
  
        }
        
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        messageHandlerList = new javax.swing.JList();
        addBtn = new javax.swing.JButton();
        removeBtn = new javax.swing.JButton();
        classesLabel = new javax.swing.JLabel();

        messageHandlerList.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        messageHandlerList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(messageHandlerList);

        addBtn.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("Add_DotDotDot_label"));

        removeBtn.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("Remove_label"));

        classesLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/websvc/core/webservices/ui/panels/Bundle").getString("LBL_HANDLER_CLASSES"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(classesLabel)
                    .add(layout.createSequentialGroup()
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 271, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(28, 28, 28)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(addBtn, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 112, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(removeBtn, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 112, Short.MAX_VALUE))))
                .addContainerGap(28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(101, 101, 101)
                        .add(addBtn)
                        .add(28, 28, 28)
                        .add(removeBtn))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(classesLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 13, Short.MAX_VALUE)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 269, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addBtn;
    private javax.swing.JLabel classesLabel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList messageHandlerList;
    private javax.swing.JButton removeBtn;
    // End of variables declaration//GEN-END:variables
    
}
