/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.core.webservices.action;

import java.io.IOException;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebServiceClassesCookieImpl implements WebServiceClassesCookie {
    WebserviceDescription webServiceDescription;
    FileObject implClassFO;
    
    public WebServiceClassesCookieImpl(WebserviceDescription webServiceDescription, FileObject implClassFO) {
        this.webServiceDescription = webServiceDescription;
        this.implClassFO = implClassFO;
    }
    
    private JavaClass getSEIClass() {
        PortComponent portComponent = webServiceDescription.getPortComponent(0); //assume one port per ws
        String sei = portComponent.getServiceEndpointInterface();
        //System.out.println("Service endpoint interface: " + sei);
        JavaClass cl = JMIUtils.findClass(sei, implClassFO);
        return cl;
    }
    
    
    private JavaClass getImplBeanClass() {
        PortComponent portComponent = webServiceDescription.getPortComponent(0); //assume one port per ws
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        String link =serviceImplBean.getServletLink();
        if(link == null) {
            link = serviceImplBean.getEjbLink();
        }
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(implClassFO);
        String implBean = wsSupport.getImplementationBean(link);
        if(implBean != null) {
            return JMIUtils.findClass(implBean, implClassFO);
        }
        return null;
    }
    
    private String getImplicitValue(Type t) {
        // TODO - should enhance to enum types, annotation types
        String ret = "return ";
        
        if (t instanceof PrimitiveType) {
            
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
                return "false"; //NOI18N
            }
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.CHAR)) {
                return "''"; //NOI18N
            }
            return "0"; //NOI18N
            
        } else if (t instanceof JavaClass) {
            return "null"; //NOI18N
            
        } else if (t instanceof Array) {
            return "new " + t.getName() + " { }"; //NOI18N
        }
        
        return null;
    }
    
    
    public void addOperation(Method m) {
        JavaClass implClass = null;
        JavaClass seiClass = null;
        boolean rollback = true;
        JMIUtils.beginJmiTransaction(true);
        try {
            m.setJavadocText("Web service operation");
            implClass = getImplBeanClass();
            
            String body = NbBundle.getMessage(WebServiceClassesCookieImpl.class, "TXT_VoidOperation"); //NOI18N
            
            Type returnType = m.getType();
            if (!((returnType instanceof PrimitiveType) && ((PrimitiveType) returnType).getKind().equals(PrimitiveTypeKindEnum.VOID))) {
                String retString = getImplicitValue(m.getType());
                if (retString != null) {
                    body += "return " + retString + ";"; //NOI18N
                }
            }
            
            seiClass = getSEIClass();
            final String remoteExceptionName = "java.rmi.RemoteException"; // NOI18N
            boolean excFound = false;
            for (Iterator iter = m.getExceptionNames().iterator(); iter.hasNext(); ) {
                MultipartId id = (MultipartId) iter.next();
                if (remoteExceptionName.equals(id.getName())) {
                    excFound = true;
                    break;
                }
            }
            if (!excFound) {
                JMIUtils.addException(m, remoteExceptionName);
            }
            if (seiClass != null) {
                Method newMet = (Method) JavaModelUtil.duplicateInScope(seiClass, m);
                seiClass.getContents().add(newMet);
            }
            
            if (implClass != null) {
                implClass.getContents().add(m);
            }
            // #61178
            JMIUtils.fixImports(implClass);
            JMIUtils.fixImports(seiClass);
            
            m.setBodyText(body);
            
            rollback = false;
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        
        //save the SEI class
        save(seiClass);
        
        JMIUtils.openInEditor(m);
    }
    
    private void save(JavaClass jc){
        if(jc == null) return;
        SaveCookie saveCookie =(SaveCookie) JMIUtils.getCookie(jc, SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, ioe);
            }
        }
    }
    
}

