/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.core.jaxws.nodes;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Adamek
 */
public class RefreshWsDialog extends javax.swing.JPanel {
    
    static final int CLOSE = 0;
    static final int DO_NOTHING = 1;
    static final int DOWNLOAD_WSDL = 2;
    static final int REGENERATE_IMPL_CLASS = 3;
    static final int DO_ALL = 4;
    
    private String implClass,url;
    private boolean downloadWsdl;
    
    private RefreshWsDialog(boolean downloadWsdl, String implClass, String url) {
        this.downloadWsdl=downloadWsdl;
        this.implClass = implClass;
        this.url=url;
        initComponents();
        // display the delete_wsdl checkbox only if wsdl exists
        if (!downloadWsdl) {
            downloadWsdlCheckBox.setVisible(false);
            jLabel1.setVisible(false);
        }
    }
 
    public static int open(boolean downloadWsdl, String implClass, String url) {
        String title = NbBundle.getMessage(RefreshWsDialog.class, "MSG_ConfirmServiceRefresh");
        RefreshWsDialog delDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor desc = new NotifyDescriptor.Confirmation(delDialog, title, NotifyDescriptor.YES_NO_OPTION);
        Object result = DialogDisplayer.getDefault().notify(desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return CLOSE;
        } else if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return CLOSE;
        } else if (delDialog.downloadWsdl() && delDialog.regenerate()) {
            return DO_ALL;
        } else if (delDialog.downloadWsdl()) {
            return DOWNLOAD_WSDL;
        } else if (delDialog.regenerate()) {
            return REGENERATE_IMPL_CLASS;
        } else return DO_NOTHING;
        
    }
    
    /**
     * This prompts the user if he/she wants to regenerate the impl bean
     * but does not give a choice as to refreshing the nodes (i.e. the nodes are
     * always refreshed.
     */
    public static int openWithOKButtonOnly(boolean downloadWsdl, String implClass, String url){
        String title = NbBundle.getMessage(RefreshWsDialog.class, "MSG_ConfirmServiceRefresh");
        RefreshWsDialog delDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor desc = new NotifyDescriptor.Message(delDialog, NotifyDescriptor.INFORMATION_MESSAGE);
        DialogDisplayer.getDefault().notify(desc);
        if(delDialog.regenerate()){
            return REGENERATE_IMPL_CLASS;
        }
        return DO_NOTHING;
    }
    
    
    private boolean downloadWsdl() {
        if (!downloadWsdl) return false;
        return downloadWsdlCheckBox.isSelected();
    }
    
    private boolean regenerate() {
        return regenerateCheckBox.isSelected();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        downloadWsdlCheckBox = new javax.swing.JCheckBox();
        regenerateCheckBox = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        downloadWsdlCheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "MSG_DownloadWsdl_mnem").charAt(0));
        downloadWsdlCheckBox.setText(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "MSG_DownloadWsdl", new Object[] {url}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(downloadWsdlCheckBox, gridBagConstraints);

        regenerateCheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "MSG_RegenerateImplClass_mnem").charAt(0));
        regenerateCheckBox.setSelected(true);
        regenerateCheckBox.setText(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "MSG_RegenerateImplClass"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        add(regenerateCheckBox, gridBagConstraints);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "HINT_DownloadWsdl"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 22, 0, 0);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "HINT_RegenerateImplClass", new Object[] {implClass+".java.old"}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 22, 0, 0);
        add(jLabel2, gridBagConstraints);

        jLabel3.setText(org.openide.util.NbBundle.getMessage(RefreshWsDialog.class, "HINT_RefreshService"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 20, 0);
        add(jLabel3, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox downloadWsdlCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JCheckBox regenerateCheckBox;
    // End of variables declaration//GEN-END:variables
    
}
