/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.core.client.actions;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.core.client.wizard.ClientBuilder;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;

import org.openide.DialogDisplayer;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;

import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

import org.netbeans.modules.websvc.core.ServiceInformation;
import org.netbeans.modules.websvc.core.client.ui.ClientExplorerPanel;
import org.netbeans.modules.websvc.wsdl.PortInformationHandler;

import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.xml.sax.SAXException;


/**
 *
 * @author Peter Williams
 */
public class InvokeOperationAction extends CookieAction {
    public String getName() {
        return NbBundle.getMessage(InvokeOperationAction.class, "LBL_CallWebServiceOperation"); // NOI18N
    }

    public HelpCtx getHelpCtx() {
        // If you will provide context help then use:
        // return new HelpCtx(AddOperationAction.class);
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return MODE_EXACTLY_ONE;
    }

    protected Class[] cookieClasses() {
        return new Class[] { ClassMember.class };
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0] != null) {
            EditorCookie cookie = (EditorCookie)activatedNodes[0].getCookie(EditorCookie.class);
            if (cookie!=null && "text/x-jsp".equals(cookie.getDocument().getProperty("mimeType"))) { //NOI18N
                return true;
            } else if (cookie!=null && "text/x-java".equals(cookie.getDocument().getProperty("mimeType"))) {
                result = (JMIUtils.getCallableFeatureFromNode(activatedNodes[0]) != null);
            }
        }
        return result;
    }

    protected void performAction(Node[] activatedNodes) {
        if(activatedNodes != null && activatedNodes[0] != null) {
            FileObject currentFO = getCurrentFileObject(activatedNodes[0]);
            if(currentFO != null) {
                // !PW I wrote this code before I knew about NodeOperation.  Anyway, this
                // behaves a bit nicer in that the root node is hidden and the tree opens
                // up expanded.  Both improve usability for this use case I think.
                ClientExplorerPanel serviceExplorer = new ClientExplorerPanel(currentFO);
                DialogDescriptor descriptor = new DialogDescriptor(serviceExplorer, 
                        NbBundle.getMessage(InvokeOperationAction.class,"TTL_SelectOperation"));
                serviceExplorer.setDescriptor(descriptor);
                // !PW FIXME put help context here when known to get a displayed help button on the panel.
//                descriptor.setHelpCtx(new HelpCtx("HelpCtx_J2eePlatformInstallRootQuery"));
                if(DialogDisplayer.getDefault().notify(descriptor).equals(NotifyDescriptor.OK_OPTION)) {
                    // !PW FIXME refactor this as a method implemented in a cookie
                    // on the method node.
                    insertMethodCall(getCurrentDataObject(activatedNodes[0]), activatedNodes[0], serviceExplorer.getSelectedMethod());
                }
            }
        }
    }
    
    // {0} = service name (as type, e.g. "FooSeWebService")
    // {1} = service name (as variable, e.g. "fooService")
    // {2} = fully qualified service name (as type, e.g. com.service.FooService)
    private static final String SERVICE_DELEGATE_BODY = 
//        "if({1} == null) '{'\n" +
        "{2} {1} = null;" +
        "\ntry '{'\n" +
        "\t\tjavax.naming.InitialContext ic = new javax.naming.InitialContext();\n" +
        "\t\t{1} = ({2}) ic.lookup(\"java:comp/env/service/{0}\");\n" +
        "\t'}' catch(javax.naming.NamingException ex) '{'\n" +
        "\t\t// TODO handle JNDI naming exception\n" +
        "\t'}'\n" +
//        "'}'\n\n" +
        "return {1};\n";

    // {0} = service name (as type, e.g. "FooSeWebService")
    // {1} = service name (as variable, e.g. "fooService")
    // {2} = fully qualified service name (as type, e.g. com.service.FooService)
    // {3} = service delegate name
    private static final String SERVICE_DELEGATE_METHOD_JSP =
        "<%!\n" +
        "private {2} {3}() '{'\n" +
        "    {2} {1} = null;\n" +
        "    try '{'\n" +
        "        javax.naming.InitialContext ic = new javax.naming.InitialContext();\n" +
        "        {1} = ({2}) ic.lookup(\"java:comp/env/service/{0}\");\n" +
        "    '}' catch(javax.naming.NamingException ex) '{'\n" +
        "        // TODO handle JNDI naming exception\n" +
        "    '}'" +
        "    return {1};\n" +
        "'}'\n" +
        "%>\n";
    

    // {0} = port name (as variable, e.g. "fooPort")
    // {1} = true port name (e.g. "FooPort")
    // {2} = service delegate name (e.g. "getFooService")
    // {3} = fully qualified port name (as type, e.g. com.service.FooPortType)
    private static final String PORT_DELEGATE_BODY = 
//        "if({0} == null) '{'\n" +
        "{3} {0} = null;" +
        "\ntry '{'\n" +
        "\t\t{0} = {2}().get{1}();\n" +
        "\t'}' catch(javax.xml.rpc.ServiceException ex) '{'\n" +
        "\t\t// TODO handle service exception\n" +
        "\t'}'\n" +
//        "'}'\n\n" +
        "return {0};\n";

    // {0} = port name (as variable, e.g. "fooPort")
    // {1} = true port name (e.g. "FooPort")
    // {2} = service delegate name (e.g. "getFooService")
    // {3} = fully qualified port name (as type, e.g. com.service.FooPortType)
    // {4} = port delegate name
    private static final String PORT_DELEGATE_METHOD_JSP = 
        "<%!\n" +
        "private {3} {4}() '{'\n" +
        "    {3} {0} = null;\n" +
        "    try '{'\n" +
        "        {0} = {2}().get{1}();\n" +
        "    '}' catch(javax.xml.rpc.ServiceException ex) '{'\n" +
        "        // TODO handle service exception\n" +
        "    '}'\n" +
        "    return {0};\n" +
        "'}'\n" +
        "%>\n";
    
    // {0} = service operation name (e.g. "getFoo")
    // {1} = port delegate name (e.g. "getFooPort")
    private static final String OPERATION_INVOCATION_BODY =
        "\ntry '{' // This code block invokes the {0} operation on web service\n" +
        "\t{1}().{0}(/* TODO enter operation arguments */);\n" +
        "'}' catch(java.rmi.RemoteException ex) '{'\n" +
        "\t// TODO handle remote exception\n" +
        "'}' catch(Exception ex) '{'\n" +
        "\t// TODO handle custom exceptions here\n" +
        "'}'\n";
    
    // {0} = service operation name (e.g. "getFoo")
    // {1} = port delegate name (e.g. "getFooPort")
    private static final String OPERATION_INVOCATION_BODY_JSP =
        "    try '{'\n" +
        "        out.println(\"result = \"+\n" +
        "            {1}().{0}(/* TODO enter operation arguments */));\n" +
        "    '}' catch(java.rmi.RemoteException ex) '{'\n" +
        "        // TODO handle remote exception\n" +
        "    '}' catch(Exception ex) '{'\n" +
        "        // TODO handle custom exceptions here\n" +
        "    '}'\n";
    
    // {0} = service name (as type, e.g. "FooService")
    // {1} = service name (as variable, e.g. "fooService")
    // {2} = fully qualified service name (as type, e.g. com.service.FooService)
    // {3} = port name (as variable, e.g. "fooPort")
    // {4} = true port name (e.g. "FooPort")
    // {5} = fully qualified port name (as type, e.g. com.service.FooPortType)
    // {6} = service operation name (e.g. "getFoo")
    private static final String OPERATION_INVOCATION_NO_DELEGATES_BODY = 
        "\ntry '{' // This code block invokes the {4}:{6} operation on web service\n" +
// get service
        "\tjavax.naming.InitialContext ic = new javax.naming.InitialContext();\n" +
        "\t{2} {1} = ({2}) ic.lookup(\"java:comp/env/service/{0}\");\n" +
// get port
        "\t{5} {3} = {1}.get{4}();\n" +
// invoke operation
        "\t{3}.{6}(/* TODO enter operation arguments */);\n" +
        "'}' catch(javax.naming.NamingException ex) '{'\n" +
        "\t// TODO handle JNDI naming exception\n" +
        "'}' catch(javax.xml.rpc.ServiceException ex) '{'\n" +
        "\t// TODO handle service exception\n" +
        "'}' catch(java.rmi.RemoteException ex) '{'\n" +
        "\t// TODO handle remote exception\n" +
        "'}' catch(Exception ex) '{'\n" +
        "\t// TODO handle custom exceptions here\n" +
        "'}'\n";
    
    // {0} = service name (as type, e.g. "FooService")
    // {1} = service name (as variable, e.g. "fooService")
    // {2} = fully qualified service name (as type, e.g. com.service.FooService)
    // {3} = fully qualified service stub name (as type, e.g. com.service.FooService_Impl)
    // {4} = port name (as variable, e.g. "fooPort")
    // {5} = true port name (e.g. "FooPort")
    // {6} = fully qualified port name (as type, e.g. com.service.FooPortType)
    // {7} = service operation name (e.g. "getFoo")
    private static final String OPERATION_INVOCATION_JAXRPC_BODY = 
        "\ntry '{' // This code block invokes the {5}:{7} operation on web service\n" +
        "\t{2} {1} = new {3}();\n" +
        "\t{6} {4} = {1}.get{5}();\n" +
        "\t{4}.{7}(/* TODO enter operation arguments*/);\n" +
        "'}' catch(javax.xml.rpc.ServiceException ex) '{'\n" +
        "\t// TODO handle ServiceException\n" +
        "'}' catch(java.rmi.RemoteException ex) '{'\n" +
        "\t// TODO handle remote exception\n" +
        "'}' catch(Exception ex) '{'\n" +
        "\t// TODO handle custom exceptions here\n" +
        "'}'\n";
    
    // {0} = service name (as type, e.g. "FooService")
    // {1} = service name (as variable, e.g. "fooService")
    // {2} = fully qualified service name (as type, e.g. com.service.FooService)
    // {3} = fully qualified service stub name (as type, e.g. com.service.FooService_Impl)
    // {4} = port name (as variable, e.g. "fooPort")
    // {5} = true port name (e.g. "FooPort")
    // {6} = fully qualified port name (as type, e.g. com.service.FooPortType)
    // {7} = service operation name (e.g. "getFoo")
    private static final String OPERATION_INVOCATION_JAXRPC_BODY_JSP = 
        "    try '{'\n" +
        "        {2} {1} = new {3}();\n" +
        "        {6} {4} = {1}.get{5}();\n" +
        "        out.println(\"result = \"+\n" +
        "            {4}.{7}(/* TODO enter operation arguments*/));\n" +
        "    '}' catch(javax.xml.rpc.ServiceException ex) '{'\n" +
        "        // TODO handle ServiceException\n" +
        "    '}' catch(java.rmi.RemoteException ex) '{'\n" +
        "        // TODO handle remote exception\n" +
        "    '}' catch(Exception ex) '{'\n" +
        "        // TODO handle custom exceptions here\n" +
        "    '}'\n";

    private static String varFromName(final String name) {
        if (name.length() > 0) {
            StringBuffer buf = new StringBuffer(name);

            // If the first character is uppercase, make it lowercase for the variable name,
            // otherwise, prefix an underscore.
            if(Character.isUpperCase(buf.charAt(0))) {
                buf.setCharAt(0, Character.toLowerCase(buf.charAt(0)));
            } else {
                buf.insert(0, '_');
            }
            
            return removeDots(buf).toString();
        } else {
            return "unknown"; // NOI18N
        }
    }

    private static String classFromName(final String name) {
        if (name.length() > 0) {
            StringBuffer result = new StringBuffer(name);

            if (result.length() > 0 && !Character.isUpperCase(result.charAt(0))) {
                result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
            }

            return removeDots(result).toString();
        } else {
            return "unknown"; // NOI18N
        }
    }
    
    // replace dots in a class/var name
    private static StringBuffer removeDots(final StringBuffer name) {
        int dotIndex;
        while ((dotIndex = name.indexOf(".")) > -1) { //NOI18N
            name.deleteCharAt(dotIndex); //delete the dot
            name.setCharAt(dotIndex, Character.toUpperCase(name.charAt(dotIndex))); // make the letter after dot uppercase
        }
        return name;
    }

    private static ClientStubDescriptor getStub(FileObject fo, String serviceName) {
        ClientStubDescriptor result = null;
        WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport(fo);
        if(clientSupport != null) {
            List clients = clientSupport.getServiceClients();
            for(Iterator iter = clients.iterator(); iter.hasNext(); ) {
                WsCompileClientEditorSupport.ServiceSettings settings = (WsCompileClientEditorSupport.ServiceSettings) iter.next();
                if(settings.getServiceName().equals(serviceName)) {
                    result = settings.getClientStubDescriptor();
                    break;
                }
            }
        } else {
            // !PW Doh!  how did this happen?
        }
        return result;
    }
    
    private static void insertMethodCall(DataObject dataObj, Node sourceNode, Node serviceOperationNode) {
        
        if (serviceOperationNode.getLookup().lookup(WsdlOperation.class)!=null) {
            JaxWsCodeGenerator.insertMethodCall(dataObj, sourceNode,serviceOperationNode);
            return;
        }
        
        // First, collect name of method, port, and service:  
        Node serviceNode, servicePortNode;

        String wsdlName;
        String serviceName, serviceClassName, serviceVarName;
        String servicePortName, servicePortJaxRpcName, servicePortVarName, servicePortTypeName = null;
        String serviceOperationName;

        try {
            servicePortNode = serviceOperationNode.getParentNode();
            serviceNode = servicePortNode.getParentNode();

            DataObject wsdlObj = (DataObject) serviceNode.getLookup().lookup(DataObject.class);
            wsdlName = wsdlObj.getName();
            
            serviceOperationName = serviceOperationNode.getName();
            servicePortName = servicePortNode.getName();
            servicePortJaxRpcName = classFromName(servicePortName);
            servicePortVarName = varFromName(servicePortName);
            
            serviceName = serviceNode.getName();
            serviceClassName = classFromName(serviceName);
            serviceVarName = varFromName(serviceName);

        } catch (NullPointerException npe) {
            // !PW notify failure to extract service information.
            String message = NbBundle.getMessage(InvokeOperationAction.class, "ERR_FailedUnexpectedWebServiceDescriptionPattern"); // NOI18N
            NotifyDescriptor desc = new NotifyDescriptor.Message(message, NotifyDescriptor.Message.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(desc);
            return;
        }

        EditorCookie ec = (EditorCookie)dataObj.getCookie(EditorCookie.class);
        JEditorPane pane = ec.getOpenedPanes()[0];
        int caretOffset = pane.getCaretPosition();
        
        // Collect up any and all errors for display in case of problem
        ArrayList errors = new ArrayList();

        String servicePackageName;
        ServiceInformation serviceInfo = (ServiceInformation) serviceNode.getCookie(ServiceInformation.class);
        PortInformationHandler portInformation = (PortInformationHandler)serviceInfo.getPortInformation();
        
        List portInfoList = null;
        List wsdlLocationsList = serviceInfo.getPortInformation().getImportedSchemas();
        if (wsdlLocationsList!=null && wsdlLocationsList.size()>0) {
            PortInformationHandler handler = new PortInformationHandler(portInformation.getTargetNamespace(),
                                                                        portInformation.getServices(),
                                                                        portInformation.getEntirePortList(),
                                                                        portInformation.getBindings(),
                                                                        wsdlLocationsList);
                Iterator it = wsdlLocationsList.iterator();
                while (it.hasNext()) {
                    String wsdlLocation = (String)it.next();
                    try {
                        if (wsdlLocation.indexOf("/")<0) { //local
                            dataObj.getPrimaryFile();
                            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport(dataObj.getPrimaryFile());
                            FileObject wsdlFo = clientSupport.getWsdlFolder().getFileObject(wsdlLocation);
                            if (wsdlFo!=null)
                                parse (wsdlFo, handler);
                        } else { // remote
                            URL wsdlURL = new URL(wsdlLocation);
                            try {
                                parse (wsdlURL, handler);
                            } catch (java.net.UnknownHostException ex) {
                                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                                String mes = NbBundle.getMessage(ClientBuilder.class, "ERR_UnknownHost", ex.getMessage()); // NOI18N
                                NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                                DialogDisplayer.getDefault().notify(desc);
                                return;
                            }
                        }
                        
                    } catch(ParserConfigurationException ex) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                        String mes = NbBundle.getMessage(ClientBuilder.class, "ERR_WsdlParseFailure", ex.getMessage()); // NOI18N
                        NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(desc);
                        //return result;
                    } catch(SAXException ex) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                        String mes = NbBundle.getMessage(ClientBuilder.class, "ERR_WsdlParseFailure", ex.getMessage()); // NOI18N
                        NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(desc);
                        //return result;
                    } catch(IOException ex) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                        String mes = NbBundle.getMessage(ClientBuilder.class, "ERR_ClientIOError", wsdlLocation, ex.getMessage()); // NOI18N
                        NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(desc);
                    }
                }
            portInfoList = handler.getEntirePortList();
        } else {
            portInfoList = serviceInfo.getServicePorts(serviceName);
        }
        
        if (serviceInfo != null) {
            servicePackageName = serviceInfo.getServicePackageName();
            for (Iterator iter = portInfoList.iterator(); iter.hasNext(); ) {
                PortInformationHandler.PortInfo portInfo = (PortInformationHandler.PortInfo) iter.next();
                if(servicePortName.equals(portInfo.getPort())) {
                    servicePortTypeName = classFromName(portInfo.getPortType());
                    break;
                }
            }
            if (servicePortTypeName == null) {
                servicePortTypeName = servicePortJaxRpcName + "UnknownType"; // NOI18N
                errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_CannotDetermineWebServicePortTypeName")); // NOI18N
            }
        } else {
            servicePackageName = "unknown.service.package"; // NOI18N
            servicePortTypeName = servicePortJaxRpcName + "UnknownType"; // NOI18N
            errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_CannotLocateWebServiceInterfaces")); // NOI18N
        }

        String fqServiceClassName = servicePackageName + "." + serviceClassName;
        String fqPortTypeName = servicePackageName + "." + servicePortTypeName;

        String serviceDelegateName = "get" + serviceClassName; //NOI18N
        String portDelegateName = "get" + servicePortJaxRpcName; //NOI18N
        
        ClientStubDescriptor stubType = getStub(dataObj.getPrimaryFile(), wsdlName);
        
        JMManager manager = (JMManager)JMManager.getManager();
        MDRepository repository = JavaModel.getJavaRepository();
        
        EditorCookie cookie = (EditorCookie)sourceNode.getCookie(EditorCookie.class);
 
        // including code to JSP
        if (cookie!=null && "text/x-jsp".equals(cookie.getDocument().getProperty("mimeType"))) { //NOI18N
            if (stubType == null) {
                //errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_CannotDeterminedStubType", serviceName)); // NOI1N
                StringBuffer buf = new StringBuffer();
                buf.append(NbBundle.getMessage(InvokeOperationAction.class, "ERR_FailedWebServiceInvocationCreation")); // NOI18N
                buf.append("\n"); // NOI18N
                buf.append(NbBundle.getMessage(InvokeOperationAction.class, "ERR_CannotDeterminedStubType", serviceName));
                NotifyDescriptor desc = new NotifyDescriptor.Message(buf.toString(), NotifyDescriptor.Message.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
                return;
            }
            final javax.swing.text.StyledDocument document = cookie.getDocument();
            final StringBuffer buf = new StringBuffer();
            if (ClientStubDescriptor.JSR109_CLIENT_STUB.equals(stubType.getName())) {
                Object [] args = new Object [] { serviceName, serviceVarName, fqServiceClassName, serviceDelegateName};
                String method1 = MessageFormat.format(SERVICE_DELEGATE_METHOD_JSP, args);
                args = new Object [] { servicePortVarName, servicePortJaxRpcName, serviceDelegateName, fqPortTypeName, portDelegateName};
                String method2 = MessageFormat.format(PORT_DELEGATE_METHOD_JSP, args);
                buf.append("\n"); //NOI18N
                buf.append(method1);
                buf.append("\n"); //NOI18N
                buf.append(method2);
            }
            String invocationBody = "";
            if (ClientStubDescriptor.JSR109_CLIENT_STUB.equals(stubType.getName())) {
                // create the inserted text
                Object[] args = new Object [] { serviceOperationName, portDelegateName };
                invocationBody = MessageFormat.format(OPERATION_INVOCATION_BODY_JSP, args);

            } else if (ClientStubDescriptor.JAXRPC_CLIENT_STUB.equals(stubType.getName())) { // JAXRPC static stub
                // create the inserted text
                Object[] args = new Object [] { //serviceOperationName, portDelegateName.getName() };
                    serviceName, serviceVarName, fqServiceClassName,
                    fqServiceClassName + "_Impl", // NOI18N // !PW Note this classname is JAXRPC implementation dependent.
                    servicePortVarName, servicePortJaxRpcName, fqPortTypeName,
                    serviceOperationName
                };
                invocationBody = MessageFormat.format(OPERATION_INVOCATION_JAXRPC_BODY_JSP, args);
            }
            final StringBuffer buf1 =new StringBuffer();
            // invocation
            buf1.append("    <%-- start web service invocation --%>\n"); //NOI18N
            buf1.append("    <h4>"+serviceName+" invocation:</h4>\n"); //NOI18N
            buf1.append("    <hr/>\n"); //NOI18N
            buf1.append("    <%\n"); //NOI18N
            buf1.append("    // TODO compute web service operation arguments here, e.g.:\n"); //NOI18N
            buf1.append("    // String arg0 = request.getParameter(\"arg0\");\n"); //NOI18N
            buf1.append(invocationBody);
            buf1.append("    %>\n"); //NOI18N
            buf1.append("    <hr/><%-- end web service invocation--%>\n"); //NOI18N
            
            // insert 2 parts in one atomic action 
            NbDocument.runAtomic(document, new Runnable() {
                public void run() {
                    try {
                        if (buf.length()>0) {
                            document.insertString(document.getLength(),buf.toString(),null);
                        }
                        if (buf1.length()>0) {
                            String content = document.getText(0, document.getLength());
                            int pos = content.lastIndexOf("</body>"); //NOI18N
                            if (pos<0) pos = content.lastIndexOf("</html>"); //NOI18N
                            if (pos>=0) { //find where line begins
                                while (pos>0 && content.charAt(pos-1)!='\n' && content.charAt(pos-1)!='\r') {
                                    pos--;
                                }
                            } else pos = document.getLength();
                            document.insertString(pos,buf1.toString(),null);
                        }
                    } catch (javax.swing.text.BadLocationException ex) {
                        ErrorManager.getDefault().notify(ex);
                    }
                }
            });
            return;
        }
        
        // including code to java class
        boolean rollbackFlag = true; // rollback the transaction by default
        repository.beginTrans(true); // create transaction for adding delegate methods

        try {
            if (stubType == null) {
                errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_CannotDeterminedStubType", serviceName)); // NOI18N
            } else if (ClientStubDescriptor.JSR109_CLIENT_STUB.equals(stubType.getName())) {        // add service and port delegate methods
                try {
                    ClassMember cm = JMIUtils.getCallableFeatureFromNode(sourceNode);
                    if (cm.isValid()) {

                        ClassDefinition cd = cm.getDeclaringClass();            
                        JavaModelPackage modelPkg = JavaMetamodel.getManager().getJavaExtent(cd);

                        Type serviceType = modelPkg.getType().resolve(fqServiceClassName);
                        Type portType = modelPkg.getType().resolve(fqPortTypeName);

                        boolean createServiceDelegate = true;
                        boolean createPortDelegate = true;

                        List features = cd.getFeatures();
                        for (int i=0; i < features.size(); i++) {
                            Object o = features.get(i);
                            if (o instanceof Method) {
                                Method m = (Method)o;
                                if (serviceDelegateName.equals(m.getName()) && m.getParameters().size() == 0) {
                                    if (m.getType().getName().equals(fqServiceClassName)) {
                                        createServiceDelegate = false;
                                    } else {
                                        serviceDelegateName += "_1";
                                    }
                                }
                                if (portDelegateName.equals(m.getName()) && m.getParameters().size() == 0) { // there's a method without parameters with the same name
                                    if (m.getType().getName().equals(fqPortTypeName)) {
                                        createPortDelegate = false;
                                    } else {
                                        portDelegateName += "_1";
                                    }
                                }
                            }
                        }

                        if (createServiceDelegate) {
                            // Add service delegate
                            Method serviceDelegate = modelPkg.getMethod().createMethod();
                            if (serviceDelegate != null) {
                                serviceDelegate.setName(serviceDelegateName);
                                serviceDelegate.setType(serviceType);
                                serviceDelegate.setModifiers(Modifier.PRIVATE);

                                Object [] args = new Object [] { serviceName, serviceVarName, fqServiceClassName };
                                String delegateBody = MessageFormat.format(SERVICE_DELEGATE_BODY, args);
                                serviceDelegate.setBodyText(delegateBody);
                                cd.getContents().add(serviceDelegate);
                            }
                        }

                        if (createPortDelegate) {
                            // Add port delegate
                            Method portDelegate = modelPkg.getMethod().createMethod();
                            if (portDelegate != null) {
                                portDelegate.setName(portDelegateName);
                                portDelegate.setType(portType);
                                portDelegate.setModifiers(Modifier.PRIVATE);

                                Object [] args = new Object [] { servicePortVarName, servicePortJaxRpcName, serviceDelegateName, fqPortTypeName };
                                String delegateBody = MessageFormat.format(PORT_DELEGATE_BODY, args);
                                portDelegate.setBodyText(delegateBody);
                                cd.getContents().add(portDelegate);
                            }
                        }
                        rollbackFlag = false;   // no errors! - do not rollback
                    }
                } catch (NullPointerException npe) {
                    errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_UnexpectedNPE", npe.getMessage())); // NOI18N
                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, npe);
                }
            } else {
                rollbackFlag = false;
            }
        } finally {
            repository.endTrans(rollbackFlag);
        }
        
        if (!rollbackFlag) { // delegate methods were added correctly - the transaction was not rolled back

            // insert call code
            repository.beginTrans(true);    // this happens in a new transaction
            try {
                ClassMember cm = JMIUtils.getCallableFeatureFromNode(sourceNode);
                if (cm.isValid()) {

                    ClassDefinition cd = cm.getDeclaringClass();
                    JavaModelPackage modelPkg = JavaMetamodel.getManager().getJavaExtent(cd);

                    // find the place where to insert the code
                    int targetOffset = caretOffset; // target insertion point
                    Element elem = manager.getElementByOffset(dataObj.getPrimaryFile(), caretOffset);
                    if (elem instanceof BehavioralFeature) {
                        elem = ((BehavioralFeature) elem).getBody();
                    } else if (elem instanceof PrimaryExpression) {
                        while (!(elem instanceof org.netbeans.jmi.javamodel.Statement)) {
                            elem = (Element)elem.refImmediateComposite(); // go through parents
                        }
                    }
                    if (elem instanceof StatementBlock) {
                        List statements = ((StatementBlock)elem).getStatements();
                        int i;
                        if (statements.size() > 0) {
                            for (i = 0; i < statements.size(); i++) {
                                Statement s = (Statement)statements.get(i);
                                if (JavaMetamodel.getManager().getElementPosition(s).getBegin().getOffset() > targetOffset) {
                                    break;
                                }
                            }
                            if (i>0) {
                                elem = (Statement)statements.get(i-1);
                                targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getEnd().getOffset(); // statement boundary
                            } else {
                                elem = (Statement)statements.get(i);
                                targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getBegin().getOffset(); // statement boundary
                            }
                        } else {
                            targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getBegin().getOffset() + 1; // statement boundary
                        }
                    } else if (elem instanceof Statement) {
                        targetOffset = JavaMetamodel.getManager().getElementPosition(elem).getEnd().getOffset(); // statement boundary
                    }

                    // create & format inserted text
                    Document doc = pane.getDocument();
                    IndentEngine eng = IndentEngine.find(doc);
                    StringWriter textWriter = new StringWriter();
                    Writer indentWriter = eng.createWriter(doc, targetOffset, textWriter);
                    String invocationBody = "";
                    
                    if (ClientStubDescriptor.JSR109_CLIENT_STUB.equals(stubType.getName())) {
                        // create the inserted text
                        Object [] args = new Object [] { serviceOperationName, portDelegateName };
                        invocationBody = MessageFormat.format(OPERATION_INVOCATION_BODY, args);
                    
                    } else if (ClientStubDescriptor.JAXRPC_CLIENT_STUB.equals(stubType.getName())) { // JAXRPC static stub
                        // create the inserted text
                        Object [] args = new Object [] { //serviceOperationName, portDelegateName.getName() };
                            serviceName, serviceVarName, fqServiceClassName,
                            fqServiceClassName + "_Impl", // NOI18N // !PW Note this classname is JAXRPC implementation dependent.
                            servicePortVarName, servicePortJaxRpcName, fqPortTypeName,
                            serviceOperationName
                        };
                        invocationBody = MessageFormat.format(OPERATION_INVOCATION_JAXRPC_BODY, args);
                    }
                    
                    indentWriter.write(invocationBody);
                    indentWriter.close();
                    String textToInsert = textWriter.toString();

                    try {
                        doc.insertString(targetOffset, textToInsert, null);
                    } catch (BadLocationException badLoc) {
                        doc.insertString(targetOffset + 1, textToInsert, null);
                    }

                    rollbackFlag = false;   // great, no exceptions so far! -> do not rollback
                }
            } catch (NullPointerException npe) {
                // This could happen if we get a source exception attempting to create
                // a base component, and a later step tries to use that (still null)
                // component.  There should be an error in the log.
                if (errors.size() == 0) {
                    // If there isn't an error in the log already, put a general one there.
                    errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_UnexpectedNPE", npe.getMessage())); // NOI18N
                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, npe);
                }

            } catch (BadLocationException badLoc) {
                errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_UnexpectedBLE", badLoc.getMessage())); // NOI18N
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, badLoc);

            } catch (IOException ioe) {
                errors.add(NbBundle.getMessage(InvokeOperationAction.class, "ERR_UnexpectedIOE", ioe.getMessage())); // NOI18N
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ioe);

            } finally {
                repository.endTrans(rollbackFlag);
            }
            if (errors.size() > 0) {
                // At least one error was encountered during code insertion.  Display the list of messages.
                StringBuffer buf = new StringBuffer(errors.size() * 100);
                buf.append(NbBundle.getMessage(InvokeOperationAction.class, "ERR_FailedWebServiceInvocationCreation")); // NOI18N
                buf.append("\n"); // NOI18N
                for(Iterator iter = errors.iterator(); iter.hasNext(); ) {
                    buf.append(iter.next().toString());
                    buf.append("\n"); // NOI18N
                }
                NotifyDescriptor desc = new NotifyDescriptor.Message(buf.toString(), NotifyDescriptor.Message.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
            }
        }
    }

    private FileObject getCurrentFileObject(Node n) {
        FileObject result = null;
        DataObject dobj = (DataObject) n.getCookie(DataObject.class);
        if(dobj != null) {
            result = dobj.getPrimaryFile();
        }
        return result;
    }

    private DataObject getCurrentDataObject(Node n) {
        return (DataObject) n.getCookie(DataObject.class);
    }
    
    
    private static void parse(FileObject fo, PortInformationHandler handler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(fo.getInputStream(), handler);
    }
    
    private static void parse(URL url, PortInformationHandler handler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(url.openConnection().getInputStream(), handler);
    }
    
}
