/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.webmodule;

import java.util.HashMap;
import org.netbeans.modules.web.api.webmodule.*;
import org.netbeans.modules.web.spi.webmodule.*;
import org.openide.filesystems.FileObject;

/** A dummy provider that things that any *.foo file belongs to its web module.
 *
 * @author  Pavel Buzek
 */
public class CustomProvider implements WebModuleProvider {
    
    private HashMap cache = new HashMap ();
    
    public CustomProvider () {
    }
    
    public WebModule findWebModule (FileObject file) {
        if (file.getExt ().equals ("foo")) {
            WebModule wm  = (WebModule) cache.get (file.getParent ());
            if (wm == null) {
                wm = WebModuleFactory.createWebModule (new WM (file.getParent (), "/"+file.getParent ().getName (), WebModule.J2EE_14_LEVEL));
                cache.put (file.getParent (), wm);
            }
            return wm;
        }
        return null;
    }
    
    private class WM implements WebModuleImplementation {
        FileObject db;
        String cp;
        String ver;
        
        public WM (FileObject db, String cp, String ver) {
            this.db = db;
            this.cp = cp;
            this.ver = ver;
        }
        
        public String getContextPath () {
            return cp;
        }
        
        public FileObject getDocumentBase () {
            return db;
        }
        
        public String getJ2eePlatformVersion () {
            return ver;
        }
        
        public FileObject getDeploymentDescriptor () {
            return getWebInf ().getFileObject ("web.xml");
        }
        
        public FileObject getWebInf () {
            return getDocumentBase ().getFileObject ("WEB-INF");
        }
        
        public FileObject[] getJavaSources() {
            return null;
        }
        
    }
}
