/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.NewWebProjectNameLocationStepOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.NewProjectAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;

/**
 *
 * @author  lm97939
 */
public class WebProjectValidation13 extends WebProjectValidation {
    static {
        PROJECT_NAME = "SampleProject13"; // NOI18N
        PROJECT_FOLDER = PROJECT_LOCATION+File.separator+PROJECT_NAME;
    }
    
    /** Need to be defined because of JUnit */
    public WebProjectValidation13(String name) {
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        junit.textui.TestRunner.run(suite());
        // run only selected test case
        //junit.textui.TestRunner.run(new MyModuleValidation("testT2"));
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebProjectValidation13("testNewWebProject"));
        suite.addTest(new WebProjectValidation13("testNewJSP"));
        suite.addTest(new WebProjectValidation13("testNewJSP2"));
        suite.addTest(new WebProjectValidation13("testNewServlet"));
        suite.addTest(new WebProjectValidation13("testNewServlet2"));
        suite.addTest(new WebProjectValidation13("testBuildProject"));
        suite.addTest(new WebProjectValidation13("testCompileAllJSP"));
        suite.addTest(new WebProjectValidation13("testCompileJSP"));
        suite.addTest(new WebProjectValidation13("testCleanProject"));
        suite.addTest(new WebProjectValidation13("testRunProject"));
        suite.addTest(new WebProjectValidation13("testRunJSP"));
        suite.addTest(new WebProjectValidation13("testRunServlet"));
        suite.addTest(new WebProjectValidation13("testCreateTLD"));
        suite.addTest(new WebProjectValidation13("testCreateTagHandler"));
        suite.addTest(new WebProjectValidation13("testRunTag"));
        suite.addTest(new WebProjectValidation13("testNewHTML"));
        suite.addTest(new WebProjectValidation13("testRunHTML"));
        suite.addTest(new WebProjectValidation13("testNewSegment"));
        suite.addTest(new WebProjectValidation13("testNewDocument"));
        suite.addTest(new WebProjectValidation13("testStopTomcat"));
        suite.addTest(new WebProjectValidation13("testStartTomcat"));
        suite.addTest(new WebProjectValidation13("testFinish"));
        
        return suite;
    }
    
    /** Test creation of web project.
     * - open New Project wizard from main menu (File|New Project)
     * - select Web|Web Application
     * - in the next panel type project name and project location
     * - finish the wizard
     * - wait until scanning of java files is finished
     * - check index.jsp is opened
     */
    public void testNewWebProject() throws IOException {
        new NewProjectAction().perform();
        NewProjectWizardOperator projectWizard = new NewProjectWizardOperator();
        String sWeb = Bundle.getStringTrimmed(
                "org.netbeans.modules.web.core.Bundle",
                "Templates/JSP_Servlet");
        projectWizard.selectCategory(sWeb);
        String sWeb_Application = Bundle.getStringTrimmed(
                "org.netbeans.modules.web.project.ui.wizards.Bundle",
                "Templates/Project/Web/emptyWeb.xml");
        projectWizard.selectProject(sWeb_Application);
        projectWizard.next();
        NewWebProjectNameLocationStepOperator nameStep =
                new NewWebProjectNameLocationStepOperator();
        nameStep.txtProjectName().typeText(PROJECT_NAME);
        nameStep.txtProjectLocation().setText("");
        nameStep.txtProjectLocation().typeText(PROJECT_LOCATION);
        String sJ2EE_1_3 = Bundle.getStringTrimmed(
                "org.netbeans.modules.web.project.ui.wizards.Bundle",
                "J2EESpecLevel_13");
        nameStep.selectJ2EEVersion(sJ2EE_1_3);
        nameStep.finish();
        // wait for project creation
        new EditorWindowOperator().getEditor("index.jsp");//NOI18N
        ProjectSupport.waitScanFinished();
        // HACK
        Node webPages = new Node(new ProjectsTabOperator().
                getProjectRootNode(PROJECT_NAME),"Web Pages");
        new Node(webPages,"index.jsp");//NOI18N
        new Node(webPages,"WEB-INF|web.xml");//NOI18N
        new Node(webPages,"META-INF|context.xml");//NOI18N
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
    }
    
    protected String getTagHandlerCode() {
        return "try { JspWriter out = pageContext.getOut(); " +
                "out.print(\"TagOutput\");} catch (IOException e) {} \n";
    }
}
