/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web;

import java.io.File;
import java.util.Arrays;
import javax.swing.JComboBox;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.OptionsOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.modules.debugger.BreakpointsWindowOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;

/**
 *
 * @author  lm97939
 */
public class Util {
    
    /** Creates a new instance of Util */
    public Util() {
    }
    
    public static String dumpProjectView(String project) {
        // TODO replace sleep()
        try { Thread.currentThread().sleep(3000); }
        catch (InterruptedException e) {}
        StringBuffer buff = new StringBuffer();
        Node node = new ProjectsTabOperator().getProjectRootNode(project);
        dumpNode(node, buff, 0);
        return buff.toString();
    }
    
    
    private static void dumpNode(Node node, StringBuffer buff, int level) {
        for (int i=0; i<level; i++)
            buff.append(".");
        if (!node.isLeaf()) buff.append("+ ");
        else buff.append("- ");
        buff.append(node.getText());
        if (!node.isLeaf() && node.getText().indexOf('.') < 0) {
            buff.append(" ");
            boolean wasCollapsed = node.isCollapsed();
            buff.append("\n");
            String nodes[] = node.getChildren();
            for (int i=0; i<nodes.length; i++) {
                //XXX System.out.println("Parent:: " + node.getText() + " - subPath:: " + nodes[i]);
                Node child = new Node(node, nodes[i]);
                // prevents infinite loop in case the nodes[i].equals("");
                if (child.getPath().equals(node.getPath())) {
                    //XXX System.out.println("===Continue===");
                    continue;
                }
                dumpNode(child, buff,  level+1);
            }
            if (wasCollapsed) node.collapse();
        } else {
            buff.append("\n");
        }
    }
    
    public static String dumpFiles(File file) {
//        try { Thread.currentThread().sleep(3000); }
//        catch (InterruptedException e) {}
        StringBuffer buff = new StringBuffer();
        dumpFiles(file, buff, 0);
        return buff.toString();
    }
    
    private static void dumpFiles(File file, StringBuffer buff, int level) {
         for (int i=0; i<level; i++)
            buff.append(".");
         buff.append(file.getName());
         buff.append("\n");
         if (file.isDirectory()) {
             String files[] = file.list();
             Arrays.sort(files);
             for (int i=0; i<files.length; i++) {
                 dumpFiles(new File(file,files[i]), buff, level+1);
             }
         }
    }
    
    public static void setSwingBrowser() {
        // Set Swing HTML Browser as default browser
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.selectGeneral();
        // "Web Browser:"
        String webBrowserLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle",
                "CTL_Web_Browser");
        JLabelOperator jloWebBrowser = new JLabelOperator(optionsOper, webBrowserLabel);
        // "Swing HTML Browser"
        String swingBrowserLabel = Bundle.getString(
                "org.netbeans.core.ui.Bundle",
                "Services/Browsers/SwingBrowser.ser");
        new JComboBoxOperator((JComboBox)jloWebBrowser.getLabelFor()).
                selectItem(swingBrowserLabel);
        optionsOper.ok();
    }
    
    public static void deleteAllBreakpoints() {
        BreakpointsWindowOperator bwo = BreakpointsWindowOperator.invoke();
        bwo.deleteAll();
        bwo.close();
    }
    
    public static void stopTomcat() {
        getServerNode().stop();;
    }
    
    public static void startTomcat() {
        getServerNode().start();

    }
    
    private static final J2eeServerNode getServerNode() {
        RuntimeTabOperator.invoke();
        return new J2eeServerNode("Bundled Tomcat");
    }
}
