/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.struts.ui;

import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class StrutsConfigurationPanelVisual extends javax.swing.JPanel implements HelpCtx.Provider, DocumentListener {
    
    private StrutsConfigurationPanel panel;
    
    /** Creates new form StrutsConfigurationPanelVisual */
    public StrutsConfigurationPanelVisual(StrutsConfigurationPanel panel, boolean customizer) {
        this.panel = panel;
        initComponents();
        
        jTextFieldAppResource.getDocument().addDocumentListener(this);
        jCheckBoxWAR.setVisible(false);
        if (customizer) {
            jCheckBoxTLD.setVisible(false);
            //jCheckBoxWAR.setVisible(false);
            enableComponents(false);
        }        
        else {
            jCheckBoxTLD.setVisible(true);
            //jCheckBoxWAR.setVisible(true);
            enableComponents(true);
        }
        
        ((JTextComponent)jComboBoxURLPattern.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelServletName = new javax.swing.JLabel();
        jTextFieldServletName = new javax.swing.JTextField();
        jLabelURLPattern = new javax.swing.JLabel();
        jComboBoxURLPattern = new javax.swing.JComboBox();
        jLabelAppResource = new javax.swing.JLabel();
        jTextFieldAppResource = new javax.swing.JTextField();
        jCheckBoxTLD = new javax.swing.JCheckBox();
        jCheckBoxWAR = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        jLabelServletName.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MNE_ConfigPanel_ActionServletName_Mnemonic").charAt(0));
        jLabelServletName.setLabelFor(jTextFieldServletName);
        jLabelServletName.setText(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "LBL_ConfigPanel_ActionServletName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 12);
        add(jLabelServletName, gridBagConstraints);

        jTextFieldServletName.setEditable(false);
        jTextFieldServletName.setText("action");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jTextFieldServletName, gridBagConstraints);
        jTextFieldServletName.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/ui/Bundle").getString("ACSD_jTextFieldServletName"));

        jLabelURLPattern.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MNE_ConfigPanel_URLPattern_Mnemonic").charAt(0));
        jLabelURLPattern.setLabelFor(jComboBoxURLPattern);
        jLabelURLPattern.setText(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "LBL_ConfigPanel_URLPattern"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 12);
        add(jLabelURLPattern, gridBagConstraints);

        jComboBoxURLPattern.setEditable(true);
        jComboBoxURLPattern.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "*.do", "/do/*" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jComboBoxURLPattern, gridBagConstraints);
        jComboBoxURLPattern.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/ui/Bundle").getString("ACSD_jComboBoxURLPattern"));

        jLabelAppResource.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MNE_ConfigPanel_ApplicationResource_Mnemonic").charAt(0));
        jLabelAppResource.setLabelFor(jTextFieldAppResource);
        jLabelAppResource.setText(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "LBL_ConfigPanel_ApplicationResource"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 12);
        add(jLabelAppResource, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(jTextFieldAppResource, gridBagConstraints);
        jTextFieldAppResource.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/ui/Bundle").getString("ACSD_jTextFieldAppResource"));

        jCheckBoxTLD.setMnemonic(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MNE_ConfigPanel_InstallStrutsTLDs_Mnemonic").charAt(0));
        jCheckBoxTLD.setText(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "LBL_ConfigPanel_InstallStrutsTLDs"));
        jCheckBoxTLD.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxTLD.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jCheckBoxTLD, gridBagConstraints);
        jCheckBoxTLD.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/ui/Bundle").getString("ACSD_jCheckBoxTLD"));

        jCheckBoxWAR.setMnemonic(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MNE_ConfigPanel_PackageStrutsJars_Mnemonic").charAt(0));
        jCheckBoxWAR.setSelected(true);
        jCheckBoxWAR.setText(org.openide.util.NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "LBL_ConfigPanel_PackageStrutsJars"));
        jCheckBoxWAR.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxWAR.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        add(jCheckBoxWAR, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxTLD;
    private javax.swing.JCheckBox jCheckBoxWAR;
    private javax.swing.JComboBox jComboBoxURLPattern;
    private javax.swing.JLabel jLabelAppResource;
    private javax.swing.JLabel jLabelServletName;
    private javax.swing.JLabel jLabelURLPattern;
    private javax.swing.JTextField jTextFieldAppResource;
    private javax.swing.JTextField jTextFieldServletName;
    // End of variables declaration//GEN-END:variables
    
    boolean valid(WizardDescriptor wizardDescriptor) {
        String urlPattern = (String)jComboBoxURLPattern.getEditor().getItem();
        if (urlPattern == null || urlPattern.trim().equals("")){
          wizardDescriptor.putProperty("WizardPanel_errorMessage",                                  // NOI18N
                NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MSG_URLPatternIsEmpty"));  
          return false;
        }
        if (!isPatternValid(urlPattern)){
          wizardDescriptor.putProperty("WizardPanel_errorMessage",                                  // NOI18N
                NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MSG_URLPatternIsNotValid"));  
          return false;  
        }
        if (getAppResource() == null || getAppResource().trim().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage",                                  // NOI18N
                NbBundle.getMessage(StrutsConfigurationPanelVisual.class, "MSG_ApplicationResourceNotValid"));  
            return false;
        }
        if (wizardDescriptor != null)
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);                             // NOI18N
        return true;
    }

    private boolean isPatternValid(String pattern){
        if (pattern.startsWith("*.")){
            String p = pattern.substring(2);
            if (p.indexOf('.') == -1 && p.indexOf('*') == -1 
                    && p.indexOf('/') == -1 && !p.trim().equals(""))
                return true;
        }
        if (pattern.endsWith("/*") && pattern.startsWith("/"))
            return true;
        return false;
    }
    
    void validate (WizardDescriptor d) throws WizardValidationException {
//        projectLocationPanel.validate (d);
    }
    
    void read (WizardDescriptor d) {
//        projectLocationPanel.read(d);
//        optionsPanel.read(d);
    }

    void store(WizardDescriptor d) {
//        projectLocationPanel.store(d);
//        optionsPanel.store(d);
    }
    
    void enableComponents(boolean enable) {
        jComboBoxURLPattern.setEnabled(enable);
        jTextFieldAppResource.setEnabled(enable);
        jTextFieldServletName.setEnabled(enable);
        jCheckBoxTLD.setEnabled(enable);
        jCheckBoxWAR.setEnabled(enable);
        jLabelAppResource.setEnabled(enable);
        jLabelServletName.setEnabled(enable);
        jLabelURLPattern.setEnabled(enable);
                
    }

    public String getURLPattern(){
        return (String)jComboBoxURLPattern.getSelectedItem();
    }
    
    public void setURLPattern(String pattern){
        jComboBoxURLPattern.setSelectedItem(pattern);
    }
    
    public String getServletName(){
        return jTextFieldServletName.getText();
    }
    
    public void setServletName(String name){
        jTextFieldServletName.setText(name);
    }
    
    public String getAppResource(){
        return jTextFieldAppResource.getText();
    }
    
    public void setAppResource(String resource){
        jTextFieldAppResource.setText(resource);
    }
    
    public boolean addTLDs(){
        return jCheckBoxTLD.isSelected();
    }
    
    public boolean packageWars(){
        return jCheckBoxWAR.isSelected();
    }
    /** Help context where to find more about the paste type action.
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(StrutsConfigurationPanelVisual.class);
    }

    public void removeUpdate(javax.swing.event.DocumentEvent e) {
        panel.fireChangeEvent();
    }

    public void insertUpdate(javax.swing.event.DocumentEvent e) {
        panel.fireChangeEvent();
    }

    public void changedUpdate(javax.swing.event.DocumentEvent e) {
        panel.fireChangeEvent();
    }

}
