/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.struts.dialogs;

import java.io.IOException;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.common.FQNSearch;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.config.model.FormBean;
import org.openide.util.NbBundle;

/**
 *
 * @author  Milan Kuchtiak
 */
public class AddFormBeanPanel extends javax.swing.JPanel implements ValidatingPanel {
    
    private StrutsConfigDataObject config;
    private Hashtable beanNames;
    /** Creates new form AddFormBeanPanel */
    public AddFormBeanPanel(StrutsConfigDataObject config) {
        initComponents();
        this.config = config;
        beanNames = null;
    }

    public String validatePanel() {
        //config.getStrutsConfig().getFormBeans().sizeFormBean()
        if (getFormName().length()==0)
            return NbBundle.getMessage(AddFormBeanPanel.class,"MSG_EmptyFormName");
        if (beanNames == null){
            System.out.println("vytvarim cashe of jmen");
            beanNames = new Hashtable();
            try {
                FormBean[] beans = config.getStrutsConfig().getFormBeans().getFormBean();
                for (int i = 0; i < beans.length; i++){
                    beanNames.put(beans[i].getAttributeValue("name"), "");
                }
            } catch (IOException ex) {
                // don't cashe
            }
        }
        if (beanNames.get(getFormName()) != null)
            return NbBundle.getMessage(AddFormBeanPanel.class,"MSG_BeanNameDefined");
        if (jRadioButton1.isSelected() && TFBeanClass.getText().trim().length()==0)
            return NbBundle.getMessage(AddFormBeanPanel.class,"MSG_EmptyFormBeanClass");
        return null;
    }

    public javax.swing.AbstractButton[] getStateChangeComponents() {
        return new javax.swing.AbstractButton[]{ jRadioButton1 };
    }

    public javax.swing.text.JTextComponent[] getDocumentChangeComponents() {
        return new javax.swing.text.JTextComponent[]{TFBeanClass, TFFormName};
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabelFormName = new javax.swing.JLabel();
        CBDynamic = new javax.swing.JComboBox();
        TFBeanClass = new javax.swing.JTextField();
        jButtonBrowse = new javax.swing.JButton();
        TFFormName = new javax.swing.JTextField();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_AddFormBeanPanel"));
        jLabelFormName.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_FormName_mnem").charAt(0));
        jLabelFormName.setLabelFor(TFFormName);
        jLabelFormName.setText(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_FormName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabelFormName, gridBagConstraints);

        CBDynamic.setEditable(true);
        CBDynamic.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "org.apache.struts.action.DynaActionForm", "org.apache.struts.validator.DynaValidatorForm", "org.apache.struts.validator.DynaValidatorActionForm" }));
        CBDynamic.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(CBDynamic, gridBagConstraints);
        CBDynamic.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_CVBDynamic"));

        TFBeanClass.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(TFBeanClass, gridBagConstraints);
        TFBeanClass.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSN_TFBeanClass"));
        TFBeanClass.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_TFBeanClass"));

        jButtonBrowse.setMnemonic(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_Browse_mnem").charAt(0));
        jButtonBrowse.setText(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_BrowseButton"));
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });
        jButtonBrowse.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                jButtonBrowseComponentHidden(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
        add(jButtonBrowse, gridBagConstraints);
        jButtonBrowse.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jButtonBrowseClass"));

        TFFormName.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(TFFormName, gridBagConstraints);
        TFFormName.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_TFFormName"));

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setMnemonic(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_FormBeanClass_mnem").charAt(0));
        jRadioButton1.setSelected(true);
        jRadioButton1.setText(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_FormBeanClass"));
        jRadioButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioButton1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButton1ItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jRadioButton1, gridBagConstraints);
        jRadioButton1.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButton1"));

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setMnemonic(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_DYNAMIC_mnem").charAt(0));
        jRadioButton2.setText(org.openide.util.NbBundle.getMessage(AddFormBeanPanel.class, "LBL_DYNAMIC"));
        jRadioButton2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButton2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jRadioButton2, gridBagConstraints);
        jRadioButton2.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButton2"));

    }
    // </editor-fold>//GEN-END:initComponents

    private void jButtonBrowseComponentHidden(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jButtonBrowseComponentHidden
    }//GEN-LAST:event_jButtonBrowseComponentHidden

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
    SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                FQNSearch.showFastOpen(TFBeanClass);
            }
        });

    }//GEN-LAST:event_jButtonBrowseActionPerformed

    private void jRadioButton1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioButton1ItemStateChanged
// TODO add your handling code here:
        boolean selected = jRadioButton1.isSelected();
        TFBeanClass.setEditable(selected);
        CBDynamic.setEnabled(!selected);
    }//GEN-LAST:event_jRadioButton1ItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox CBDynamic;
    private javax.swing.JTextField TFBeanClass;
    private javax.swing.JTextField TFFormName;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JLabel jLabelFormName;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    // End of variables declaration//GEN-END:variables
    
    public String getFormBeanClass() {
        return jRadioButton1.isSelected()?TFBeanClass.getText().trim():(String)CBDynamic.getSelectedItem();
    }

    public String getFormName() {
        return (String)TFFormName.getText().trim();
    }
    
}
