/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.struts.dialogs;

import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.common.FQNSearch;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.config.model.Action;
import org.netbeans.modules.web.struts.config.model.MessageResources;
import org.openide.util.NbBundle;

/**
 *
 * @author  radko
 */
public class AddExceptionDialogPanel extends javax.swing.JPanel implements ValidatingPanel {
    private static final String DEFAULT_BUNDLE_KEY="org.apache.struts.Globals.MESSAGES_KEY"; //NOI18N
    StrutsConfigDataObject config;
    /** Creates new form AddForwardDialog */
    public AddExceptionDialogPanel(StrutsConfigDataObject config, String targetActionPath) {
        this.config=config;
        initComponents();
        List actions = StrutsConfigUtilities.getAllActionsInModule(config);
        DefaultComboBoxModel model = (DefaultComboBoxModel)jComboBoxCallAction.getModel();
        DefaultComboBoxModel model1 = (DefaultComboBoxModel)jComboBoxActionExc.getModel();
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            String actionPath=((Action)iter.next()).getAttributeValue("path"); //NOI18N
            model.addElement(actionPath);
            model1.addElement(actionPath);
        }
        List messageResources = StrutsConfigUtilities.getAllMessageResourcesInModule(config);
        model = (DefaultComboBoxModel)jComboBoxBundleKey.getModel();
        iter = messageResources.iterator();
        while (iter.hasNext()) {
            String key=((MessageResources)iter.next()).getAttributeValue("key"); //NOI18N
            model.addElement(key==null?DEFAULT_BUNDLE_KEY:key); //NOI18N
        }
        if (targetActionPath != null) {
            jRadioButtonActionExc.setSelected(true);
            jComboBoxActionExc.setSelectedItem(targetActionPath);
        }
    }
    
    public AddExceptionDialogPanel(StrutsConfigDataObject config) {
        this(config, null);
    }

    public javax.swing.AbstractButton[] getStateChangeComponents() {
        return new javax.swing.AbstractButton[]{jRadioButtonResFile, jRadioButtonGlobalExc};
    }

    public JTextComponent[] getDocumentChangeComponents() {
        return new JTextComponent[]{jTextFieldExcKey, jTextFieldResFile, (JTextComponent)jComboBoxExcType.getEditor().getEditorComponent()};
    }

    public String validatePanel() {
        if (getExceptionKey().length()==0)
            return NbBundle.getMessage(AddExceptionDialogPanel.class,"MSG_EmptyExcKey");
        if (getExceptionType().length()==0)
            return NbBundle.getMessage(AddExceptionDialogPanel.class,"MSG_EmptyExcType");
        if (jRadioButtonResFile.isSelected()) {
            String resourceFile = jTextFieldResFile.getText().trim();
            if (resourceFile.length()==0 || resourceFile.equals("/")) //NOI18N
                return NbBundle.getMessage(AddExceptionDialogPanel.class,"MSG_EmptyResourceFile");
        } else if (jComboBoxCallAction.getSelectedItem()==null) {
            return NbBundle.getMessage(AddExceptionDialogPanel.class,"MSG_EmptyAction");
        }
        if (!jRadioButtonGlobalExc.isSelected() && jComboBoxActionExc.getSelectedItem()==null) {
            return NbBundle.getMessage(AddExceptionDialogPanel.class,"MSG_EmptyAction");
        }
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        buttonGroup3 = new javax.swing.ButtonGroup();
        jLabelBundleKey = new javax.swing.JLabel();
        jComboBoxBundleKey = new javax.swing.JComboBox();
        jLabelExcKey = new javax.swing.JLabel();
        jComboBoxExcType = new javax.swing.JComboBox();
        jLabelExcType = new javax.swing.JLabel();
        jTextFieldExcKey = new javax.swing.JTextField();
        jButtonExcType = new javax.swing.JButton();
        jLabelCall = new javax.swing.JLabel();
        jRadioButtonResFile = new javax.swing.JRadioButton();
        jTextFieldResFile = new javax.swing.JTextField();
        jButtonBrowse = new javax.swing.JButton();
        jRadioButtonCallAction = new javax.swing.JRadioButton();
        jComboBoxCallAction = new javax.swing.JComboBox();
        jLabelScope = new javax.swing.JLabel();
        jLabelLocation = new javax.swing.JLabel();
        jRadioButtonGlobalExc = new javax.swing.JRadioButton();
        jRadioButtonActionExc = new javax.swing.JRadioButton();
        jComboBoxActionExc = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        jRadioButtonSession = new javax.swing.JRadioButton();
        jRadioButtonRequest = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_AddExceptionDialogPanel"));
        jLabelBundleKey.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_BundleKey").charAt(0));
        jLabelBundleKey.setLabelFor(jComboBoxBundleKey);
        jLabelBundleKey.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_Bundle Key"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 12);
        add(jLabelBundleKey, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jComboBoxBundleKey, gridBagConstraints);
        jComboBoxBundleKey.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jComboBoxBundleKey"));

        jLabelExcKey.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_ExcKey").charAt(0));
        jLabelExcKey.setLabelFor(jTextFieldExcKey);
        jLabelExcKey.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_ExcKey"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 12);
        add(jLabelExcKey, gridBagConstraints);

        jComboBoxExcType.setEditable(true);
        jComboBoxExcType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "java.lang.NumberFormatException", "java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.StringIndexOutOfBoundsException", "java.lang.RuntimeException", "java.lang.Exception" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        add(jComboBoxExcType, gridBagConstraints);
        jComboBoxExcType.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jComboBoxExcType"));

        jLabelExcType.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_ExcType").charAt(0));
        jLabelExcType.setLabelFor(jComboBoxExcType);
        jLabelExcType.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_ExcType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 12);
        add(jLabelExcType, gridBagConstraints);

        jTextFieldExcKey.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jTextFieldExcKey, gridBagConstraints);
        jTextFieldExcKey.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jTextFieldExcKey"));

        jButtonExcType.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddFwdDialog_Browse").charAt(0));
        jButtonExcType.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_BrowseButton"));
        jButtonExcType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonExcTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 0);
        add(jButtonExcType, gridBagConstraints);
        jButtonExcType.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jButtonExcType"));

        jLabelCall.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_Call"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jLabelCall, gridBagConstraints);

        buttonGroup1.add(jRadioButtonResFile);
        jRadioButtonResFile.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddFwdDialog_ResFile").charAt(0));
        jRadioButtonResFile.setSelected(true);
        jRadioButtonResFile.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "RB_ResourceFile"));
        jRadioButtonResFile.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonResFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioButtonResFile.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButtonResFileItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 12);
        add(jRadioButtonResFile, gridBagConstraints);
        jRadioButtonResFile.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonResFile"));

        jTextFieldResFile.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jTextFieldResFile, gridBagConstraints);
        jTextFieldResFile.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSN_jTextFieldResFile"));
        jTextFieldResFile.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jTextFieldResFile"));

        jButtonBrowse.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_ResFileBrowse").charAt(0));
        jButtonBrowse.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_BrowseButton"));
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 0);
        add(jButtonBrowse, gridBagConstraints);
        jButtonBrowse.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jButtonBrowse"));

        buttonGroup1.add(jRadioButtonCallAction);
        jRadioButtonCallAction.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddFwdDialog_FwdAction").charAt(0));
        jRadioButtonCallAction.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "RB_Action"));
        jRadioButtonCallAction.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCallAction.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 10, 12);
        add(jRadioButtonCallAction, gridBagConstraints);
        jRadioButtonCallAction.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonCallAction"));

        jComboBoxCallAction.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        add(jComboBoxCallAction, gridBagConstraints);
        jComboBoxCallAction.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jComboBoxCallAction"));

        jLabelScope.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_Scope"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        add(jLabelScope, gridBagConstraints);

        jLabelLocation.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddFwdDialog_Location"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jLabelLocation, gridBagConstraints);

        buttonGroup3.add(jRadioButtonGlobalExc);
        jRadioButtonGlobalExc.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_GlobalExc").charAt(0));
        jRadioButtonGlobalExc.setSelected(true);
        jRadioButtonGlobalExc.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_GlobalExc"));
        jRadioButtonGlobalExc.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonGlobalExc.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jRadioButtonGlobalExc.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButtonGlobalExcItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 12);
        add(jRadioButtonGlobalExc, gridBagConstraints);
        jRadioButtonGlobalExc.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonGlobalExc"));

        buttonGroup3.add(jRadioButtonActionExc);
        jRadioButtonActionExc.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_ActionExc").charAt(0));
        jRadioButtonActionExc.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_ActionExc"));
        jRadioButtonActionExc.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonActionExc.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 12);
        add(jRadioButtonActionExc, gridBagConstraints);
        jRadioButtonActionExc.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonActionExc"));

        jComboBoxActionExc.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jComboBoxActionExc, gridBagConstraints);
        jComboBoxActionExc.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jComboBoxActionExc"));

        buttonGroup2.add(jRadioButtonSession);
        jRadioButtonSession.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_Session").charAt(0));
        jRadioButtonSession.setSelected(true);
        jRadioButtonSession.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_Session"));
        jRadioButtonSession.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonSession.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRadioButtonSession);
        jRadioButtonSession.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonSession"));

        buttonGroup2.add(jRadioButtonRequest);
        jRadioButtonRequest.setMnemonic(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "MNE_AddExcDialog_Request").charAt(0));
        jRadioButtonRequest.setText(org.openide.util.NbBundle.getMessage(AddExceptionDialogPanel.class, "LBL_AddExcDialog_Request"));
        jRadioButtonRequest.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonRequest.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRadioButtonRequest);
        jRadioButtonRequest.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle").getString("ACSD_jRadioButtonReques"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        add(jPanel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void jRadioButtonGlobalExcItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioButtonGlobalExcItemStateChanged
// TODO add your handling code here:
        jComboBoxActionExc.setEnabled(!jRadioButtonGlobalExc.isSelected());
    }//GEN-LAST:event_jRadioButtonGlobalExcItemStateChanged

    private void jRadioButtonResFileItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioButtonResFileItemStateChanged
// TODO add your handling code here:
        boolean selected = jRadioButtonResFile.isSelected();
        jTextFieldResFile.setEditable(selected);
        jButtonBrowse.setEnabled(selected);
        jComboBoxCallAction.setEnabled(!selected);
    }//GEN-LAST:event_jRadioButtonResFileItemStateChanged

    private void jButtonExcTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonExcTypeActionPerformed
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                FQNSearch.showFastOpen((JTextComponent)jComboBoxExcType.getEditor().getEditorComponent());
            }
        });
    }//GEN-LAST:event_jButtonExcTypeActionPerformed

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
// TODO add your handling code here:
        try{
        org.netbeans.api.project.SourceGroup[] groups = StrutsConfigUtilities.getDocBaseGroups(config.getPrimaryFile());
            org.openide.filesystems.FileObject fo = BrowseFolders.showDialog(groups);
            if (fo!=null) {
                String res = "/"+StrutsConfigUtilities.getResourcePath(groups,fo,'/',true);
                jTextFieldResFile.setText(res);
            }
        } catch (java.io.IOException ex) {}
    }//GEN-LAST:event_jButtonBrowseActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.ButtonGroup buttonGroup3;
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonExcType;
    private javax.swing.JComboBox jComboBoxActionExc;
    private javax.swing.JComboBox jComboBoxBundleKey;
    private javax.swing.JComboBox jComboBoxCallAction;
    private javax.swing.JComboBox jComboBoxExcType;
    private javax.swing.JLabel jLabelBundleKey;
    private javax.swing.JLabel jLabelCall;
    private javax.swing.JLabel jLabelExcKey;
    private javax.swing.JLabel jLabelExcType;
    private javax.swing.JLabel jLabelLocation;
    private javax.swing.JLabel jLabelScope;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButtonActionExc;
    private javax.swing.JRadioButton jRadioButtonCallAction;
    private javax.swing.JRadioButton jRadioButtonGlobalExc;
    private javax.swing.JRadioButton jRadioButtonRequest;
    private javax.swing.JRadioButton jRadioButtonResFile;
    private javax.swing.JRadioButton jRadioButtonSession;
    private javax.swing.JTextField jTextFieldExcKey;
    private javax.swing.JTextField jTextFieldResFile;
    // End of variables declaration//GEN-END:variables

    public String getResourceBundle() {
        String key = (String)jComboBoxBundleKey.getSelectedItem();
        return DEFAULT_BUNDLE_KEY.equals(key)?null:key;
    }
    
    public String getExceptionKey() {
        String key = jTextFieldExcKey.getText().trim();
        return key==null?null:key;
    }
    
    public String getExceptionType() {
        javax.swing.text.Document doc = ((JTextComponent)jComboBoxExcType.getEditor().getEditorComponent()).getDocument();
        try {
            String exceptionType = doc.getText(0,doc.getLength());
            return exceptionType==null?null:exceptionType;
        } catch (javax.swing.text.BadLocationException ex) {
            return null;
        }
    }
    
    public String getScope() {
        return (jRadioButtonSession.isSelected()?null:"request"); //NOI18N
    }
    
    public String getForwardTo() {
        if (jRadioButtonResFile.isSelected()) {
            return jTextFieldResFile.getText().trim();
        } else {
            return (String)jComboBoxCallAction.getSelectedItem();
        }
    }

    public boolean isGlobal() {
        return jRadioButtonGlobalExc.isSelected();
    }
    
    public String getLocationAction() {
        return (String)jComboBoxActionExc.getSelectedItem();
    }
    
}
