/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.web.api.webmodule.WebFrameworkSupport;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;

import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesView;
import org.openide.filesystems.FileChangeListener;

import org.netbeans.modules.web.project.ProjectWebModule;
import org.openide.util.actions.CookieAction;
import org.openide.util.HelpCtx;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class WebViews {
        
    private WebViews() {
    }
    
    static final class LogicalViewChildren extends Children.Keys/*<FileObject>*/ implements ChangeListener {
        
        // XXX does not react correctly to addition or removal of src/ subdir

        private static final String KEY_SOURCE_DIR = "srcDir"; // NOI18N
        private static final String KEY_TEST_DIR = "testDir"; // NOI18N
        private static final String KEY_DOC_BASE = "docBase"; //NOI18N
        private static final String KEY_SERVICE_REFS = "serviceRefs"; // NOI18N
        private static final String WEBSERVICES_DIR = "webservicesDir"; // NOI18N
        private static final String KEY_SETUP_DIR = "setupDir"; //NOI18N
        private static final String KEY_CONF_FILES = "confFiles"; //NOI18N
        private static final String KEY_LIBRARIES = "libraries"; //NOI18N
        private static final String KEY_TEST_LIBRARIES = "testLibraries"; //NOI18N
        
        private static final String JAX_WS_PATH="nbproject/jax-ws.xml"; //NOI18N
        
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final UpdateHelper updateHelper;
        private final ReferenceHelper refHelper;        
        private final Project project;
	private WebInfListener webInfListener;	
        private WsdlCreationListener wsdlListener;
        private final FileObject projectDir;
        private FileChangeListener fcl;
        private JaxWsChangeListener jaxWsListener;
        private JaxRPCChangeListener jaxrpcChangeListener;
        private FileObject wsdlFolder;
                
        public LogicalViewChildren (Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
            assert project != null;
            this.project = project;
            assert updateHelper != null;
            this.updateHelper = updateHelper;
            this.helper = updateHelper.getAntProjectHelper();
            assert evaluator != null;
            this.evaluator = evaluator;
            assert refHelper != null;
            this.refHelper = refHelper;
            webInfListener = new WebInfListener();
            wsdlListener = new WsdlCreationListener();
            jaxWsListener = new JaxWsChangeListener();
            jaxrpcChangeListener = new JaxRPCChangeListener();
            projectDir = helper.getProjectDirectory();
        }
        
        protected void addNotify() {
            super.addNotify();
            fcl = new ProjectDirectoryListener();
            
            projectDir.addFileChangeListener(fcl);
            
            JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel!=null) jaxWsModel.addPropertyChangeListener(jaxWsListener);
            
            Sources sources = getSources();
            if (sources != null)
                sources.addChangeListener( this );
            WebModule wm = WebModule.getWebModule(project.getProjectDirectory());
            if (wm != null) {
                FileObject webInf = wm.getWebInf();
                if (webInf!=null) {
                    webInf.addFileChangeListener(webInfListener);
                    webInf.addFileChangeListener(jaxrpcChangeListener);
                }
            }
            WebServicesClientSupport wsClientSupportImpl = WebServicesClientSupport.getWebServicesClientSupport(projectDir);
            FileObject wsdlDir = null;
            try {
                wsdlDir = wsClientSupportImpl.getWsdlFolder(false);
                if (wsdlDir!=null) wsdlFolder = wsdlDir;
            } catch (IOException ex) {
                ex.printStackTrace();
            }
            if (wsdlFolder != null) {
                wsdlFolder.addFileChangeListener(wsdlListener);
            }
            buildKeys();
        }
        
        private void buildKeys() {
            List l = new ArrayList();
            DataFolder docBaseDir = getFolder(WebProjectProperties.WEB_DOCBASE_DIR);
            if (docBaseDir != null) {
                l.add(KEY_DOC_BASE);
            }

            // show WS and WSClient nodes only if there are any web services in the project
            JAXWSSupport jwss = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
            JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            if ((jwss != null) && 
                (jaxWsModel != null) && 
                (jaxWsModel.getServices() != null) && 
                (jaxWsModel.getServices().length > 0)) {
                    l.add(WEBSERVICES_DIR);
            } else {
                WebServicesSupport wss = WebServicesSupport.getWebServicesSupport(project.getProjectDirectory());
                if (wss != null) {
                    List wServices = wss.getServices();
                    if ((wServices != null)  && (!wServices.isEmpty())) {
                        l.add(WEBSERVICES_DIR);
                    }
                }
            }
            JAXWSClientSupport jwcss = JAXWSClientSupport.getJaxWsClientSupport(project.getProjectDirectory());
            if ((jwcss != null) &&
                (jaxWsModel != null) && 
                (jaxWsModel.getClients() != null) && 
                (jaxWsModel.getClients().length > 0)) {
                    l.add(KEY_SERVICE_REFS);
            } else {
                WebServicesClientSupport wscs = WebServicesClientSupport.getWebServicesClientSupport(project.getProjectDirectory());
                if (wscs != null) {
                    List wsClients = wscs.getServiceClients();
                    if ((wsClients != null)  && (!wsClients.isEmpty())) {
                        l.add(KEY_SERVICE_REFS);
                    }
                }
            }
            
//            DataFolder srcDir = getFolder(WebProjectProperties.SRC_DIR);
//            if (srcDir != null) {
//                l.add(KEY_SOURCE_DIR);
//            }
            
            l.add(KEY_CONF_FILES);
            
            l.add(KEY_SETUP_DIR);
            
            l.addAll(getKeys());
            
            l.add(KEY_LIBRARIES);
            l.add(KEY_TEST_LIBRARIES);
            
            setKeys(l);
        }
        
        protected void removeNotify() {
            WebModule wm = WebModule.getWebModule(project.getProjectDirectory());
            if (wm != null) {
                FileObject webInf = wm.getWebInf();
                if (webInf!=null) {
                    webInf.removeFileChangeListener(webInfListener);
                    webInf.removeFileChangeListener(jaxrpcChangeListener);
                }
            }

            if (wsdlFolder != null) {
                wsdlFolder.removeFileChangeListener(wsdlListener);
            }
            setKeys(Collections.EMPTY_SET);
            projectDir.removeFileChangeListener(fcl);
            
            JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel!=null) jaxWsModel.removePropertyChangeListener(jaxWsListener);
            
            Sources sources = getSources();
            if (sources != null)
                sources.removeChangeListener( this );
            super.removeNotify();
        }
        
        protected Node[] createNodes(Object key) {
            Node n = null;
            if (key instanceof SourceGroupKey) {
                n = new PackageViewFilterNode(((SourceGroupKey) key).group, project);
            } else if (key == KEY_CONF_FILES) {
                n = new ConfFilesNode(project);
            } else if (key == KEY_DOC_BASE) {
                n = new DocBaseNode (getFolder(WebProjectProperties.WEB_DOCBASE_DIR), project);
            } else if (key == WEBSERVICES_DIR){
                if (project instanceof WebProject) {
                    WebModule wm = WebModule.getWebModule(project.getProjectDirectory());

                    java.util.Map properties = ((WebProject)project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                    String serverInstance = (String)properties.get("j2ee.server.instance"); //NOI18N
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                    boolean jwsdpSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JWSDP); 
                    boolean wsitSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSIT); 
                    boolean jsr109Supported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JSR109);
                    boolean jsr109OldSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSCOMPILE);

                    if (wm!=null && ((WebModule.JAVA_EE_5_LEVEL.equals(wm.getJ2eePlatformVersion())) 
                                   || (jwsdpSupported)
                                   || (wsitSupported)
                                   || (!jsr109Supported && !jsr109OldSupported))) {
                        JAXWSView view = JAXWSView.getJAXWSView();
                        n = view.createJAXWSView(project);
                    } else {
                        // XXX should not cast a Project to anything else, see ProjectManager.findDefault() for explanation
                        WebProject webProject = (WebProject)project;
                        FileObject srcs [] = webProject.getSourceRoots().getRoots();
                        if (srcs != null && srcs.length > 0) {
                            WebServicesView webServicesView = WebServicesView.getWebServicesView(srcs[0]);
                            if(webServicesView != null) {
                                n = webServicesView.createWebServicesView(srcs[0]);
                            }
                        }
                    }
                }
            }
            else if (key == KEY_LIBRARIES) {
                n = new LibrariesNode(
                    NbBundle.getMessage(WebViews.class, "CTL_LibrariesNode"),
                    project,
                    evaluator, 
                    updateHelper, 
                    refHelper, 
                    WebProjectProperties.JAVAC_CLASSPATH,
                    new String[] { WebProjectProperties.BUILD_CLASSES_DIR }, 
                    "platform.active", //NOI18N
                    WebProjectProperties.J2EE_SERVER_INSTANCE, 
                    new Action[] {
                        LibrariesNode.createAddProjectAction(project, WebProjectProperties.JAVAC_CLASSPATH, WebProjectProperties.TAG_WEB_MODULE_LIBRARIES),
                        LibrariesNode.createAddLibraryAction(project, updateHelper.getAntProjectHelper(), WebProjectProperties.JAVAC_CLASSPATH, WebProjectProperties.TAG_WEB_MODULE_LIBRARIES),
                        LibrariesNode.createAddFolderAction(project, WebProjectProperties.JAVAC_CLASSPATH, WebProjectProperties.TAG_WEB_MODULE_LIBRARIES),
                        null,
                        new PreselectPropertiesAction(project, "Libraries", CustomizerLibraries.COMPILE), //NOI18N
                    },
                    WebProjectProperties.TAG_WEB_MODULE_LIBRARIES
                ); 
            }
            else if (key == KEY_TEST_LIBRARIES) {
                n = new LibrariesNode(
                    NbBundle.getMessage(WebViews.class, "CTL_TestLibrariesNode"),
                    project,
                    evaluator, 
                    updateHelper, 
                    refHelper, 
                    WebProjectProperties.JAVAC_TEST_CLASSPATH,
                    new String[] { 
                        WebProjectProperties.BUILD_TEST_CLASSES_DIR,
                        WebProjectProperties.JAVAC_CLASSPATH,
                        WebProjectProperties.BUILD_CLASSES_DIR,
                    }, 
                    null, 
                    null, 
                    new Action[] {
                        LibrariesNode.createAddProjectAction(project, WebProjectProperties.JAVAC_TEST_CLASSPATH, null),
                        LibrariesNode.createAddLibraryAction(project, updateHelper.getAntProjectHelper(), WebProjectProperties.JAVAC_TEST_CLASSPATH, null),
                        LibrariesNode.createAddFolderAction(project, WebProjectProperties.JAVAC_TEST_CLASSPATH, null),
                        null,
                        new PreselectPropertiesAction(project, "Libraries", CustomizerLibraries.COMPILE_TESTS), //NOI18N
                    },
                    null
                ); 
            }
            else if (key == KEY_SETUP_DIR) {
                n = J2eeProjectView.createServerResourcesNode(project);
            } else if (key == KEY_SERVICE_REFS) {

                java.util.Map properties = ((WebProject)project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String serverInstance = (String)properties.get("j2ee.server.instance"); //NOI18N
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                boolean jwsdpSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JWSDP); 
                boolean wsitSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSIT); 
                boolean jsr109Supported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JSR109); 
                boolean jsr109OldSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSCOMPILE);
                
                WebModule wm = WebModule.getWebModule(project.getProjectDirectory());
                if (wm!=null && ((WebModule.JAVA_EE_5_LEVEL.equals(wm.getJ2eePlatformVersion())) 
                                 || (jwsdpSupported)
                                 || (wsitSupported)
                                 || (!jsr109Supported && !jsr109OldSupported))) {
                    JAXWSClientView view = JAXWSClientView.getJAXWSClientView();
                    n = view.createJAXWSClientView(project);
                } else {             
                    // !PW FIXME This needs to be a stable way to retrieve a FileObject, e.g. for WEB-INF
                    // (or we could use some other type) that will uniquely define the WebServicesClientView
                    // we want to retrieve.
                    FileObject clientRoot = getFileObject(WebProjectProperties.WEB_DOCBASE_DIR);
                    if (clientRoot == null) {
                        clientRoot = getFileObject(WebProjectProperties.SRC_DIR);
                    }
                    if (clientRoot != null) {
                        WebServicesClientView clientView = WebServicesClientView.getWebServicesClientView(clientRoot);
                        if (clientView != null) {
                            // !PW FIXME Is there a better way to do this?  The interface
                            // I want is implemented by ProjectWebModule. This is the cleanest
                            // way I know to get it, but it seems like there should be a
                            // far more efficient way to retrieve that object from here.
                            //

                            // Only display this node if there is a WSDL folder containing at least one wsdl file

                            if (wsdlFolder != null) {
                                FileObject[] children = wsdlFolder.getChildren();
                                boolean foundWsdl = false;
                                for (int i=0;i<children.length;i++) {
                                    if (children[i].getExt().equalsIgnoreCase("wsdl")) { //NOI18N
                                        foundWsdl=true;
                                        break;
                                    }
                                }
                                if (foundWsdl) {
                                    n = clientView.createWebServiceClientView(wsdlFolder);
                                }
                            }
                        }
                    }
                }
            }
			
            return n == null ? new Node[0] : new Node[] {n};
        }
        
        private FileObject getFileObject(String propName) {
            String foName = evaluator.getProperty (propName);
            if (foName == null) {
                return null;
            }
            FileObject fo = helper.resolveFileObject(foName);
            // when the project is deleted externally, the sources change could
            // trigger a call to thid method before the project directory is 
            // notified about the deletion - invalid FileObject-s could be returned
            return fo != null && fo.isValid() ? fo : null;
        }
		
        private DataFolder getFolder(String propName) {
            FileObject fo = getFileObject(propName);
            if (fo != null) {
                DataFolder df = DataFolder.findFolder(fo);
                return df;
            }
            return null;
        }
		
        public void stateChanged( ChangeEvent e ) {
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    buildKeys();
                }
            });          
        }

        // Private methods -----------------------------------------------------
        
        private Collection getKeys() {
            //#60800, #61584 - when the project is deleted externally do not try to create children, the source groups
            //are not valid
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }            
            Sources sources = getSources();
            if (sources != null) {
                SourceGroup[] groups = sources.getSourceGroups( JavaProjectConstants.SOURCES_TYPE_JAVA );
                List result = new ArrayList(groups.length);
                for (int i = 0; i < groups.length; i++) {
                    result.add(new SourceGroupKey(groups[i]));
                }
                return result;
            } else {
                return Collections.EMPTY_LIST;
            }
        }
        
        private Sources getSources() {
            return ProjectUtils.getSources(project);
        }
        
        private static class SourceGroupKey {

            public final SourceGroup group;
            public final FileObject fileObject;

            SourceGroupKey( SourceGroup group ) {
                this.group = group;
                this.fileObject = group.getRootFolder();
            }

            public int hashCode() {
                return fileObject.hashCode();
            }

            public boolean equals( Object obj ) {
                if ( !(obj instanceof SourceGroupKey) ) {
                    return false;
                }
                else {
                    SourceGroupKey otherKey = (SourceGroupKey)obj;
                    String thisDisplayName = this.group.getDisplayName();
                    String otherDisplayName = otherKey.group.getDisplayName ();
                    return fileObject.equals(otherKey.fileObject ) &&
                         thisDisplayName == null ?  otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
                }
            }
        }
        
        
        private final class WsdlCreationListener extends FileChangeAdapter {

            public void fileDataCreated (FileEvent fe) {
                if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) { //NOI18N
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }
            
            public void fileDeleted (FileEvent fe) {
                if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) { //NOI18N
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }

        private final class JaxRPCChangeListener extends FileChangeAdapter {

            String webservicesFile = "webservices.xml";
            public void fileDataCreated (FileEvent fe) {
                if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            buildKeys();
                        }
                    });
                }
            }
            
            public void fileDeleted (FileEvent fe) {
                if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            buildKeys();
                        }
                    });
                }
            }

            public void fileChanged(FileEvent fe) {
                if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            buildKeys();
                        }
                    });
                }
            }
        }

        private final class JaxWsChangeListener implements PropertyChangeListener {
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        buildKeys();
                    }
                });
            }
        }
        
        private final class WebInfListener extends FileChangeAdapter {
            public void fileFolderCreated (FileEvent fe) {
                if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) { //NOI18N
                    fe.getFile().addFileChangeListener(wsdlListener);
                    wsdlFolder=fe.getFile();
                }
            }
            public void fileDeleted (FileEvent fe) {
                if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) { //NOI18N
                    fe.getFile().removeFileChangeListener(wsdlListener);
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }
                
        private class ProjectDirectoryListener implements FileChangeListener {
            
            public void fileAttributeChanged(org.openide.filesystems.FileAttributeEvent fe) {
            }

            public void fileChanged(FileEvent fe) {
            }

            public void fileDataCreated(FileEvent fe) {
            }

            public void fileDeleted(FileEvent fe) {
                if (isWatchedFile(getFileName(fe)))
                    buildKeys();
            }

            public void fileFolderCreated(FileEvent fe) {
                if (isWatchedFile(getFileName(fe)))
                    buildKeys();
            }

            public void fileRenamed(org.openide.filesystems.FileRenameEvent fe) {
                if (isWatchedFile(getFileName(fe)) || isWatchedFile(getOldFileName(fe)))
                    buildKeys();
            }
            
            private boolean isWatchedFile(String fileName) {
                // We only need to watch for the web and setup directory.
                String webDir = evaluator.getProperty(WebProjectProperties.WEB_DOCBASE_DIR);
                return fileName.equals(webDir);
            }
            
            private String getFileName(FileEvent fe) {
                return fe.getFile().getNameExt();
            }
            
            private String getOldFileName(FileRenameEvent fe) {
                String result = fe.getName();
                if (fe.getExt() != "") // NOI18N
                    result = result + "." + fe.getExt(); // NOI18N
                
                return result;
            }
        }
    }
    
    /** Yet another cool filter node just to add properties action
     */
    private static class PackageViewFilterNode extends FilterNode {
        
        private String nodeName;
        private Project project;
        private Action[] actions;
        
        public PackageViewFilterNode( SourceGroup sourceGroup, Project project ) {
            super( PackageView.createPackageView( sourceGroup ) );
            this.project = project;
            this.nodeName = "Sources";
        }
        
        public Action[] getActions( boolean context ) {
            if ( !context ) {
                if ( actions == null ) {
                    Action superActions[] = super.getActions( context );
                    actions = new Action[ superActions.length + 2 ];
                    System.arraycopy( superActions, 0, actions, 0, superActions.length );
                    actions[superActions.length] = null;
                    actions[superActions.length + 1] = new PreselectPropertiesAction(project, nodeName);
                }
                return actions;
            } else {
                return super.getActions( context );
            }
        }
    }
    
    /** The special properties action 
     */
    private static class PreselectPropertiesAction extends AbstractAction {
        
        private Project project;
        private String nodeName;
        private String panelName;
        
        public PreselectPropertiesAction( Project project, String nodeName ) {
            this( project, nodeName, null );
        }
        
        public PreselectPropertiesAction( Project project, String nodeName, String panelName ) {
            super( NbBundle.getMessage( WebViews.class, "LBL_Properties_Action" ) );
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }
         
        public void actionPerformed( ActionEvent e ) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl) project.getLookup().lookup(CustomizerProviderImpl.class);
            if ( cp != null ) {
                cp.showCustomizer( nodeName, panelName );
            }
        }
    }
  
    static final class VisibilityQueryDataFilter implements ChangeListener, ChangeableDataFilter {
        
        EventListenerList ell = new EventListenerList();        
        
        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener( this );
        }
                
        public boolean acceptDataObject(DataObject obj) {                
            FileObject fo = obj.getPrimaryFile();                
            return VisibilityQuery.getDefault().isVisible( fo );
        }
        
        public void stateChanged( ChangeEvent e) {            
            Object[] listeners = ell.getListenerList();     
            ChangeEvent event = null;
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i] == ChangeListener.class) {             
                    if ( event == null) {
                        event = new ChangeEvent( this );
                    }
                    ((ChangeListener)listeners[i+1]).stateChanged( event );
                }
            }
        }        
    
        public void addChangeListener( ChangeListener listener ) {
            ell.add( ChangeListener.class, listener );
        }        
                        
        public void removeChangeListener( ChangeListener listener ) {
            ell.remove( ChangeListener.class, listener );
        }
        
    }
    
    
    private static final class DocBaseNode extends FilterNode {
        private Image icon;
        private javax.swing.Action actions[]; 
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        
        private static Image WEB_PAGES_BADGE = Utilities.loadImage( "org/netbeans/modules/web/project/ui/resources/webPagesBadge.gif" ); //NOI18N
        
        private Project project;
        
        DocBaseNode (DataFolder folder, Project project) {
            super (folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER));
            this.project = project;
        }
        
        public Image getIcon(int type) {        
            return computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return computeIcon(true, type);
        }

        private Node getDataFolderNodeDelegate() {
            return ((DataFolder) getLookup().lookup(DataFolder.class)).getNodeDelegate();
        }

        private Image computeIcon(boolean opened, int type) {
            Image image;

            image = opened ? getDataFolderNodeDelegate().getOpenedIcon(type) : getDataFolderNodeDelegate().getIcon(type);
            image = Utilities.mergeImages(image, WEB_PAGES_BADGE, 7, 7);

            return image;        
        }
        
        public String getDisplayName () {
            return NbBundle.getMessage(WebViews.class, "LBL_Node_DocBase"); //NOI18N
        }

        public javax.swing.Action[] getActions( boolean context ) {
            if ( actions == null ) {
                actions = new javax.swing.Action[] {
                    org.netbeans.spi.project.ui.support.CommonProjectActions.newFileAction(),
                    null,
                    org.openide.util.actions.SystemAction.get( org.openide.actions.FileSystemAction.class ),
                    null,
                    org.openide.util.actions.SystemAction.get( org.openide.actions.FindAction.class ),
                    null,
                    org.openide.util.actions.SystemAction.get( org.openide.actions.PasteAction.class ),
                    null,
                    new PreselectPropertiesAction(project, "Sources"), //NOI18N
                };
            }
            return actions;            
        }
    }
    
    private static Lookup createLookup(Project project) {
        DataFolder rootFolder = DataFolder.findFolder(project.getProjectDirectory());
        // XXX Remove root folder after FindAction rewrite
        return Lookups.fixed(new Object[] {project, rootFolder});
    }
    
    private static final class ConfFilesNode extends org.openide.nodes.AbstractNode implements Runnable, FileStatusListener, ChangeListener, PropertyChangeListener {
        private static final Image CONFIGURATION_FILES_BADGE = Utilities.loadImage( "org/netbeans/modules/web/project/ui/resources/config-badge.gif", true ); // NOI18N
        
        private Node projectNode;
        
        // icon badging >>>
        private Set files;
        private Map fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock = new Object();
        private boolean iconChange;
        private boolean nameChange;        
        private ChangeListener sourcesListener;
        private Map groupsListeners;
	private Project project;
        // icon badging <<<
	
        public ConfFilesNode(Project prj) {
            super(ConfFilesChildren.forProject(prj), createLookup(prj));
	    this.project = prj;
            setName("configurationFiles"); // NOI18N
            
            FileObject projectDir = prj.getProjectDirectory();
            try {
                DataObject projectDo = DataObject.find(projectDir);
                if (projectDo != null)
                    projectNode = projectDo.getNodeDelegate();
            }
            catch (DataObjectNotFoundException e) {}
        }
        
        public Image getIcon(int type) {
            Image img = computeIcon(false, type);
            return (img != null) ? img: super.getIcon(type);
        }
        
        public Image getOpenedIcon(int type) {
            Image img = computeIcon(true, type);
            return (img != null) ? img: super.getIcon(type);
        }
        
        private Image computeIcon(boolean opened, int type) {
            if (projectNode == null)
                return null;

            Image image = opened ? projectNode.getOpenedIcon(type) : projectNode.getIcon(type);
            image = Utilities.mergeImages(image, CONFIGURATION_FILES_BADGE, 7, 7);
            return image;
        }
        
        public String getDisplayName() {
            return NbBundle.getMessage(WebViews.class, "LBL_Node_Config"); //NOI18N
        }
        
        public javax.swing.Action[] getActions(boolean context) {
            return new javax.swing.Action[] {
                SystemAction.get(FindAction.class),
            };
        }

	public void run() {
            boolean fireIcon;
            boolean fireName;
            synchronized (privateLock) {
                fireIcon = iconChange;
                fireName = nameChange;
                iconChange = false;
                nameChange = false;
            }
            if (fireIcon) {
                fireIconChange();
                fireOpenedIconChange();
            }
            if (fireName) {
                fireDisplayNameChange(null, null);
            }
	}

	public void annotationChanged(FileStatusEvent event) {
            if (task == null) {
                task = RequestProcessor.getDefault().create(this);
            }

            synchronized (privateLock) {
                if ((iconChange == false && event.isIconChange())  || (nameChange == false && event.isNameChange())) {
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        FileObject fo = (FileObject) it.next();
                        if (event.hasChanged(fo)) {
                            iconChange |= event.isIconChange();
                            nameChange |= event.isNameChange();
                        }
                    }
                }
            }

            task.schedule(50);  // batch by 50 ms
	}

	public void stateChanged(ChangeEvent e) {
            setProjectFiles(project);
	}

	public void propertyChange(PropertyChangeEvent evt) {
            setProjectFiles(project);
	}
	
        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources(project);  // returns singleton
            if (sourcesListener == null) {                
                sourcesListener = WeakListeners.change(this, sources);
                sources.addChangeListener(sourcesListener);                                
            }
            setGroups(Arrays.asList(sources.getSourceGroups(Sources.TYPE_GENERIC)));
        }

        private final void setGroups(Collection groups) {
            if (groupsListeners != null) {
                Iterator it = groupsListeners.keySet().iterator();
                while (it.hasNext()) {
                    SourceGroup group = (SourceGroup) it.next();
                    PropertyChangeListener pcl = (PropertyChangeListener) groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            groupsListeners = new HashMap();
            Set roots = new HashSet();
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                SourceGroup group = (SourceGroup) it.next();
                PropertyChangeListener pcl = WeakListeners.propertyChange(this, group);
                groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            setFiles(roots);
        }

        protected final void setFiles(Set files) {
            if (fileSystemListeners != null) {
                Iterator it = fileSystemListeners.keySet().iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem) it.next();
                    FileStatusListener fsl = (FileStatusListener) fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
                        
            fileSystemListeners = new HashMap();
            this.files = files;
            if (files == null) return;

            Iterator it = files.iterator();
            Set hookedFileSystems = new HashSet();
            while (it.hasNext()) {
                FileObject fo = (FileObject) it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) {
                        continue;
                    }
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener(this, fs);
                    fs.addFileStatusListener(fsl);
                    fileSystemListeners.put(fs, fsl);
                } catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate(e, "Can not get " + fo + " filesystem, ignoring...");  // NO18N
                    err.notify(ErrorManager.INFORMATIONAL, e);
                }
            }
        }
        
    }
    
    private static final class ConfFilesChildren extends Children.Keys {
        
        private final static String[] wellKnownFiles = { 
            "web.xml", 
            "webservices.xml", 
            "struts-config.xml", 
            "faces-config.xml",            
             // Creator-specific JSF config files
            "navigator.xml", 
            "managed-beans.xml" 
        }; //NOI18N
        
        private ProjectWebModule pwm;
        private FileObject projectDir;
        private HashSet keys;
        private java.util.Comparator comparator = new NodeComparator();
        
        private FileChangeListener webInfListener = new FileChangeAdapter() {
            public void fileDataCreated(FileEvent fe) {
                if (isWellKnownFile(fe.getFile().getNameExt()))
                    addKey(fe.getFile());
            }

            public void fileRenamed(FileRenameEvent fe) {
                // if the old file name was in keys, the new file name 
                // is now there (since it's the same FileObject)
                if (keys.contains(fe.getFile())) {
                    // so we need to remove it if it's not well-known
                    if (!isWellKnownFile(fe.getFile().getNameExt()))
                        removeKey(fe.getFile());
                    else 
                        // this causes resorting of the keys
                        doSetKeys();
                } else {
                    // the key is not contained, so add it if it's well-known
                    if (isWellKnownFile(fe.getFile().getNameExt()))
                        addKey(fe.getFile());
                }
            }
            
            public void fileDeleted(FileEvent fe) {
                if (isWellKnownFile(fe.getFile().getNameExt())) {
                    removeKey(fe.getFile());
                }
            }
        };
        
        private FileChangeListener anyFileListener = new FileChangeAdapter() {
            public void fileDataCreated(FileEvent fe) {
                addKey(fe.getFile());
            }

            public void fileFolderCreated(FileEvent fe) {
                addKey(fe.getFile());
            }

            public void fileRenamed(FileRenameEvent fe) {
                addKey(fe.getFile());
            }

            public void fileDeleted(FileEvent fe) {
                removeKey(fe.getFile());
            }
        };
        
        private ConfigurationFilesListener serverSpecificFilesListener = new ConfigurationFilesListener() {
            public void fileCreated(FileObject fo) {
                addKey(fo);
            }
            
            public void fileDeleted(FileObject fo) {
                removeKey(fo);
            }
        };
        
        private ConfFilesChildren(ProjectWebModule pwm, FileObject projectDir) {
            this.pwm = pwm;
            this.projectDir = projectDir;
            keys = new HashSet();
        }
        
        public static Children forProject(Project project) {
            ProjectWebModule pwm = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
            return new ConfFilesChildren(pwm, project.getProjectDirectory());
        }
                
        protected void addNotify() {
            createKeys();
            doSetKeys();
        }
        
        protected void removeNotify() {
            removeListeners();
        }
        
        public Node[] createNodes(Object key) {
            Node n = null;
            
            if (keys.contains(key)) {
                FileObject fo = (FileObject)key;
                try {
                    DataObject dataObject = DataObject.find(fo);
                    n = dataObject.getNodeDelegate().cloneNode();
                }
                catch (DataObjectNotFoundException dnfe) {}
            }
                                    
            return (n == null) ? new Node[0] : new Node[] { n };            
        }
        
        public synchronized void refreshNodes() {
            addNotify();
        }
        
        private synchronized void addKey(FileObject key) {
            if (VisibilityQuery.getDefault().isVisible(key)) {
                //System.out.println("Adding " + key.getPath());
                keys.add(key);
                doSetKeys();
            }
        }
        
        private synchronized void removeKey(FileObject key) {
            //System.out.println("Removing " + key.getPath());
            keys.remove(key);
            doSetKeys();
        }
        
        private synchronized void createKeys() {
            keys.clear();
            
            addWellKnownFiles();
            addConfDirectoryFiles();
            addServerSpecificFiles();
            addFrameworkFiles();
        }
        
        private void doSetKeys() {
            Object[] result = keys.toArray();
            java.util.Arrays.sort(result, comparator);
            //for (int i = 0; i < result.length; i++)
            //    System.out.println(result[i]);
            setKeys(result);
        }
                
        private void addWellKnownFiles() {            
            FileObject webInf = pwm.getWebInf(true);
            if (webInf == null)
                return;
            
            for (int i = 0; i < wellKnownFiles.length; i++) {
                FileObject fo = webInf.getFileObject(wellKnownFiles[i]);
                if (fo != null)
                    keys.add(fo);
            }
            
            webInf.addFileChangeListener(webInfListener);
        }
        
        private void addConfDirectoryFiles() {
            FileObject conf = pwm.getConfDir();
            if (conf == null)
                return;
            
            FileObject[] children = conf.getChildren();
            for (int i = 0; i < children.length; i++) {
                if (VisibilityQuery.getDefault().isVisible(children[i]))
                    keys.add(children[i]);
            }
            
            conf.addFileChangeListener(anyFileListener);
        }
        
        private void addServerSpecificFiles() {
            FileObject[] files = pwm.getConfigurationFiles();
            
            for (int i = 0; i < files.length; i++) {
                keys.add(files[i]);
            }
            
            pwm.addConfigurationFilesListener(serverSpecificFilesListener);
        }
        
        private void addFrameworkFiles(){
            List providers = WebFrameworkSupport.getFrameworkProviders();
            for (int i = 0; i < providers.size(); i++){
                WebFrameworkProvider provider = (WebFrameworkProvider)providers.get(i);
                FileObject wmBase = pwm.getDocumentBase();
                File files[] = null;
                if (wmBase != null) {
                    files = provider.getConfigurationFiles(WebModule.getWebModule(wmBase));
                }
                if (files != null){
                    for (int j = 0; j < files.length; j++){
                        FileObject fo = FileUtil.toFileObject(files[j]);
                        if (fo != null){
                            keys.add(fo);
                            // XXX - do we need listeners on these files?
                            //fo.addFileChangeListener(anyFileListener);
                        }
                    }
                }
            }
        }
        
        private void removeListeners() {
            pwm.removeConfigurationFilesListener(serverSpecificFilesListener);
            
            FileObject webInf = pwm.getWebInf(true);
            if (webInf != null)
                pwm.getWebInf().removeFileChangeListener(webInfListener);
            
            FileObject conf = pwm.getConfDir();
            if (conf != null)
                conf.removeFileChangeListener(anyFileListener);
        }
        
        private boolean isWellKnownFile(String name) {
            for (int i = 0; i < wellKnownFiles.length; i++) 
                if (name.equals(wellKnownFiles[i]))
                    return true;
            
            return false;
        }
        
        private void dumpKeys() {
            java.util.Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                FileObject fo = (FileObject)iter.next();
                //System.out.println("Key: " + org.openide.filesystems.FileUtil.toFile(fo).getPath()); // NOI18N
            }
        }
                
        private static final class NodeComparator implements java.util.Comparator {
            public int compare(Object o1, Object o2) {
                FileObject fo1 = (FileObject)o1;
                FileObject fo2 = (FileObject)o2;
                
                int result = compareType(fo1, fo2);
                if (result == 0)
                    result = compareNames(fo1, fo2);
                if (result == 0)
                    return fo1.getPath().compareTo(fo2.getPath());
                
                return result;
            }
            
            private int compareType(FileObject fo1, FileObject fo2) {
                int folder1 = fo1.isFolder() ? 0 : 1;
                int folder2 = fo2.isFolder() ? 0 : 1;
                
                return folder1 - folder2;
            }
            
            private int compareNames(FileObject do1, FileObject do2) {
                return do1.getNameExt().compareTo(do2.getNameExt());
            }
            
            public boolean equals(Object o) {
                return (o instanceof NodeComparator);
            }
        }
    }
    
    private static class ConfFilesRefreshAction extends CookieAction {
        
        protected Class[] cookieClasses() {
            return new Class[] { RefreshCookie.class };
        }
        
        protected boolean enable(Node[] activatedNodes) {
            return true;
        }
        
        protected int mode() {
            return CookieAction.MODE_EXACTLY_ONE;
        }
        
        protected boolean asynchronous() {
            return false;
        }
        
        public String getName() {
            return NbBundle.getMessage(WebViews.class, "LBL_Refresh"); //NOI18N
        }
        
        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
        
        public void performAction(Node[] selectedNodes) {
            for (int i = 0; i < selectedNodes.length; i++) {
                RefreshCookie cookie = (RefreshCookie)selectedNodes[i].getCookie(RefreshCookie.class);
                cookie.refresh();
            }
        }
        
        private interface RefreshCookie extends Node.Cookie {
            public void refresh();
        }
    }
}
