/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.project.jaxws;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.ClassPathSupport;
import org.netbeans.modules.j2ee.metadata.JAXWSMetadataProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Marek Fukala, Andrei Badea
 */
public class WebJAXWSMetadataFinder implements JAXWSMetadataProvider {
    
    private final WebProject project;
    
    private MetadataUnit jaxWSMetadata;
    private ClassPath projectSourcesClassPath;
    
    public WebJAXWSMetadataFinder(WebProject project) {
        this.project = project;
    }
    
    public MetadataUnit getJAXWSMetadata() {
        synchronized (this) {
            if (jaxWSMetadata != null) {
                return jaxWSMetadata;
            }
            jaxWSMetadata = new JAXWSMetadataUnitImpl();
            return jaxWSMetadata;
        }
    }
    
    private ClassPath getProjectSourcesClassPath() {
        synchronized (this) {
            if (projectSourcesClassPath == null) {
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)project.getLookup().lookup(ClassPathProviderImpl.class);
                projectSourcesClassPath = ClassPathSupport.createWeakProxyClassPath(new ClassPath[] {
                    cpProvider.getProjectSourcesClassPath(ClassPath.SOURCE),
                    cpProvider.getProjectSourcesClassPath(ClassPath.COMPILE),
                });
            }
            return projectSourcesClassPath;
        }
    }
    
    private class JAXWSMetadataUnitImpl implements MetadataUnit {
        
        public ClassPath getClassPath() {
            return getProjectSourcesClassPath();
        }
        
        public FileObject getDeploymentDescriptor() {
            return null;
        }
    }
}
