/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.test.web.core.syntax;

import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import junit.framework.Test;
import org.netbeans.editor.Utilities;
import org.netbeans.jellytools.actions.SaveAction;
import org.netbeans.jellytools.actions.SaveAllAction;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.test.web.FileObjectFilter;
import org.netbeans.test.web.RecurrentSuiteFactory;
import org.netbeans.test.web.Waiter;
import org.netbeans.test.web.core.syntax.CompletionTest.TestStep;
import org.openide.actions.UndoAction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.EditorCookie.Observable;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author jindra
 */
public class IndentationTest extends CompletionTest{
    private String startStep = "<!--CC";
    private String endStep="-->";
    
    /** Creates a new instance of IndentationTest */
    public IndentationTest(String name, FileObject testFileObj) {
        super(name, testFileObj);
    }
    
    public static Test suite() {
        // find folder with test projects and define file objects filter
        File datadir = new AutoCompletionTest(null, null).getDataDir();
        File projectsDir = new File(datadir, "IndentationTestProjects");
        FileObjectFilter filter = new FileObjectFilter() {
            public boolean accept(FileObject fo) {
                String ext = fo.getExt();
                String name = fo.getName();
                return (name.startsWith("test") || name.startsWith("Test"))
                && (xmlExts.contains(ext) || jspExts.contains(ext) || jspExts.equals("java"));
            }
        };
        return RecurrentSuiteFactory.createSuite(IndentationTest.class, projectsDir, filter);
    }
    
    
    public void runTest() throws Exception {
        try {
            // get token chain
            DataObject dataObj = DataObject.find(testFileObj);
            EditorCookie.Observable ed = (Observable) dataObj.getCookie(Observable.class);
            
            // prepare synchronization and register listener
            final Waiter waiter = new Waiter();
            final PropertyChangeListener pcl = new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(Observable.PROP_OPENED_PANES)) {
                        waiter.notifyFinished();
                    }
                }
            };
            ed.addPropertyChangeListener(pcl);
            // open document
            BaseDocument doc = (BaseDocument) ed.openDocument();
            ed.open();
            // wait for PROP_OPENED_PANES and remove listener
            assertTrue("The editor pane was not opened in 10 secs.", waiter.waitFinished(10000));
            ed.removePropertyChangeListener(pcl);
            // wait 2s for editor initialization
            Thread.currentThread().sleep(2000);
            final JEditorPane editor = ed.getOpenedPanes()[0];
            String text = doc.getText(0, doc.getLength());
            int endPosition = 0;
            int actualPosition = text.indexOf(startStep, 0);//position of first step
            int i = JemmyProperties.getCurrentDispatchingModel();
            JemmyProperties.setCurrentDispatchingModel(JemmyProperties.ROBOT_MODEL_MASK);
            while (actualPosition != -1){//go through all cases
                endPosition=text.indexOf(endStep, actualPosition);//get possition of comment end tag
//                obsah = text.substring(actualPosition+startStep.length(), endPosition);//get offset number
//                offset = Integer.valueOf(obsah.trim());
//                if (offset >=0) editor.getCaret().setDot(endPosition+endStep.length()+offset);//set cursor possition
//                else editor.getCaret().setDot(actualPosition+offset);
                doc.remove(actualPosition, endPosition+endStep.length()-actualPosition);
                editor.getCaret().setDot(actualPosition);
                Thread.currentThread().sleep(500);
                //press Enter
//                runInAWT(new Runnable() {
//                    public void run() {
                        EditorOperator eo = new EditorOperator(testFileObj.getNameExt());
                        eo.pushKey(KeyEvent.VK_ENTER);
//                    }
//                });
                Thread.currentThread().sleep(1500);
                doc.insertString(editor.getCaret().getDot(), "|", null);
                Thread.currentThread().sleep(1000);
                text = doc.getText(0, doc.getLength());
                actualPosition = text.indexOf(startStep, actualPosition);//new actualposition
            }
            JemmyProperties.setCurrentDispatchingModel(i);
            ref(doc.getText(0, doc.getLength()));//the result into ref file
            new SaveAllAction().performAPI();
        } catch (Exception ex) {
            throw new AssertionFailedErrorException(ex);
        }
        ending();
    }
    
}
