/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web.core.syntax;

import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import junit.framework.Test;
import org.netbeans.editor.Utilities;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.modules.editor.CompletionJListOperator;
import org.netbeans.editor.BaseDocument;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.test.web.FileObjectFilter;
import org.netbeans.test.web.RecurrentSuiteFactory;
import org.openide.actions.UndoAction;
import org.openide.filesystems.FileObject;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author jindra
 */
public class AutoCompletionTest extends CompletionTest {
    
    /** Creates a new instance of AutoCompletionTest */
    public AutoCompletionTest(String name, FileObject testFileObj) {
        super(name, testFileObj);
        debug = false;
    }
    
    public static Test suite() {
        // find folder with test projects and define file objects filter
        File datadir = new AutoCompletionTest(null, null).getDataDir();
        File projectsDir = new File(datadir, "AutoCompletionTestProjects");
        FileObjectFilter filter = new FileObjectFilter() {
            public boolean accept(FileObject fo) {
                String ext = fo.getExt();
                String name = fo.getName();
                return (name.startsWith("test") || name.startsWith("Test"))
                && (xmlExts.contains(ext) || jspExts.contains(ext) || ext.equals("java"));
            }
        };
        return RecurrentSuiteFactory.createSuite(AutoCompletionTest.class, projectsDir, filter);
    }
    
    
    protected void exec(final JEditorPane editor, TestStep step) throws Exception {
        boolean ccError = false;
        try {
            BaseDocument doc = (BaseDocument) editor.getDocument();
            Thread.currentThread().sleep(2000);
            ref(step.toString());
            // insert prefix and set cursor
            doc.insertString(step.getOffset(), "\n" + step.getPrefix(), null);
            Caret caret = editor.getCaret();
            caret.setDot(step.getCursorPos());
            Thread.currentThread().sleep(1000);

            EditorOperator eo = new EditorOperator(testFileObj.getNameExt());
            eo.txtEditorPane().pushKey(KeyEvent.VK_SPACE, KeyEvent.CTRL_MASK);

            Thread.currentThread().sleep(2000);
            int rowStart = Utilities.getRowStart(doc, step.getOffset() + 1);
            int rowEnd = Utilities.getRowEnd(doc, step.getOffset() + 1);
            String result = doc.getText(new int[] {rowStart, rowEnd});
            if  (!result.equals(step.getResult())) {
                ref("EE: unexpected CC result:\n< " + result + "\n> "
                        + step.getResult());
            }
            ref("End cursor position = " + caret.getDot());
        } finally {
            Thread.currentThread().sleep(500);  //XXX
            // undo all changes
            final UndoAction ua = (UndoAction)SystemAction.get(UndoAction.class);
            assertNotNull("Cannot obtain UndoAction", ua);
            while (ua.isEnabled()) {
                runInAWT(new Runnable() {
                    public void run() {
                        ua.performAction();
                    }
                });
                Thread.currentThread().sleep(50);  //XXX
            }
            Thread.currentThread().sleep(500);
        }
        
    }
    
}
