/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.core.syntax.folding;

import java.io.PrintStream;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.spi.editor.fold.FoldOperation;

/**
 * Utility class. Contains mostly debug messages suport.
 *
 * @author Marek Fukala
 */

public class JspFoldUtils {

    
    public static void printFolds(FoldOperation fo) {
        printFolds(fo.getHierarchy(), System.out);
    }
    
    /** Prints folds recursivelly into standard output*/
    public static void printFolds(FoldHierarchy fh, PrintStream out) {
        fh.lock();
        try {
            Fold rootFold = fh.getRootFold();
            printChildren(rootFold, 0, out);
        } finally {
            fh.unlock();
        }
    }
    
    private static void printChildren(Fold f, int level, PrintStream out) {
        int foldCount = f.getFoldCount();
        //indent
        for( int i = 0; i < level; i ++) System.out.print(" ");
        //print this fold info
        out.println(f.getDescription() + "[" + f.getType().toString() + "; " + f.getStartOffset() + " - " + f.getEndOffset() + "]");
        System.out.println(f.getDescription() + "[" + f.getType().toString() + "; " + f.getStartOffset() + " - " + f.getEndOffset() + "]");
        //print children
        for (int i = 0; i < foldCount; i++) {
            Fold childFold = f.getFold(i);
            printChildren(childFold, level + 4, out);
        }
    }
  
    public static String getContextName(int typeId) {
        switch(typeId) {
            case JspSyntaxSupport.COMMENT_COMPLETION_CONTEXT:
                return "comment";
            case JspSyntaxSupport.CONTENTL_COMPLETION_CONTEXT:
                return "content language";
            case JspSyntaxSupport.DIRECTIVE_COMPLETION_CONTEXT:
                return "directive";
            case JspSyntaxSupport.ENDTAG_COMPLETION_CONTEXT:
                return "end tag";
            case JspSyntaxSupport.SCRIPTINGL_COMPLETION_CONTEXT:
                return "scripting";
            case JspSyntaxSupport.TAG_COMPLETION_CONTEXT:
                return "tag";
            case JspSyntaxSupport.TEXT_COMPLETION_CONTEXT:
                return "text";
            default:
                return "?";
        }
    } 
    
}
