/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.web.core.syntax.completion;

import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.web.core.syntax.JSPKit;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/**
 *
 * @author mf100882
 */
public class JspCompletionSupport {
    
    private static Completion getHTMLCompletion(ExtEditorUI extEditorUI) {
        EditorKit kit = JEditorPane.createEditorKitForContentType(JspUtils.getContentLanguage());
        if (kit instanceof HTMLKit) return ((HTMLKit)kit).createCompletionForProvider(extEditorUI);
        else return null;
    }
    
    /**
     * @deprecated
     */
    public static Completion createCompletion(ExtEditorUI extEditorUI) {
        BaseDocument doc = extEditorUI.getDocument();
        if (doc != null){
            DataObject dobj = NbEditorUtilities.getDataObject(doc);
        }
        
        String mimeType = NbEditorUtilities.getMimeType(doc);
        Completion contentCompletion = (!(mimeType.equals(JSPKit.JSP_MIME_TYPE) || mimeType.equals(JSPKit.TAG_MIME_TYPE))) ?
            null :
            getHTMLCompletion(extEditorUI);
        final JspCompletion completion =
                new JspCompletion(extEditorUI, contentCompletion);
        return completion;
    }
    
    
}
