/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.core.syntax.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

/**
 * This is just a simple CC provider which delegates to java cc provider.
 * It's main purpose it to filter java completion query results from non-java contexts.
 * This can be also done on the java CC side by testing for java token context before querying.
 *
 * @author Marek Fukala
 */
public class JavaJspCompletionProvider extends JavaCompletionProvider {
    
    public CompletionTask createTask(int queryType, final JTextComponent component) {
        try {
            JspSyntaxSupport sup = (JspSyntaxSupport)Utilities.getSyntaxSupport(component);
            TokenItem ti = sup.getItemAtOrBefore(component.getCaret().getDot());
            //delegate to java cc provider if the context is really java code
            if(ti != null && ti.getTokenContextPath().contains(JavaTokenContext.contextPath))
                return super.createTask(queryType, component);

        }catch(BadLocationException e) {
            e.printStackTrace();
        }
        
        //not java context => return empty result
        return new AsyncCompletionTask(new EmptyQuery(), component);
    }
    
    private static final class EmptyQuery extends AsyncCompletionQuery {
        public EmptyQuery () {}
        
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            resultSet.finish();
        }

    }
    
}



