/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.core.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;
import javax.swing.KeyStroke;
import java.util.*;
import org.openide.actions.CutAction;
import org.openide.actions.CopyAction;
import org.openide.actions.PasteAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.ToolsAction;
import org.openide.actions.PropertiesAction;

import org.openide.windows.TopComponent;

import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SettingsNames;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.ext.ExtSettingsNames;
import org.netbeans.editor.ext.html.HTMLSettingsInitializer;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.netbeans.editor.ext.java.JavaSettingsNames;
import org.netbeans.modules.editor.java.JavaKit;

public class JspMultiSettingsInitializer extends Settings.AbstractInitializer {

    /** Name assigned to initializer */
    public static final String NAME = "jsp-multi-settings-initializer"; // NOI18N

    private static final int ALT_MASK = System.getProperty("mrj.version") != null ?
        InputEvent.CTRL_MASK : InputEvent.ALT_MASK;
    
    private static boolean isMac = System.getProperty("mrj.version") != null;
    
    public JspMultiSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap (Class kitClass, Map settingsMap) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        
        // Jsp Colorings
        if (kitClass == BaseKit.class) {
            new JspMultiTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
            new JspJavaLayerTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
	    new ELLayerTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        }
	 
	if (kitClass == JavaKit.class) {
            
            settingsMap.put(JavaSettingsNames.INDENT_HOT_CHARS_ACCEPTOR,
                    JavaSettingsDefaults.defaultIndentHotCharsAcceptor);

        }
        // Jsp Settings
        if (kitClass == JSPKit.class) {
            SettingsUtil.updateListSetting(settingsMap, SettingsNames.KEY_BINDING_LIST,
                    new MultiKeyBinding[] {
                        new MultiKeyBinding(
                           KeyStroke.getKeyStroke(KeyEvent.VK_O, ALT_MASK),
                            JavaKit.gotoSourceAction
                        ),
                        new MultiKeyBinding(
                            KeyStroke.getKeyStroke(KeyEvent.VK_G, ALT_MASK | (isMac ? InputEvent.SHIFT_MASK : 0)),
                            org.netbeans.editor.ext.ExtKit.gotoDeclarationAction
                        ),
                        new MultiKeyBinding(
                            KeyStroke.getKeyStroke(KeyEvent.VK_B,
                            mask),
                            JavaKit.gotoSuperImplementationAction
                        )
            }
            );
            
            settingsMap.put(JavaSettingsNames.PAIR_CHARACTERS_COMPLETION,
                        JavaSettingsDefaults.defaultPairCharactersCompletion);

            //enable code folding
            settingsMap.put(SettingsNames.CODE_FOLDING_ENABLE, JavaSettingsDefaults.defaultCodeFoldingEnable);
            settingsMap.put(JspSettings.CODE_FOLDING_UPDATE_TIMEOUT, JspSettings.defaultCodeFoldingUpdateInterval);
            settingsMap.put(JspSettings.CARET_SIMPLE_MATCH_BRACE, JspSettings.defaultCaretSimpleMatchBrace);
            
            settingsMap.put (org.netbeans.editor.SettingsNames.ABBREV_MAP, getJSPAbbrevMap());
            SettingsUtil.updateListSetting(settingsMap, SettingsNames.TOKEN_CONTEXT_LIST,
                new TokenContext[] { JspMultiTokenContext.context, 
				     JspJavaLayerTokenContext.context, 
				     ELLayerTokenContext.context });
            settingsMap.put(SettingsNames.IDENTIFIER_ACCEPTOR,
                            HTMLSettingsInitializer.HTML_IDENTIFIER_ACCEPTOR);

            // copied from NbJavaSettingsInitializer to be consistent
            settingsMap.put(ExtSettingsNames.POPUP_MENU_ACTION_NAME_LIST,
                            new ArrayList(Arrays.asList(
                                              new String[] {
                                                  TopComponent.class.getName(),
                                                  null,
                                                  // "org.netbeans.modules.debugger.support.actions.ToggleBreakpointAction",
                                                  // JavaKit.addWatchAction,
                                                  // null,
                                                  CutAction.class.getName(),
                                                  CopyAction.class.getName(),
                                                  PasteAction.class.getName(),
                                                  null,
                                                  DeleteAction.class.getName(),
                                                  null,
                                                  ToolsAction.class.getName(),
                                                  BaseKit.generateGutterPopupAction,
                                                  PropertiesAction.class.getName()
                                              }
                                          ))
                           );

        }
    }

    Map getJSPAbbrevMap() {
        Map jspAbbrevMap = new TreeMap ();
        // <jsp:something tags
        jspAbbrevMap.put ("jspu", "<jsp:useBean id=\"|\" type=\"\"/>");        // NOI18N
        jspAbbrevMap.put ("jspg", "<jsp:getProperty name=\"|\" property=\"\"/>");  // NOI18N
        jspAbbrevMap.put ("jsps", "<jsp:setProperty name=\"|\" property=\"\"/>");  // NOI18N
        jspAbbrevMap.put ("jspi", "<jsp:include page=\"|\"/>");      // NOI18N
        jspAbbrevMap.put ("jspf", "<jsp:forward page=\"|\"/>");      // NOI18N
        jspAbbrevMap.put ("jspp", "<jsp:plugin type=\"|\" code=\"\" codebase=\"\">\n</jsp:plugin>");       // NOI18N
        // taglib
        jspAbbrevMap.put ("tglb", "<%@taglib uri=\"|\"%>");         // NOI18N
        // <%@ page tags
        jspAbbrevMap.put ("pg", "<%@page |%>");                   // NOI18N
        jspAbbrevMap.put ("pgl", "<%@page language=\"java\"%>");       // NOI18N
        jspAbbrevMap.put ("pgex", "<%@page extends=\"|\"%>");       // NOI18N
        jspAbbrevMap.put ("pgim", "<%@page import=\"|\"%>");        // NOI18N
        jspAbbrevMap.put ("pgs", "<%@page session=\"false\"%>");        // NOI18N
        jspAbbrevMap.put ("pgb", "<%@page buffer=\"|kb\"%>");         // NOI18N
        jspAbbrevMap.put ("pga", "<%@page autoFlush=\"false\"%>");      // NOI18N
        jspAbbrevMap.put ("pgin", "<%@page info=\"|\"%>");          // NOI18N
        jspAbbrevMap.put ("pgit", "<%@page isThreadSafe=\"false\"%>");  // NOI18N
        jspAbbrevMap.put ("pgerr", "<%@page errorPage=\"|\"%>");    // NOI18N
        jspAbbrevMap.put ("pgc", "<%@page contentType=\"|\"%>");    // NOI18N
        jspAbbrevMap.put ("pgie", "<%@page isErrorPage=\"true\"%>");   // NOI18N
        // common java abbrevs
        jspAbbrevMap.put ("rg", "request.getParameter(\"|\")");     // NOI18N
        jspAbbrevMap.put ("sg", "session.getAttribute(\"|\")");         // NOI18N
        jspAbbrevMap.put ("sp", "session.setAttribute(\"|\", )");         // NOI18N
        jspAbbrevMap.put ("sr", "session.removeAttribute(\"|\")");      // NOI18N
        jspAbbrevMap.put ("pcg", "pageContext.getAttribute(\"|\")");// NOI18N
        jspAbbrevMap.put ("pcgn", "pageContext.getAttributeNamesInScope(|)");// NOI18N
        jspAbbrevMap.put ("pcgs", "pageContext.getAttributesScope(\"|\")");// NOI18N
        jspAbbrevMap.put ("pcr", "pageContext.removeAttribute(\"|\")");// NOI18N
        jspAbbrevMap.put ("pcs", "pageContext.setAttribute(\"|\", )");// NOI18N
        jspAbbrevMap.put ("ag", "application.getAttribute(\"|\")");     // NOI18N
        jspAbbrevMap.put ("ap", "application.putAttribute(\"|\", )");     // NOI18N
        jspAbbrevMap.put ("ar", "application.removeAttribute(\"|\")");  // NOI18N
        jspAbbrevMap.put ("oup", "out.print(\"|\")");               // NOI18N
        jspAbbrevMap.put ("oupl", "out.println(\"|\")");            // NOI18N
        jspAbbrevMap.put ("cfgi", "config.getInitParameter(\"|\")");// NOI18N

        return jspAbbrevMap;
    }

    static class JspMultiTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {

        private Coloring emptyColoring = new Coloring(null, null, null);

        private Coloring errorColoring = new Coloring(null, Color.red, null);

        private Coloring javaErrorColoring = new Coloring(null, new Color(253, 242, 196), Color.red);

        private Coloring javaAddColoring = new Coloring(null, null, new Color(253, 242, 196));

        private Font boldFont   = SettingsDefaults.defaultFont.deriveFont (Font.BOLD);
        
        private Settings.Evaluator lightGrayEvaluator
            = new SettingsUtil.ForeColorPrintColoringEvaluator(Color.lightGray);
        
        public JspMultiTokenColoringInitializer() {
            super(JspMultiTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath,
        TokenCategory tokenIDOrCategory, boolean printingSet) {

            if (tokenContextPath == JspMultiTokenContext.contextPath) {
                 if (!printingSet) {
                      switch (tokenIDOrCategory.getNumericID()) {
                           case JspMultiTokenContext.ERROR_ID:
                               return errorColoring;
                      }

                } else { // printing set
                     return SettingsUtil.defaultPrintColoringEvaluator;
                }

            } else if (tokenContextPath == JspMultiTokenContext.jspTagContextPath) {
                // JspTag token colorings
                if (!printingSet) {
                    switch (tokenIDOrCategory.getNumericID()) {
                        case JspTagTokenContext.TEXT_ID:
                          return emptyColoring;

                        case JspTagTokenContext.ERROR_ID:
                          return new Coloring(boldFont, Color.white, Color.red);

                        case JspTagTokenContext.TAG_ID:
                          return new Coloring(boldFont, Color.blue, new Color(239, 240, 235));

                        case JspTagTokenContext.SYMBOL_ID:
                          return new Coloring(boldFont, Color.black, new Color(239, 240, 235));
  
                        case JspTagTokenContext.COMMENT_ID:
                          return new Coloring(boldFont, Color.gray, null);
  
                        case JspTagTokenContext.ATTRIBUTE_ID:
                          return new Coloring(null, Color.green.darker().darker(), new Color(239, 240, 235));
  
                        case JspTagTokenContext.ATTR_VALUE_ID:
                          return new Coloring(null, new Color(153,0,107), new Color(239, 240, 235));
  
                        case JspTagTokenContext.SYMBOL2_ID:
                          return new Coloring(boldFont, Color.black, new Color(253, 242, 196)); // same as Java
                          
                        case JspTagTokenContext.WHITESPACE_ID:
                          return new Coloring(boldFont, Color.black, new Color(239, 240, 235));

                    }

                } else { // printing set
                    switch (tokenIDOrCategory.getNumericID()) {
                        case JspTagTokenContext.COMMENT_ID:
                            return lightGrayEvaluator;

                        default:
                             return SettingsUtil.defaultPrintColoringEvaluator;
                    }

                }

                return null;

            } else if (tokenContextPath == JspMultiTokenContext.elContextPath) {
                // EL token colorings
                if (!printingSet) {
                    switch (tokenIDOrCategory.getNumericID()) {
			case JavaTokenContext.WHITESPACE_ID:
			case ELTokenContext.IDENTIFIER_ID: 
			case JavaTokenContext.OPERATORS_ID:
                          return new Coloring(null, Color.black, new Color(253, 242, 196));

                        case ELTokenContext.EOL_ID:
                          return emptyColoring;

                        case ELTokenContext.EL_DELIM_ID:
                          return new Coloring(boldFont, Color.black, new Color(253, 242, 196)); // same as Java
			  
			case ELTokenContext.KEYWORDS_ID:
			  return new Coloring(boldFont, Coloring.FONT_MODE_APPLY_STYLE, new Color(0, 0, 153), new Color(253, 242, 196));
			  
			case ELTokenContext.STRING_LITERAL_ID:
			    return new Coloring(null, new Color(153, 0, 107), new Color(253, 242, 196));
			    
			case ELTokenContext.CHAR_LITERAL_ID:
			    return new Coloring(null, new Color(0, 111, 0), new Color(253, 242, 196));
			    
			case ELTokenContext.ERRORS_ID:
			    return new Coloring(null, Color.white, Color.red);
			    
			case ELTokenContext.NUMERIC_LITERALS_ID:
			   return new Coloring(null, new Color(120, 0, 0), new Color(253, 242, 196));
			   
			case ELTokenContext.TAG_LIB_PREFIX_ID:
			   return new Coloring(boldFont, Color.blue, new Color(253, 242, 196));
                    }   

                } else { // printing set
                    return SettingsUtil.defaultPrintColoringEvaluator;
                }

                return null;

            } else if (tokenContextPath.contains(JavaTokenContext.contextPath)) {
                // Java token colorings
                if (!printingSet) {
                    if (tokenIDOrCategory == JavaTokenContext.ERRORS) 
                        return javaErrorColoring;
                    
                    //there is the JspJavaFakeTokenContext between the JavaTokenContext and JspMultiSyntaxTokenContext !!!
                    return new SettingsUtil.TokenColoringEvaluator(
                        tokenContextPath.getParent().getParent().getFullTokenName(tokenIDOrCategory),
                        javaAddColoring, printingSet);

                } else { // printing set
                     return SettingsUtil.defaultPrintColoringEvaluator;
                }

            } else if (tokenContextPath == JspMultiTokenContext.htmlContextPath) {
                // HTML token colorings
                if (!printingSet) {
                    return new SettingsUtil.TokenColoringEvaluator(
                        tokenContextPath.getParent().getFullTokenName(tokenIDOrCategory),
                        null, printingSet);


                } else { // printing set
                     return SettingsUtil.defaultPrintColoringEvaluator;
                }

            } else if (tokenContextPath == JspMultiTokenContext.plainContextPath) {
                // Plain text token colorings
                if (!printingSet) {
                    return new SettingsUtil.TokenColoringEvaluator(
                        tokenContextPath.getParent().getFullTokenName(tokenIDOrCategory),
                        null, printingSet);

                } else { // printing set
                     return SettingsUtil.defaultPrintColoringEvaluator;
                }

            }

            return null;

        }

    }

    static class JspJavaLayerTokenColoringInitializer
	    extends SettingsUtil.TokenColoringInitializer {

        public JspJavaLayerTokenColoringInitializer() {
            super(JspJavaLayerTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath,
        TokenCategory tokenIDOrCategory, boolean printingSet) {
            if (!printingSet) {
                return new SettingsUtil.TokenColoringEvaluator(
                    tokenContextPath.getParent().getFullTokenName(tokenIDOrCategory),
                    null, printingSet);

            } else { // printing set
                 return SettingsUtil.defaultPrintColoringEvaluator;
            }
        }

    }
    
    static class ELLayerTokenColoringInitializer
	    extends SettingsUtil.TokenColoringInitializer {

        Font boldFont = SettingsDefaults.defaultFont.deriveFont(Font.BOLD);
        Settings.Evaluator italicSubst = new SettingsUtil.FontStylePrintColoringEvaluator(Font.ITALIC);

        public ELLayerTokenColoringInitializer() {
            super(ELLayerTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath,
        TokenCategory tokenIDOrCategory, boolean printingSet) {
            if (!printingSet) {
                switch (tokenIDOrCategory.getNumericID()) {
                    case ELLayerTokenContext.METHOD_ID:
			return new Coloring(boldFont, Coloring.FONT_MODE_APPLY_STYLE,
                            null, new Color(253, 242, 196));
			//253, 242, 196
                }

            } else { // printing set
                switch (tokenIDOrCategory.getNumericID()) {
                    case ELLayerTokenContext.METHOD_ID:
                        return italicSubst;

                    default:
                         return SettingsUtil.defaultPrintColoringEvaluator;
                

		}
	    }
            return null;	    
	}
    }

}

