/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.search.types;


import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


/**
 * Test DataObject loader match.
 *
 * @author  Petr Kuzel
 * @author  Marian Petras
 */
public class ObjectTypeType extends DataObjectType {

    private static final long serialVersionUID = 1L;
    //private static final long serialVersionUID = -8014986485098211562L;

    /** stream replacing. */
    private static final String NAMES_FIELD = "classNames";             //NOI18N
    
    /** Serial persistent fields. */
    private static final ObjectStreamField[] serialPersistentFields
                         = {new ObjectStreamField(NAMES_FIELD, List.class)};

    /** Which classes to search. */
    private transient Class[] mask = new Class[0];
                         

    /**
     */
    protected String displayName() {
        /*
         * For all non-default search types, display name is taken from
         * the search type's bean descriptor. But this search type has
         * no bean descriptor so we must override this method.
         */
        
        return NbBundle.getMessage(ObjectTypeType.class,
                                   "TEXT_OBJECTTYPE_CRITERION");        //NOI18N
    }

    /** Test whether this data object meets criteria. */
    public boolean testDataObject(DataObject dataObject) {
        Class ld = dataObject.getLoader().getClass();

        for (int i = 0; i < mask.length; i++) {
            if (mask[i].isAssignableFrom(ld)) {
                return true;
            }
        }

        return false;
    }

    /** Setter for mask property. */
    public void setMask(Class[] mask) {
        this.mask = mask;
        firePropertyChange("mask", null, null); // NOI18N

        setValid(this.mask.length != 0);
    }

    /** Getter for mask property. */
    public Class[] getMask() {
        return mask;
    }
    
    /** Setter for mask property. */
    public void setMask(int i, Class m) {
        mask[i] = m;
        firePropertyChange("mask", null, null);  // NOI18N
        setValid(true);
    }
    
    /** Getter for mask property. */
    public Class getMask(int i) {
        return mask[i];
    }

    /** Gets help context for this search type.
     * Implements superclass abstract method. */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ObjectTypeType.class);
    }
    
    /** Store itself as sequence of class names. */
    private void writeObject(ObjectOutputStream out) throws IOException {
        List classNames = new ArrayList(mask == null ? 0 : mask.length);
        
        if (mask != null) {
            for (int i = 0; i < mask.length; i++) {
                if (mask[i] == null) {
                    continue;
                }
                
                classNames.add(mask[i].getName());
            }
        }
        
        out.putFields().put(NAMES_FIELD, classNames);
        out.writeFields();
    }

    /** Restore itself from sequence of class names. */
    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        List classNames = (List) in.readFields().get(NAMES_FIELD, new ArrayList());

        // fill mask array
        List classes = new ArrayList(classNames.size());
        ClassLoader classLoader = (ClassLoader)
                                  org.openide.util.Lookup.getDefault()
                                  .lookup(ClassLoader.class);
        
        Iterator it = classNames.iterator();
        while (it.hasNext()) {
            try {
                classes.add(Class.forName((String) it.next(),
                                          false,
                                          classLoader));
            } catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        
        mask = new Class[classes.size()];
        classes.toArray(mask);

        setValid(false);
    }
    
}
