/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.search.types;


import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


/**
 * Test DataObject name. Reuse TextType.
 *
 * @author  Petr Kuzel
 * @author  Marian Petras
 */
public class ObjectNameType extends TextType {

    private static final long serialVersionUID = 1L;
    //private static final long serialVersionUID = -115010367764914296L;

    
    /**
     */
    protected String displayName() {
        /*
         * For all non-default search types, display name is taken from
         * the search type's bean descriptor. But this search type has
         * no bean descriptor so we must override this method.
         */
        
        return NbBundle.getMessage(ObjectNameType.class,
                                   "TEXT_OBJECTNAME_CRITERION");        //NOI18N
    }

    /**
     * @return true if object passes the test.
     */
    public boolean testDataObject(DataObject dobj) {
        String name = dobj.getName();
        return (name != null) && match(name);
    }
    
    /** Get help context for this search type.
     * Implements superclass abstract method. */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ObjectNameType.class);
    }
}
