/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.search.types;


import java.util.List;
import java.util.LinkedList;
import java.util.Collections;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openidex.search.SearchPattern;


/**
 * Customizer for <code>ObjectNameType</code> search type.
 *
 * @author  Petr Kuzel
 */
public class ObjectNameCustomizer extends TextCustomizer {

    /** Creates new ObjectNameCustomizer */
    public ObjectNameCustomizer() {
        HelpCtx.setHelpIDString(this, ObjectNameType.class.toString());
    }

    /** Reuse text customizer. */
    protected String getBorderLabel() {
        return NbBundle.getBundle(ObjectNameCustomizer.class)
                       .getString("TEXT_LABEL_NAME_CONTAINS");          //NOI18N
    }

    
    private static int MAX_SEARCH_HISTORY_LENGTH = 50;
    private static LinkedList searchPatterns = new LinkedList();
    /** 
     * Returns an unmodifiable List of SearchPatterns. 
     * By default, history is stored locally and not serialized between sessions.
     *
     * @return unmodifiable List of SearchPatterns 
     */
    protected List/*<SearchPattern>*/ getSearchPatterns() {
        return Collections.unmodifiableList(searchPatterns);
    }
    
    /** Adds SearchPattern to SearchHistory 
     *  @param pattern the SearchPattern to add
     */
    protected void addSearchPattern(SearchPattern pattern) {
        while (searchPatterns.size() > MAX_SEARCH_HISTORY_LENGTH-1) 
            searchPatterns.removeLast();
        searchPatterns.addFirst(pattern);       
    }
    
}
