/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.search.types;


import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.UIManager;

import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


/**
 * Customizer of criterion for testing date of primary file modification.
 *
 * @author  Petr Kuzel
 * @author  Marian Petras
 */
public class ModificationDateCustomizer extends JPanel
                                        implements Customizer,
                                                   KeyListener,
                                                   ActionListener {

    private ModificationDateType peer;
    private String lastDays = "";
    private String lastBefore = "";
    private String lastAfter = "";

    /** Creates new form ModificationDateCustomizer */
    public ModificationDateCustomizer() {

        initComponents ();   
        initAccessibility();
        TitledBorder tb = new TitledBorder(
            NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_LABEL_MODIFIED")); // NOI18N
        
        tb.setBorder(new CompoundBorder());
        setBorder (tb);
        
        ButtonGroup group = new ButtonGroup();
        group.add(daysRadioButton);
        group.add(betweenRadioButton);

        HelpCtx.setHelpIDString(this, ModificationDateType.class.toString());
    }

    /** Initialize customizer state.
    */
    public void setObject(final Object obj) {

        peer = (ModificationDateType) obj;

        // set default coloring
        daysTextField.setForeground(getForegroundColor());
        afterTextField.setForeground(getForegroundColor());
        beforeTextField.setForeground(getForegroundColor());

        daysTextField.setText(""); // NOI18N
        afterTextField.setText(""); // NOI18N
        beforeTextField.setText(""); // NOI18N


        // display object value in customizer
        if(!"".equals(peer.getMatchAfter())) { // NOI18N
            afterTextField.setText(peer.getMatchAfter());
            if(!peer.getMatchAfter().equals(null))
                betweenRadioButton.setSelected(true);
        }

        if(!"".equals(peer.getMatchBefore())) { // NOI18N
            beforeTextField.setText(peer.getMatchBefore());
            if(!peer.getMatchAfter().equals(null))
                betweenRadioButton.setSelected(true);
        }

        if(!"".equals(peer.getDays())) { // NOI18N
            daysTextField.setText(peer.getDays());
            daysRadioButton.setSelected(true);
        }

    }

    public void addPropertyChangeListener(final PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(final PropertyChangeListener p1) {
    }


     private void initAccessibility(){      
        ResourceBundle bundle = NbBundle.getBundle(ModificationDateCustomizer.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_Dates"));
        daysTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_DURING_DAYS"));
        daysTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DURING_DAYS"));
        daysTextField.setToolTipText(bundle.getString("ACSD_DURING_DAYS"));
        afterTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_AFTER")); 
        afterTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AFTER")); 
        afterTextField.setToolTipText(bundle.getString("TOOLTIP_AFTER"));
        beforeTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_BEFORE")); 
        beforeTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BEFORE")); 
        beforeTextField.setToolTipText(bundle.getString("ACSD_BEFORE"));
        daysRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TEXT_BUTTON_PRECEDING"));
        daysRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TEXT_BUTTON_PRECEDING")); 
        betweenRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TEXT_BUTTON_RANGE"));
        betweenRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TEXT_BUTTON_RANGE")); 
    }
     
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        daysLabel = new javax.swing.JLabel();
        beginLabel = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        egLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        daysRadioButton.setSelected(true);
        Mnemonics.setLocalizedText(daysRadioButton, NbBundle.getMessage(ModificationDateCustomizer.class, "TEXT_BUTTON_PRECEDING"));  //NOI18N
        daysRadioButton.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 0, 4);
        add(daysRadioButton, gridBagConstraints);

        daysLabel.setText(NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_LABEL_DURING_LAST"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(daysLabel, gridBagConstraints);

        daysTextField.setPreferredSize(new java.awt.Dimension (50, daysTextField.getPreferredSize ().height));
        daysTextField.addKeyListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(daysTextField, gridBagConstraints);

        Mnemonics.setLocalizedText(betweenRadioButton, NbBundle.getMessage(ModificationDateCustomizer.class, "TEXT_BUTTON_RANGE"));  //NOI18N
        betweenRadioButton.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 0, 4);
        add(betweenRadioButton, gridBagConstraints);

        beginLabel.setLabelFor(beforeTextField);
        Mnemonics.setLocalizedText(beginLabel, NbBundle.getMessage(ModificationDateCustomizer.class, "TEXT_LABEL_BEGIN_DATE"));  //NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(beginLabel, gridBagConstraints);

        afterTextField.setPreferredSize(new java.awt.Dimension (100, afterTextField.getPreferredSize ().height));
        afterTextField.addKeyListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 4);
        add(afterTextField, gridBagConstraints);

        beforeTextField.setPreferredSize(new java.awt.Dimension (100, beforeTextField.getPreferredSize ().height));
        beforeTextField.addKeyListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 12);
        add(beforeTextField, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

        egLabel.setText(NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_DATE_EXAMPLE") + new ModificationDateType.FormattedDate(new Date()).toString());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 8, 0, 0);
        add(egLabel, gridBagConstraints);

    }//GEN-END:initComponents

    /**
     * This method is called when one of the two radio buttons is selected.
     * It updates the search type according to the change of the selection.
     */
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        
        if (source == daysRadioButton) {
            setDays();
        } else if (source == betweenRadioButton) {
            setBetween();
        } else {
            
            /* This should never happen. */
            assert false;
        }
    }
    
    /**
     * This method is called when a key is released in some of this customizer's
     * text fields.
     * It checks whether the text within the text field has changed and updates
     * the search type if so.
     */
    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        
        if (source == daysTextField) {
            daysTextFieldKeyReleased();
        } else if (source == afterTextField) {
            afterTextFieldKeyReleased();
        } else if (source == beforeTextField) {
            beforeTextFieldKeyReleased();
        } else {
            
            /* This should never happen. */
            assert false;
        }
    }
    
    /**
     * This method is called when a key is pressed in some of this customizer's
     * text fields.
     * It does nothing and it is here just because this class declares that
     * it implements the <code>KeyListener</code> interface.
     *
     * @see  #keyReleased(KeyEvent)
     */
    public void keyPressed(KeyEvent e) {
        //does nothing
    }
    
    /**
     * This method is called when a key is typed in some of this customizer's
     * text fields.
     * It does nothing and it is here just because this class declares that
     * it implements the <code>KeyListener</code> interface.
     *
     * @see  #keyReleased(KeyEvent)
     */
    public void keyTyped(KeyEvent e) {
        //does nothing
    }
    
    /**
     * This method is called when a key is released in the
     * <em>Within the Past:</em> text field.
     * It checks whether the text within the text field has changed and updates
     * the search type if so.
     */
    private void daysTextFieldKeyReleased() {
        String text = daysTextField.getText();
        if (!text.equals(lastDays)) {
            setDays();
            daysRadioButton.setSelected(true);
            lastDays = text;
        }
    }
    
    /**
     * This method is called when a key is released in the
     * <em>Before:</em> text field.
     * It checks whether the text within the text field has changed and updates
     * the search type if so.
     */
    private void afterTextFieldKeyReleased() {
        String text = afterTextField.getText();
        if (!text.equals(lastAfter)) {
            setBetween();
            betweenRadioButton.setSelected(true);
            lastAfter = text;
        }
    }
    
    /**
     * This method is called when a key is released in the
     * <em>(Before ...) and</em> text field.
     * It checks whether the text within the text field has changed and updates
     * the search type if so.
     */
    private void beforeTextFieldKeyReleased() {
        String text = beforeTextField.getText();
        if (!text.equals(lastBefore)) {
            setBetween();
            betweenRadioButton.setSelected(true);
            lastBefore = text;
        }
    }
    
    private void setDays() {

        String text = daysTextField.getText();
        try {
            peer.setDays(text);
            daysTextField.setForeground(getForegroundColor());
        } catch (IllegalArgumentException ex) {
            daysTextField.setForeground(getErrorForegroundColor());
        }
    }

    private void setAfter () {

        String after = afterTextField.getText();

        try {
            peer.setMatchAfter(after);
            afterTextField.setForeground(getForegroundColor());
        } catch (IllegalArgumentException ex) {
            afterTextField.setForeground(getErrorForegroundColor());
        }

    }

    private void setBefore () {

        String before = beforeTextField.getText();

        try {
            peer.setMatchBefore(before);
            beforeTextField.setForeground(getForegroundColor());
        } catch (IllegalArgumentException ex) {
            beforeTextField.setForeground(getErrorForegroundColor());
        }

    }

    private void setBetween () {
        String after = afterTextField.getText();
        if ( after.length() != 0 ) {
            setAfter();
        }
        setBefore();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private final javax.swing.JTextField afterTextField = new javax.swing.JTextField();
    private final javax.swing.JTextField beforeTextField = new javax.swing.JTextField();
    private javax.swing.JLabel beginLabel;
    private final javax.swing.JRadioButton betweenRadioButton = new javax.swing.JRadioButton();
    private javax.swing.JLabel daysLabel;
    private final javax.swing.JRadioButton daysRadioButton = new javax.swing.JRadioButton();
    private final javax.swing.JTextField daysTextField = new javax.swing.JTextField();
    private javax.swing.JLabel egLabel;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    public void requestFocus() {
        JTextField tf = betweenRadioButton.isSelected() ?
                          afterTextField : daysTextField;
        int n = tf.getText().length();
        if (n > 0) {
            tf.setCaretPosition(0);
            tf.moveCaretPosition(n);
        }
        tf.requestFocus();
    }


    // colors

    private Color findColor (String key, Color defCol) {
        Color color = UIManager.getDefaults().getColor (key);
        if ( color != null ) {
            return color;
        }
        return defCol;
    }

    private Color getForegroundColor () {
        return findColor ("TextField.foreground", Color.black);
    }

    private Color getErrorForegroundColor () {
        return findColor ("TextField.errorForeground", Color.red);
    }

}
