/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.openfile.cli;

import java.io.File;

/**
 * Communication channel between CLI (classpath) code and rest of module.
 * Register an instance to default lookup.
 * @author Jesse Glick
 */
public interface Callback {
    
    /**
     * Open a file.
     * @param f the file to open
     * @param line a number number, starting at zero (-1 to ignore)
     * @param waiter if not null, notify the waiter when the file is closed
     *               (only applicable if open is successful)
     * @return true on success, false on failure
     */
    boolean open(File f, int line, Waiter waiter);
    
    /**
     * Double-callback to notify the CLI that a file has been opened and closed again.
     */
    interface Waiter {
        
        /**
         * The file has been closed again.
         */
        void done();
        
    }
    
}
