/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5;

import org.netbeans.junit.NbTestCase;

/**
 *
 * @author Radim Kubacki
 */
public class TomcatFactoryTest extends NbTestCase {
    
    public static final String TOMCAT_URI = "tomcat:jakarta-tomcat-5.0.x";
    
    public TomcatFactoryTest (String testName) {
        super (testName);
    }
    
    /** Test of getDisconnectedDeploymentManager method, of class org.netbeans.modules.tomcat5.TomcatFactory. */
    public void testGetDisconnectedDeploymentManager () {
        System.out.println ("testGetDisconnectedDeploymentManager");
        TomcatFactory tf = TomcatFactory.create ();
        try {
            assertNotNull("getDisconnectedDeploymentManager", tf.getDisconnectedDeploymentManager(TOMCAT_URI));
        } catch(Exception ex) {
            fail("getDeploymentManager threw an exception "+ex);
        }
    }
    
    /** Test of getDisplayName method, of class org.netbeans.modules.tomcat5.TomcatFactory. */
    public void testGetDisplayName () {
        System.out.println ("testGetDisplayName");
        assertNotNull ("display name must not be null", TomcatFactory.create ().getDisplayName ());
    }
    
    /** Test of getProductVersion method, of class org.netbeans.modules.tomcat5.TomcatFactory. */
    public void testGetProductVersion () {
        System.out.println ("testGetProductVersion");
        assertNotNull ("product version must not be null", TomcatFactory.create ().getProductVersion ());
    }
    
    /** Test of handlesURI method, of class org.netbeans.modules.tomcat5.TomcatFactory. */
    public void testHandlesURI () {
        System.out.println ("testHandlesURI");
        TomcatFactory tf = TomcatFactory.create ();
        
        assertFalse("handlesURI for null", tf.handlesURI(null));
        assertFalse("handlesURI for bad string", tf.handlesURI("arbitrary string"));
        assertFalse("handlesURI for bad version of Tomcat", tf.handlesURI("tomcat55:home=$bundled_home:base=$bundled_base"));
        assertTrue("handlesURI for tomcat's URI", tf.handlesURI(TOMCAT_URI));
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    
}
