/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.tomcat5.ide.StartTomcat;
import org.openide.ErrorManager;

/** Tests for IDE &amp; Tomcat communication.
 *
 *  Requires running instance of Tomcat with configured manager application
 * available at URL <CODE>http://localhost:8080/manager/</CODE>
 *
 * @author Radim Kubacki
 */
public class DeploymentTest extends NbTestCase {
    
    private TomcatManager tm;
    private StartTomcat st;
    private File datadir;
    
    public DeploymentTest (String testName) {
        super (testName);
    }
    
    protected void setUp () throws Exception {
        super.setUp ();
        tm = (TomcatManager)TomcatFactory55.create().getDeploymentManager(TomcatFactory55Test.TOMCAT_URI, null, null);
        tm.ensureCatalinaBaseReady(); // This causes the base dir to be created if needed
        datadir = getDataDir();
        st = new StartTomcat(tm);
        System.out.println("Starting the Tomcat server");
        st.startDeploymentManager();
        int max = 15;
        boolean isRunning = false;
        for (int i=0; i < max && !isRunning ; i++) {
            isRunning = st.isRunning();
            Thread.sleep(1000);
        }        
    }
    
//    /** Test for deployment and undeployment of web module. */
//    public void testDeploymentOfWar () {
//        File webapp  = new File (datadir, "sample.war");
//        File context = new File (datadir, "samplewar.xml"); // no such file
//        System.out.println("testDistribute (deploy) of "+webapp+" using "+context);
//        ProgressObject po = tm.distribute (tm.getTargets (), webapp, context);
//        try {
//            Thread.sleep (5000);
//        }
//        catch (InterruptedException ie) {
//            // do nothing
//        }
//        TargetModuleID [] tmIDs = po.getResultTargetModuleIDs ();
//        assertTrue ("There should be one result target module", tmIDs != null && tmIDs.length == 1);
//        try {
//            checkResponse (new URL(tmIDs[0].getWebURL ()+"/index.jsp"));
//        } catch (Exception e) {
//            fail (e.getMessage ());
//        }
//
//        ProgressObject po2 = tm.undeploy (tmIDs);
//        try {
//            Thread.sleep (5000);
//        }
//        catch (InterruptedException ie) {
//            // do nothing
//        }
//        try {
//            checkResponse (new URL(tmIDs[0].getWebURL ()+"/index.jsp"));
//            fail ("deployed application is still accessible");
//        } catch (Exception e) {
//            // OK
//            System.out.println("correctly thrown exception: "+e.getMessage ());
//        }
//    }
    
    /** Test for deployment and undeployment of web module. */
    public void testDeploymentOfDirectory () {
        File webapp  = new File (datadir, "sampleweb");
        File context = new File (datadir, "sampleweb.xml");
        System.out.println("testDistribute (install) of "+webapp+" using "+context);
        
        TomcatManagerImpl tmi = new TomcatManagerImpl (tm);
        File contextXml = new File (webapp, "/META-INF/context.xml"); //NOI18N
        tmi.initialDeploy(tm.getTargets()[0], contextXml, webapp);
        
        try {
            Thread.sleep (5000);
        }
        catch (InterruptedException ie) {
            // do nothing
        }
        TargetModuleID [] tmIDs = tmi.getResultTargetModuleIDs ();
        assertTrue ("There should be one result target module", tmIDs != null && tmIDs.length == 1);
        try {
            checkResponse (new URL(tmIDs[0].getWebURL ()+"/index.jsp"));
        } catch (Exception e) {
            fail (e.getMessage ());
        }
        ProgressObject po2 = tm.undeploy (tmIDs);
        try {
            Thread.sleep (5000);
        }
        catch (InterruptedException ie) {
            // do nothing
        }
        try {
            checkResponse (new URL(tmIDs[0].getWebURL ()+"/index.jsp"));
            fail ("deployed application is still accessible");
        } catch (Exception e) {
            // OK
            System.out.println("correctly thrown exception: "+e.getMessage ());
        }
    }
    
    /** Tries to connect to given URL and scans the output whether
     * its first line starts with OK.
     */
    private boolean checkResponse (URL url) throws Exception {
        URLConnection conn = url.openConnection();
        HttpURLConnection hconn = (HttpURLConnection) conn;

        // Set up standard connection characteristics
        hconn.setAllowUserInteraction(false);
        hconn.setUseCaches(false);
        hconn.setDoOutput(false);
        hconn.setRequestMethod("GET");
        // Establish the connection with the server
        hconn.connect();

        // Process the response message
        Reader reader = new InputStreamReader(hconn.getInputStream());
        StringBuffer buff = new StringBuffer();
        String error = null;
        boolean first = true;
        while (true) {
            int ch = reader.read();
            if (ch < 0) {
                break;
            } else if ((ch == '\r') || (ch == '\n')) {
                String line = buff.toString();
                buff.setLength(0);
                // PENDING : fireProgressEvent
                TomcatFactory55.getEM ().log(ErrorManager.INFORMATIONAL, line);
                if (first) {
                    if (!line.startsWith("OK")) {
                        error = line;
                    }
                    first = false;
                }
            } else {
                buff.append((char) ch);
            }
        }
        if (buff.length() > 0) {
            System.out.println(buff);;
        }
        if (buff.length () == 0 && first) {
            // actually bug in Tomcat - after remove there is  empty page returned.
            throw new Exception ("URL stream content is empty");
        }
        if (error != null) {
            throw new Exception ("URL reading failed: "+error);
        }
        return true;
    }
    
    protected void tearDown() throws Exception {
        if (st != null) {
            System.out.println("Stopping the Tomcat server");
            st.stopDeploymentManager();
        }   
    }    
}
