/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5.nodes;

import java.util.TreeSet;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author  Petr Pisl
 */
public class TomcatWebModuleChildren extends Children.Keys {
    
    private static final String WAIT_NODE = "wait_node"; //NOI18N
    private Lookup lookup;
    
    TomcatWebModuleChildren(Lookup lkp) {
        lookup = lkp;
    }
    
    public void updateKeys(){
       TreeSet ts = new TreeSet();
       ts.add(WAIT_NODE);
       
       setKeys(ts); 
       
        RequestProcessor.getDefault().post(new Runnable() {
            public void run () {
                DeploymentManager manager = (DeploymentManager)lookup.lookup(DeploymentManager.class);
                Target target = (Target)lookup.lookup(Target.class);
                TreeSet list = new TreeSet(new TomcatWebModule.TomcatWebModuleComparator());

                if (manager instanceof TomcatManager && target != null){
                    TomcatManager tm = (TomcatManager)manager;

                    if (tm.isSuspended() || !tm.isRunning(true)) {
                        removeNotify();
                        return;
                    }
                    try{
                        TargetModuleID[] modules = manager.getRunningModules(ModuleType.WAR, new Target[]{target}); 
                         for (int i = 0; i < modules.length; i ++){
                             list.add(new TomcatWebModule (manager, (TomcatModule)modules[i], true));
                         }

                         modules = manager.getNonRunningModules(ModuleType.WAR, new Target[]{target}); 
                         for (int i = 0; i < modules.length; i ++){
                             list.add(new TomcatWebModule (manager, (TomcatModule)modules[i], false));
                         }

                       }
                    
                    catch (Exception e) {
                        if (e.getCause() instanceof AuthorizationException) {
                            // connection to tomcat manager has not been allowed
                            String errMsg = NbBundle.getMessage(TomcatWebModuleChildren.class, 
                                    "MSG_AuthorizationFailed");
                            NotifyDescriptor notDesc = new NotifyDescriptor.Message(
                                    errMsg, NotifyDescriptor.ERROR_MESSAGE);
                            DialogDisplayer.getDefault().notify(notDesc);
                        } else {
                            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                        }
                    }
                }

       
               setKeys(list);
       
            }
        }, 0);
       
    }
    
    protected void addNotify() {
        updateKeys();
    }
   
    protected void removeNotify() {
        setKeys(java.util.Collections.EMPTY_SET);
    }
        
    protected org.openide.nodes.Node[] createNodes(Object key) {
        if (key instanceof TomcatWebModule){
            TomcatWebModule tm = (TomcatWebModule)key;
            TomcatWebModuleNode node = new TomcatWebModuleNode(tm);
            tm.setRepresentedNode(node);
            return new Node[]{node};
        }
        if (key instanceof String && key.equals(WAIT_NODE)){
            return new Node[]{createWaitNode ()};
        }
        return null;
    }
    
    /* Creates and returns the instance of the node
    * representing the status 'WAIT' of the node.
    * It is used when it spent more time to create elements hierarchy.
    * @return the wait node.
    */
    private Node createWaitNode () {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(TomcatWebModuleChildren.class, "LBL_WaitNode_DisplayName")); //NOI18N
        n.setIconBaseWithExtension("org/openide/src/resources/wait.gif"); // NOI18N
        return n;
    }
}
