/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.usertasks.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.modules.tasklist.usertasks.Settings;
import org.netbeans.modules.tasklist.usertasks.UTUtils;
import org.netbeans.modules.tasklist.usertasks.UserTaskView;
import org.netbeans.modules.tasklist.usertasks.UserTaskViewRegistry;
import org.netbeans.modules.tasklist.usertasks.model.Duration;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;
import org.netbeans.modules.tasklist.usertasks.model.UserTaskList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

/**
 * Copies todays hours to the clipboard.
 *
 * @author tl
 */
public class CopyHoursToClipboardAction extends AbstractAction 
implements ClipboardOwner {
    private static final long serialVersionUID = 1;

    /**
     * Creates an instance.
     */
    public CopyHoursToClipboardAction() {
        this.putValue(AbstractAction.NAME, 
                NbBundle.getMessage(CopyHoursToClipboardAction.class,
                "CopyHoursToClipboard")); // NOI18N
    }
    
    public void actionPerformed(ActionEvent event) {
        final List t = new ArrayList();
        UserTaskList.UserTaskProcessor p = new UserTaskList.UserTaskProcessor() {
             public void process(UserTask ut) {
                 if (!ut.isSpentTimeComputed() && ut.getSpentTimeToday() != 0)
                     t.add(ut);
             }
        };
        UserTaskView[] utv = UserTaskViewRegistry.getInstance().getAll();
        UTUtils.LOGGER.fine(utv.length + " views found"); // NOI18N
        for (int i = 0; i < utv.length; i++) {
            UserTaskList utl = utv[i].getUserTaskList();
            UserTaskList.processDepthFirst(p, utl.getSubtasks());
        }
        
        final String LS = System.getProperty("line.separator"); // NOI18N
        StringBuffer sb = new StringBuffer();
        int sum = 0;
        for (int i = 0; i < t.size(); i++) {
            UserTask ut = (UserTask) t.get(i);
            int stt = ut.getSpentTimeToday();
            Duration d = new Duration(stt, 24, 5);
            sum += stt;
            sb.append(ut.getSummary() + ": " + d.format());
            sb.append(LS);
        }
        sb.append("-----------------------------------------"); // NOI18N
        sb.append(LS);
        sb.append(NbBundle.getMessage(CopyHoursToClipboardAction.class, 
                "Total", // NOI18N
                new Duration(sum, 24, 5).format()));
        sb.append(LS);
        
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(sb.toString()), this);
    }

    public void lostOwnership(Clipboard clipboard, 
            java.awt.datatransfer.Transferable contents) {
    }
}
